
/**
 * Client
**/

import * as runtime from '@prisma/client/runtime/library.js';
import $Types = runtime.Types // general types
import $Public = runtime.Types.Public
import $Utils = runtime.Types.Utils
import $Extensions = runtime.Types.Extensions
import $Result = runtime.Types.Result

export type PrismaPromise<T> = $Public.PrismaPromise<T>


/**
 * Model Chat
 * 
 */
export type Chat = $Result.DefaultSelection<Prisma.$ChatPayload>
/**
 * Model Contact
 * 
 */
export type Contact = $Result.DefaultSelection<Prisma.$ContactPayload>
/**
 * Model GroupMetadata
 * 
 */
export type GroupMetadata = $Result.DefaultSelection<Prisma.$GroupMetadataPayload>
/**
 * Model Message
 * 
 */
export type Message = $Result.DefaultSelection<Prisma.$MessagePayload>
/**
 * Model Session
 * 
 */
export type Session = $Result.DefaultSelection<Prisma.$SessionPayload>

/**
 * ##  Prisma Client ʲˢ
 *
 * Type-safe database client for TypeScript & Node.js
 * @example
 * ```
 * const prisma = new PrismaClient()
 * // Fetch zero or more Chats
 * const chats = await prisma.chat.findMany()
 * ```
 *
 *
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */
export class PrismaClient<
  ClientOptions extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  U = 'log' extends keyof ClientOptions ? ClientOptions['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<ClientOptions['log']> : never : never,
  ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs
> {
  [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['other'] }

    /**
   * ##  Prisma Client ʲˢ
   *
   * Type-safe database client for TypeScript & Node.js
   * @example
   * ```
   * const prisma = new PrismaClient()
   * // Fetch zero or more Chats
   * const chats = await prisma.chat.findMany()
   * ```
   *
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
   */

  constructor(optionsArg ?: Prisma.Subset<ClientOptions, Prisma.PrismaClientOptions>);
  $on<V extends U>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : Prisma.LogEvent) => void): PrismaClient;

  /**
   * Connect with the database
   */
  $connect(): $Utils.JsPromise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): $Utils.JsPromise<void>;

  /**
   * Add a middleware
   * @deprecated since 4.16.0. For new code, prefer client extensions instead.
   * @see https://pris.ly/d/extensions
   */
  $use(cb: Prisma.Middleware): void

/**
   * Executes a prepared raw query and returns the number of affected rows.
   * @example
   * ```
   * const result = await prisma.$executeRaw`UPDATE User SET cool = ${true} WHERE email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Executes a raw query and returns the number of affected rows.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$executeRawUnsafe('UPDATE User SET cool = $1 WHERE email = $2 ;', true, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Performs a prepared raw query and returns the `SELECT` data.
   * @example
   * ```
   * const result = await prisma.$queryRaw`SELECT * FROM User WHERE id = ${1} OR email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Performs a raw query and returns the `SELECT` data.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$queryRawUnsafe('SELECT * FROM User WHERE id = $1 OR email = $2;', 1, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<T>;


  /**
   * Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
   * @example
   * ```
   * const [george, bob, alice] = await prisma.$transaction([
   *   prisma.user.create({ data: { name: 'George' } }),
   *   prisma.user.create({ data: { name: 'Bob' } }),
   *   prisma.user.create({ data: { name: 'Alice' } }),
   * ])
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
   */
  $transaction<P extends Prisma.PrismaPromise<any>[]>(arg: [...P], options?: { isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<runtime.Types.Utils.UnwrapTuple<P>>

  $transaction<R>(fn: (prisma: Omit<PrismaClient, runtime.ITXClientDenyList>) => $Utils.JsPromise<R>, options?: { maxWait?: number, timeout?: number, isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<R>


  $extends: $Extensions.ExtendsHook<"extends", Prisma.TypeMapCb<ClientOptions>, ExtArgs, $Utils.Call<Prisma.TypeMapCb<ClientOptions>, {
    extArgs: ExtArgs
  }>>

      /**
   * `prisma.chat`: Exposes CRUD operations for the **Chat** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Chats
    * const chats = await prisma.chat.findMany()
    * ```
    */
  get chat(): Prisma.ChatDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.contact`: Exposes CRUD operations for the **Contact** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Contacts
    * const contacts = await prisma.contact.findMany()
    * ```
    */
  get contact(): Prisma.ContactDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.groupMetadata`: Exposes CRUD operations for the **GroupMetadata** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more GroupMetadata
    * const groupMetadata = await prisma.groupMetadata.findMany()
    * ```
    */
  get groupMetadata(): Prisma.GroupMetadataDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.message`: Exposes CRUD operations for the **Message** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Messages
    * const messages = await prisma.message.findMany()
    * ```
    */
  get message(): Prisma.MessageDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.session`: Exposes CRUD operations for the **Session** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Sessions
    * const sessions = await prisma.session.findMany()
    * ```
    */
  get session(): Prisma.SessionDelegate<ExtArgs, ClientOptions>;
}

export namespace Prisma {
  export import DMMF = runtime.DMMF

  export type PrismaPromise<T> = $Public.PrismaPromise<T>

  /**
   * Validator
   */
  export import validator = runtime.Public.validator

  /**
   * Prisma Errors
   */
  export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
  export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
  export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
  export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
  export import PrismaClientValidationError = runtime.PrismaClientValidationError

  /**
   * Re-export of sql-template-tag
   */
  export import sql = runtime.sqltag
  export import empty = runtime.empty
  export import join = runtime.join
  export import raw = runtime.raw
  export import Sql = runtime.Sql



  /**
   * Decimal.js
   */
  export import Decimal = runtime.Decimal

  export type DecimalJsLike = runtime.DecimalJsLike

  /**
   * Metrics
   */
  export type Metrics = runtime.Metrics
  export type Metric<T> = runtime.Metric<T>
  export type MetricHistogram = runtime.MetricHistogram
  export type MetricHistogramBucket = runtime.MetricHistogramBucket

  /**
  * Extensions
  */
  export import Extension = $Extensions.UserArgs
  export import getExtensionContext = runtime.Extensions.getExtensionContext
  export import Args = $Public.Args
  export import Payload = $Public.Payload
  export import Result = $Public.Result
  export import Exact = $Public.Exact

  /**
   * Prisma Client JS version: 6.10.1
   * Query Engine version: 9b628578b3b7cae625e8c927178f15a170e74a9c
   */
  export type PrismaVersion = {
    client: string
  }

  export const prismaVersion: PrismaVersion

  /**
   * Utility Types
   */


  export import JsonObject = runtime.JsonObject
  export import JsonArray = runtime.JsonArray
  export import JsonValue = runtime.JsonValue
  export import InputJsonObject = runtime.InputJsonObject
  export import InputJsonArray = runtime.InputJsonArray
  export import InputJsonValue = runtime.InputJsonValue

  /**
   * Types of the values used to represent different kinds of `null` values when working with JSON fields.
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  namespace NullTypes {
    /**
    * Type of `Prisma.DbNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.DbNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class DbNull {
      private DbNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.JsonNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.JsonNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class JsonNull {
      private JsonNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.AnyNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.AnyNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class AnyNull {
      private AnyNull: never
      private constructor()
    }
  }

  /**
   * Helper for filtering JSON entries that have `null` on the database (empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const DbNull: NullTypes.DbNull

  /**
   * Helper for filtering JSON entries that have JSON `null` values (not empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const JsonNull: NullTypes.JsonNull

  /**
   * Helper for filtering JSON entries that are `Prisma.DbNull` or `Prisma.JsonNull`
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const AnyNull: NullTypes.AnyNull

  type SelectAndInclude = {
    select: any
    include: any
  }

  type SelectAndOmit = {
    select: any
    omit: any
  }

  /**
   * Get the type of the value, that the Promise holds.
   */
  export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

  /**
   * Get the return type of a function which returns a Promise.
   */
  export type PromiseReturnType<T extends (...args: any) => $Utils.JsPromise<any>> = PromiseType<ReturnType<T>>

  /**
   * From T, pick a set of properties whose keys are in the union K
   */
  type Prisma__Pick<T, K extends keyof T> = {
      [P in K]: T[P];
  };


  export type Enumerable<T> = T | Array<T>;

  export type RequiredKeys<T> = {
    [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
  }[keyof T]

  export type TruthyKeys<T> = keyof {
    [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
  }

  export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

  /**
   * Subset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection
   */
  export type Subset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never;
  };

  /**
   * SelectSubset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection.
   * Additionally, it validates, if both select and include are present. If the case, it errors.
   */
  export type SelectSubset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    (T extends SelectAndInclude
      ? 'Please either choose `select` or `include`.'
      : T extends SelectAndOmit
        ? 'Please either choose `select` or `omit`.'
        : {})

  /**
   * Subset + Intersection
   * @desc From `T` pick properties that exist in `U` and intersect `K`
   */
  export type SubsetIntersection<T, U, K> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    K

  type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

  /**
   * XOR is needed to have a real mutually exclusive union type
   * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
   */
  type XOR<T, U> =
    T extends object ?
    U extends object ?
      (Without<T, U> & U) | (Without<U, T> & T)
    : U : T


  /**
   * Is T a Record?
   */
  type IsObject<T extends any> = T extends Array<any>
  ? False
  : T extends Date
  ? False
  : T extends Uint8Array
  ? False
  : T extends BigInt
  ? False
  : T extends object
  ? True
  : False


  /**
   * If it's T[], return T
   */
  export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

  /**
   * From ts-toolbelt
   */

  type __Either<O extends object, K extends Key> = Omit<O, K> &
    {
      // Merge all but K
      [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
    }[K]

  type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

  type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

  type _Either<
    O extends object,
    K extends Key,
    strict extends Boolean
  > = {
    1: EitherStrict<O, K>
    0: EitherLoose<O, K>
  }[strict]

  type Either<
    O extends object,
    K extends Key,
    strict extends Boolean = 1
  > = O extends unknown ? _Either<O, K, strict> : never

  export type Union = any

  type PatchUndefined<O extends object, O1 extends object> = {
    [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
  } & {}

  /** Helper Types for "Merge" **/
  export type IntersectOf<U extends Union> = (
    U extends unknown ? (k: U) => void : never
  ) extends (k: infer I) => void
    ? I
    : never

  export type Overwrite<O extends object, O1 extends object> = {
      [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
  } & {};

  type _Merge<U extends object> = IntersectOf<Overwrite<U, {
      [K in keyof U]-?: At<U, K>;
  }>>;

  type Key = string | number | symbol;
  type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
  type AtStrict<O extends object, K extends Key> = O[K & keyof O];
  type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
  export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
      1: AtStrict<O, K>;
      0: AtLoose<O, K>;
  }[strict];

  export type ComputeRaw<A extends any> = A extends Function ? A : {
    [K in keyof A]: A[K];
  } & {};

  export type OptionalFlat<O> = {
    [K in keyof O]?: O[K];
  } & {};

  type _Record<K extends keyof any, T> = {
    [P in K]: T;
  };

  // cause typescript not to expand types and preserve names
  type NoExpand<T> = T extends unknown ? T : never;

  // this type assumes the passed object is entirely optional
  type AtLeast<O extends object, K extends string> = NoExpand<
    O extends unknown
    ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
      | {[P in keyof O as P extends K ? P : never]-?: O[P]} & O
    : never>;

  type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

  export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
  /** End Helper Types for "Merge" **/

  export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

  /**
  A [[Boolean]]
  */
  export type Boolean = True | False

  // /**
  // 1
  // */
  export type True = 1

  /**
  0
  */
  export type False = 0

  export type Not<B extends Boolean> = {
    0: 1
    1: 0
  }[B]

  export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
    ? 0 // anything `never` is false
    : A1 extends A2
    ? 1
    : 0

  export type Has<U extends Union, U1 extends Union> = Not<
    Extends<Exclude<U1, U>, U1>
  >

  export type Or<B1 extends Boolean, B2 extends Boolean> = {
    0: {
      0: 0
      1: 1
    }
    1: {
      0: 1
      1: 1
    }
  }[B1][B2]

  export type Keys<U extends Union> = U extends unknown ? keyof U : never

  type Cast<A, B> = A extends B ? A : B;

  export const type: unique symbol;



  /**
   * Used by group by
   */

  export type GetScalarType<T, O> = O extends object ? {
    [P in keyof T]: P extends keyof O
      ? O[P]
      : never
  } : never

  type FieldPaths<
    T,
    U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
  > = IsObject<T> extends True ? U : T

  type GetHavingFields<T> = {
    [K in keyof T]: Or<
      Or<Extends<'OR', K>, Extends<'AND', K>>,
      Extends<'NOT', K>
    > extends True
      ? // infer is only needed to not hit TS limit
        // based on the brilliant idea of Pierre-Antoine Mills
        // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
        T[K] extends infer TK
        ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
        : never
      : {} extends FieldPaths<T[K]>
      ? never
      : K
  }[keyof T]

  /**
   * Convert tuple to union
   */
  type _TupleToUnion<T> = T extends (infer E)[] ? E : never
  type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
  type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

  /**
   * Like `Pick`, but additionally can also accept an array of keys
   */
  type PickEnumerable<T, K extends Enumerable<keyof T> | keyof T> = Prisma__Pick<T, MaybeTupleToUnion<K>>

  /**
   * Exclude all keys with underscores
   */
  type ExcludeUnderscoreKeys<T extends string> = T extends `_${string}` ? never : T


  export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

  type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>


  export const ModelName: {
    Chat: 'Chat',
    Contact: 'Contact',
    GroupMetadata: 'GroupMetadata',
    Message: 'Message',
    Session: 'Session'
  };

  export type ModelName = (typeof ModelName)[keyof typeof ModelName]


  export type Datasources = {
    db?: Datasource
  }

  interface TypeMapCb<ClientOptions = {}> extends $Utils.Fn<{extArgs: $Extensions.InternalArgs }, $Utils.Record<string, any>> {
    returns: Prisma.TypeMap<this['params']['extArgs'], ClientOptions extends { omit: infer OmitOptions } ? OmitOptions : {}>
  }

  export type TypeMap<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> = {
    globalOmitOptions: {
      omit: GlobalOmitOptions
    }
    meta: {
      modelProps: "chat" | "contact" | "groupMetadata" | "message" | "session"
      txIsolationLevel: Prisma.TransactionIsolationLevel
    }
    model: {
      Chat: {
        payload: Prisma.$ChatPayload<ExtArgs>
        fields: Prisma.ChatFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ChatFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ChatPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ChatFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ChatPayload>
          }
          findFirst: {
            args: Prisma.ChatFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ChatPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ChatFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ChatPayload>
          }
          findMany: {
            args: Prisma.ChatFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ChatPayload>[]
          }
          create: {
            args: Prisma.ChatCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ChatPayload>
          }
          createMany: {
            args: Prisma.ChatCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ChatDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ChatPayload>
          }
          update: {
            args: Prisma.ChatUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ChatPayload>
          }
          deleteMany: {
            args: Prisma.ChatDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ChatUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ChatUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ChatPayload>
          }
          aggregate: {
            args: Prisma.ChatAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateChat>
          }
          groupBy: {
            args: Prisma.ChatGroupByArgs<ExtArgs>
            result: $Utils.Optional<ChatGroupByOutputType>[]
          }
          count: {
            args: Prisma.ChatCountArgs<ExtArgs>
            result: $Utils.Optional<ChatCountAggregateOutputType> | number
          }
        }
      }
      Contact: {
        payload: Prisma.$ContactPayload<ExtArgs>
        fields: Prisma.ContactFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ContactFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ContactFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload>
          }
          findFirst: {
            args: Prisma.ContactFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ContactFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload>
          }
          findMany: {
            args: Prisma.ContactFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload>[]
          }
          create: {
            args: Prisma.ContactCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload>
          }
          createMany: {
            args: Prisma.ContactCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ContactDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload>
          }
          update: {
            args: Prisma.ContactUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload>
          }
          deleteMany: {
            args: Prisma.ContactDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ContactUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ContactUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ContactPayload>
          }
          aggregate: {
            args: Prisma.ContactAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateContact>
          }
          groupBy: {
            args: Prisma.ContactGroupByArgs<ExtArgs>
            result: $Utils.Optional<ContactGroupByOutputType>[]
          }
          count: {
            args: Prisma.ContactCountArgs<ExtArgs>
            result: $Utils.Optional<ContactCountAggregateOutputType> | number
          }
        }
      }
      GroupMetadata: {
        payload: Prisma.$GroupMetadataPayload<ExtArgs>
        fields: Prisma.GroupMetadataFieldRefs
        operations: {
          findUnique: {
            args: Prisma.GroupMetadataFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupMetadataPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.GroupMetadataFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupMetadataPayload>
          }
          findFirst: {
            args: Prisma.GroupMetadataFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupMetadataPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.GroupMetadataFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupMetadataPayload>
          }
          findMany: {
            args: Prisma.GroupMetadataFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupMetadataPayload>[]
          }
          create: {
            args: Prisma.GroupMetadataCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupMetadataPayload>
          }
          createMany: {
            args: Prisma.GroupMetadataCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.GroupMetadataDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupMetadataPayload>
          }
          update: {
            args: Prisma.GroupMetadataUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupMetadataPayload>
          }
          deleteMany: {
            args: Prisma.GroupMetadataDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.GroupMetadataUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.GroupMetadataUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupMetadataPayload>
          }
          aggregate: {
            args: Prisma.GroupMetadataAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateGroupMetadata>
          }
          groupBy: {
            args: Prisma.GroupMetadataGroupByArgs<ExtArgs>
            result: $Utils.Optional<GroupMetadataGroupByOutputType>[]
          }
          count: {
            args: Prisma.GroupMetadataCountArgs<ExtArgs>
            result: $Utils.Optional<GroupMetadataCountAggregateOutputType> | number
          }
        }
      }
      Message: {
        payload: Prisma.$MessagePayload<ExtArgs>
        fields: Prisma.MessageFieldRefs
        operations: {
          findUnique: {
            args: Prisma.MessageFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MessagePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.MessageFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MessagePayload>
          }
          findFirst: {
            args: Prisma.MessageFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MessagePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.MessageFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MessagePayload>
          }
          findMany: {
            args: Prisma.MessageFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MessagePayload>[]
          }
          create: {
            args: Prisma.MessageCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MessagePayload>
          }
          createMany: {
            args: Prisma.MessageCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.MessageDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MessagePayload>
          }
          update: {
            args: Prisma.MessageUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MessagePayload>
          }
          deleteMany: {
            args: Prisma.MessageDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.MessageUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.MessageUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$MessagePayload>
          }
          aggregate: {
            args: Prisma.MessageAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateMessage>
          }
          groupBy: {
            args: Prisma.MessageGroupByArgs<ExtArgs>
            result: $Utils.Optional<MessageGroupByOutputType>[]
          }
          count: {
            args: Prisma.MessageCountArgs<ExtArgs>
            result: $Utils.Optional<MessageCountAggregateOutputType> | number
          }
        }
      }
      Session: {
        payload: Prisma.$SessionPayload<ExtArgs>
        fields: Prisma.SessionFieldRefs
        operations: {
          findUnique: {
            args: Prisma.SessionFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.SessionFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          findFirst: {
            args: Prisma.SessionFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.SessionFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          findMany: {
            args: Prisma.SessionFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>[]
          }
          create: {
            args: Prisma.SessionCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          createMany: {
            args: Prisma.SessionCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.SessionDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          update: {
            args: Prisma.SessionUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          deleteMany: {
            args: Prisma.SessionDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.SessionUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.SessionUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          aggregate: {
            args: Prisma.SessionAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateSession>
          }
          groupBy: {
            args: Prisma.SessionGroupByArgs<ExtArgs>
            result: $Utils.Optional<SessionGroupByOutputType>[]
          }
          count: {
            args: Prisma.SessionCountArgs<ExtArgs>
            result: $Utils.Optional<SessionCountAggregateOutputType> | number
          }
        }
      }
    }
  } & {
    other: {
      payload: any
      operations: {
        $executeRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $executeRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $queryRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $queryRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
      }
    }
  }
  export const defineExtension: $Extensions.ExtendsHook<"define", Prisma.TypeMapCb, $Extensions.DefaultArgs>
  export type DefaultPrismaClient = PrismaClient
  export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'
  export interface PrismaClientOptions {
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasources?: Datasources
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasourceUrl?: string
    /**
     * @default "colorless"
     */
    errorFormat?: ErrorFormat
    /**
     * @example
     * ```
     * // Defaults to stdout
     * log: ['query', 'info', 'warn', 'error']
     * 
     * // Emit as events
     * log: [
     *   { emit: 'stdout', level: 'query' },
     *   { emit: 'stdout', level: 'info' },
     *   { emit: 'stdout', level: 'warn' }
     *   { emit: 'stdout', level: 'error' }
     * ]
     * ```
     * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
     */
    log?: (LogLevel | LogDefinition)[]
    /**
     * The default values for transactionOptions
     * maxWait ?= 2000
     * timeout ?= 5000
     */
    transactionOptions?: {
      maxWait?: number
      timeout?: number
      isolationLevel?: Prisma.TransactionIsolationLevel
    }
    /**
     * Global configuration for omitting model fields by default.
     * 
     * @example
     * ```
     * const prisma = new PrismaClient({
     *   omit: {
     *     user: {
     *       password: true
     *     }
     *   }
     * })
     * ```
     */
    omit?: Prisma.GlobalOmitConfig
  }
  export type GlobalOmitConfig = {
    chat?: ChatOmit
    contact?: ContactOmit
    groupMetadata?: GroupMetadataOmit
    message?: MessageOmit
    session?: SessionOmit
  }

  /* Types for Logging */
  export type LogLevel = 'info' | 'query' | 'warn' | 'error'
  export type LogDefinition = {
    level: LogLevel
    emit: 'stdout' | 'event'
  }

  export type GetLogType<T extends LogLevel | LogDefinition> = T extends LogDefinition ? T['emit'] extends 'event' ? T['level'] : never : never
  export type GetEvents<T extends any> = T extends Array<LogLevel | LogDefinition> ?
    GetLogType<T[0]> | GetLogType<T[1]> | GetLogType<T[2]> | GetLogType<T[3]>
    : never

  export type QueryEvent = {
    timestamp: Date
    query: string
    params: string
    duration: number
    target: string
  }

  export type LogEvent = {
    timestamp: Date
    message: string
    target: string
  }
  /* End Types for Logging */


  export type PrismaAction =
    | 'findUnique'
    | 'findUniqueOrThrow'
    | 'findMany'
    | 'findFirst'
    | 'findFirstOrThrow'
    | 'create'
    | 'createMany'
    | 'createManyAndReturn'
    | 'update'
    | 'updateMany'
    | 'updateManyAndReturn'
    | 'upsert'
    | 'delete'
    | 'deleteMany'
    | 'executeRaw'
    | 'queryRaw'
    | 'aggregate'
    | 'count'
    | 'runCommandRaw'
    | 'findRaw'
    | 'groupBy'

  /**
   * These options are being passed into the middleware as "params"
   */
  export type MiddlewareParams = {
    model?: ModelName
    action: PrismaAction
    args: any
    dataPath: string[]
    runInTransaction: boolean
  }

  /**
   * The `T` type makes sure, that the `return proceed` is not forgotten in the middleware implementation
   */
  export type Middleware<T = any> = (
    params: MiddlewareParams,
    next: (params: MiddlewareParams) => $Utils.JsPromise<T>,
  ) => $Utils.JsPromise<T>

  // tested in getLogLevel.test.ts
  export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

  /**
   * `PrismaClient` proxy available in interactive transactions.
   */
  export type TransactionClient = Omit<Prisma.DefaultPrismaClient, runtime.ITXClientDenyList>

  export type Datasource = {
    url?: string
  }

  /**
   * Count Types
   */



  /**
   * Models
   */

  /**
   * Model Chat
   */

  export type AggregateChat = {
    _count: ChatCountAggregateOutputType | null
    _avg: ChatAvgAggregateOutputType | null
    _sum: ChatSumAggregateOutputType | null
    _min: ChatMinAggregateOutputType | null
    _max: ChatMaxAggregateOutputType | null
  }

  export type ChatAvgAggregateOutputType = {
    pkId: number | null
    conversationTimestamp: number | null
    createdAt: number | null
    endOfHistoryTransferType: number | null
    ephemeralExpiration: number | null
    ephemeralSettingTimestamp: number | null
    lastMsgTimestamp: number | null
    mediaVisibility: number | null
    muteEndTime: number | null
    pinned: number | null
    tcTokenSenderTimestamp: number | null
    tcTokenTimestamp: number | null
    unreadCount: number | null
    unreadMentionCount: number | null
    lastMessageRecvTimestamp: number | null
    commentsCount: number | null
    badge_id: number | null
  }

  export type ChatSumAggregateOutputType = {
    pkId: number | null
    conversationTimestamp: bigint | null
    createdAt: bigint | null
    endOfHistoryTransferType: number | null
    ephemeralExpiration: number | null
    ephemeralSettingTimestamp: bigint | null
    lastMsgTimestamp: bigint | null
    mediaVisibility: number | null
    muteEndTime: bigint | null
    pinned: bigint | null
    tcTokenSenderTimestamp: bigint | null
    tcTokenTimestamp: bigint | null
    unreadCount: number | null
    unreadMentionCount: number | null
    lastMessageRecvTimestamp: number | null
    commentsCount: number | null
    badge_id: number | null
  }

  export type ChatMinAggregateOutputType = {
    pkId: number | null
    sessionId: string | null
    archived: boolean | null
    contactPrimaryIdentityKey: Uint8Array | null
    conversationTimestamp: bigint | null
    createdAt: bigint | null
    createdBy: string | null
    description: string | null
    displayName: string | null
    endOfHistoryTransfer: boolean | null
    endOfHistoryTransferType: number | null
    ephemeralExpiration: number | null
    ephemeralSettingTimestamp: bigint | null
    id: string | null
    isDefaultSubgroup: boolean | null
    isParentGroup: boolean | null
    lastMsgTimestamp: bigint | null
    lidJid: string | null
    markedAsUnread: boolean | null
    mediaVisibility: number | null
    muteEndTime: bigint | null
    name: string | null
    newJid: string | null
    notSpam: boolean | null
    oldJid: string | null
    pHash: string | null
    parentGroupId: string | null
    pinned: bigint | null
    pnJid: string | null
    pnhDuplicateLidThread: boolean | null
    readOnly: boolean | null
    shareOwnPn: boolean | null
    support: boolean | null
    suspended: boolean | null
    tcToken: Uint8Array | null
    tcTokenSenderTimestamp: bigint | null
    tcTokenTimestamp: bigint | null
    terminated: boolean | null
    unreadCount: number | null
    unreadMentionCount: number | null
    lastMessageRecvTimestamp: number | null
    commentsCount: number | null
    picture: string | null
    auto_reply_enabled: boolean | null
    badge_id: number | null
  }

  export type ChatMaxAggregateOutputType = {
    pkId: number | null
    sessionId: string | null
    archived: boolean | null
    contactPrimaryIdentityKey: Uint8Array | null
    conversationTimestamp: bigint | null
    createdAt: bigint | null
    createdBy: string | null
    description: string | null
    displayName: string | null
    endOfHistoryTransfer: boolean | null
    endOfHistoryTransferType: number | null
    ephemeralExpiration: number | null
    ephemeralSettingTimestamp: bigint | null
    id: string | null
    isDefaultSubgroup: boolean | null
    isParentGroup: boolean | null
    lastMsgTimestamp: bigint | null
    lidJid: string | null
    markedAsUnread: boolean | null
    mediaVisibility: number | null
    muteEndTime: bigint | null
    name: string | null
    newJid: string | null
    notSpam: boolean | null
    oldJid: string | null
    pHash: string | null
    parentGroupId: string | null
    pinned: bigint | null
    pnJid: string | null
    pnhDuplicateLidThread: boolean | null
    readOnly: boolean | null
    shareOwnPn: boolean | null
    support: boolean | null
    suspended: boolean | null
    tcToken: Uint8Array | null
    tcTokenSenderTimestamp: bigint | null
    tcTokenTimestamp: bigint | null
    terminated: boolean | null
    unreadCount: number | null
    unreadMentionCount: number | null
    lastMessageRecvTimestamp: number | null
    commentsCount: number | null
    picture: string | null
    auto_reply_enabled: boolean | null
    badge_id: number | null
  }

  export type ChatCountAggregateOutputType = {
    pkId: number
    sessionId: number
    archived: number
    contactPrimaryIdentityKey: number
    conversationTimestamp: number
    createdAt: number
    createdBy: number
    description: number
    disappearingMode: number
    displayName: number
    endOfHistoryTransfer: number
    endOfHistoryTransferType: number
    ephemeralExpiration: number
    ephemeralSettingTimestamp: number
    id: number
    isDefaultSubgroup: number
    isParentGroup: number
    lastMsgTimestamp: number
    lidJid: number
    markedAsUnread: number
    mediaVisibility: number
    messages: number
    muteEndTime: number
    name: number
    newJid: number
    notSpam: number
    oldJid: number
    pHash: number
    parentGroupId: number
    participant: number
    pinned: number
    pnJid: number
    pnhDuplicateLidThread: number
    readOnly: number
    shareOwnPn: number
    support: number
    suspended: number
    tcToken: number
    tcTokenSenderTimestamp: number
    tcTokenTimestamp: number
    terminated: number
    unreadCount: number
    unreadMentionCount: number
    wallpaper: number
    lastMessageRecvTimestamp: number
    commentsCount: number
    picture: number
    auto_reply_enabled: number
    badge_id: number
    _all: number
  }


  export type ChatAvgAggregateInputType = {
    pkId?: true
    conversationTimestamp?: true
    createdAt?: true
    endOfHistoryTransferType?: true
    ephemeralExpiration?: true
    ephemeralSettingTimestamp?: true
    lastMsgTimestamp?: true
    mediaVisibility?: true
    muteEndTime?: true
    pinned?: true
    tcTokenSenderTimestamp?: true
    tcTokenTimestamp?: true
    unreadCount?: true
    unreadMentionCount?: true
    lastMessageRecvTimestamp?: true
    commentsCount?: true
    badge_id?: true
  }

  export type ChatSumAggregateInputType = {
    pkId?: true
    conversationTimestamp?: true
    createdAt?: true
    endOfHistoryTransferType?: true
    ephemeralExpiration?: true
    ephemeralSettingTimestamp?: true
    lastMsgTimestamp?: true
    mediaVisibility?: true
    muteEndTime?: true
    pinned?: true
    tcTokenSenderTimestamp?: true
    tcTokenTimestamp?: true
    unreadCount?: true
    unreadMentionCount?: true
    lastMessageRecvTimestamp?: true
    commentsCount?: true
    badge_id?: true
  }

  export type ChatMinAggregateInputType = {
    pkId?: true
    sessionId?: true
    archived?: true
    contactPrimaryIdentityKey?: true
    conversationTimestamp?: true
    createdAt?: true
    createdBy?: true
    description?: true
    displayName?: true
    endOfHistoryTransfer?: true
    endOfHistoryTransferType?: true
    ephemeralExpiration?: true
    ephemeralSettingTimestamp?: true
    id?: true
    isDefaultSubgroup?: true
    isParentGroup?: true
    lastMsgTimestamp?: true
    lidJid?: true
    markedAsUnread?: true
    mediaVisibility?: true
    muteEndTime?: true
    name?: true
    newJid?: true
    notSpam?: true
    oldJid?: true
    pHash?: true
    parentGroupId?: true
    pinned?: true
    pnJid?: true
    pnhDuplicateLidThread?: true
    readOnly?: true
    shareOwnPn?: true
    support?: true
    suspended?: true
    tcToken?: true
    tcTokenSenderTimestamp?: true
    tcTokenTimestamp?: true
    terminated?: true
    unreadCount?: true
    unreadMentionCount?: true
    lastMessageRecvTimestamp?: true
    commentsCount?: true
    picture?: true
    auto_reply_enabled?: true
    badge_id?: true
  }

  export type ChatMaxAggregateInputType = {
    pkId?: true
    sessionId?: true
    archived?: true
    contactPrimaryIdentityKey?: true
    conversationTimestamp?: true
    createdAt?: true
    createdBy?: true
    description?: true
    displayName?: true
    endOfHistoryTransfer?: true
    endOfHistoryTransferType?: true
    ephemeralExpiration?: true
    ephemeralSettingTimestamp?: true
    id?: true
    isDefaultSubgroup?: true
    isParentGroup?: true
    lastMsgTimestamp?: true
    lidJid?: true
    markedAsUnread?: true
    mediaVisibility?: true
    muteEndTime?: true
    name?: true
    newJid?: true
    notSpam?: true
    oldJid?: true
    pHash?: true
    parentGroupId?: true
    pinned?: true
    pnJid?: true
    pnhDuplicateLidThread?: true
    readOnly?: true
    shareOwnPn?: true
    support?: true
    suspended?: true
    tcToken?: true
    tcTokenSenderTimestamp?: true
    tcTokenTimestamp?: true
    terminated?: true
    unreadCount?: true
    unreadMentionCount?: true
    lastMessageRecvTimestamp?: true
    commentsCount?: true
    picture?: true
    auto_reply_enabled?: true
    badge_id?: true
  }

  export type ChatCountAggregateInputType = {
    pkId?: true
    sessionId?: true
    archived?: true
    contactPrimaryIdentityKey?: true
    conversationTimestamp?: true
    createdAt?: true
    createdBy?: true
    description?: true
    disappearingMode?: true
    displayName?: true
    endOfHistoryTransfer?: true
    endOfHistoryTransferType?: true
    ephemeralExpiration?: true
    ephemeralSettingTimestamp?: true
    id?: true
    isDefaultSubgroup?: true
    isParentGroup?: true
    lastMsgTimestamp?: true
    lidJid?: true
    markedAsUnread?: true
    mediaVisibility?: true
    messages?: true
    muteEndTime?: true
    name?: true
    newJid?: true
    notSpam?: true
    oldJid?: true
    pHash?: true
    parentGroupId?: true
    participant?: true
    pinned?: true
    pnJid?: true
    pnhDuplicateLidThread?: true
    readOnly?: true
    shareOwnPn?: true
    support?: true
    suspended?: true
    tcToken?: true
    tcTokenSenderTimestamp?: true
    tcTokenTimestamp?: true
    terminated?: true
    unreadCount?: true
    unreadMentionCount?: true
    wallpaper?: true
    lastMessageRecvTimestamp?: true
    commentsCount?: true
    picture?: true
    auto_reply_enabled?: true
    badge_id?: true
    _all?: true
  }

  export type ChatAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Chat to aggregate.
     */
    where?: ChatWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Chats to fetch.
     */
    orderBy?: ChatOrderByWithRelationInput | ChatOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ChatWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Chats from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Chats.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Chats
    **/
    _count?: true | ChatCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ChatAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ChatSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ChatMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ChatMaxAggregateInputType
  }

  export type GetChatAggregateType<T extends ChatAggregateArgs> = {
        [P in keyof T & keyof AggregateChat]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateChat[P]>
      : GetScalarType<T[P], AggregateChat[P]>
  }




  export type ChatGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ChatWhereInput
    orderBy?: ChatOrderByWithAggregationInput | ChatOrderByWithAggregationInput[]
    by: ChatScalarFieldEnum[] | ChatScalarFieldEnum
    having?: ChatScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ChatCountAggregateInputType | true
    _avg?: ChatAvgAggregateInputType
    _sum?: ChatSumAggregateInputType
    _min?: ChatMinAggregateInputType
    _max?: ChatMaxAggregateInputType
  }

  export type ChatGroupByOutputType = {
    pkId: number
    sessionId: string
    archived: boolean | null
    contactPrimaryIdentityKey: Uint8Array | null
    conversationTimestamp: bigint | null
    createdAt: bigint | null
    createdBy: string | null
    description: string | null
    disappearingMode: JsonValue | null
    displayName: string | null
    endOfHistoryTransfer: boolean | null
    endOfHistoryTransferType: number | null
    ephemeralExpiration: number | null
    ephemeralSettingTimestamp: bigint | null
    id: string
    isDefaultSubgroup: boolean | null
    isParentGroup: boolean | null
    lastMsgTimestamp: bigint | null
    lidJid: string | null
    markedAsUnread: boolean | null
    mediaVisibility: number | null
    messages: JsonValue | null
    muteEndTime: bigint | null
    name: string | null
    newJid: string | null
    notSpam: boolean | null
    oldJid: string | null
    pHash: string | null
    parentGroupId: string | null
    participant: JsonValue | null
    pinned: bigint | null
    pnJid: string | null
    pnhDuplicateLidThread: boolean | null
    readOnly: boolean | null
    shareOwnPn: boolean | null
    support: boolean | null
    suspended: boolean | null
    tcToken: Uint8Array | null
    tcTokenSenderTimestamp: bigint | null
    tcTokenTimestamp: bigint | null
    terminated: boolean | null
    unreadCount: number | null
    unreadMentionCount: number | null
    wallpaper: JsonValue | null
    lastMessageRecvTimestamp: number | null
    commentsCount: number | null
    picture: string | null
    auto_reply_enabled: boolean | null
    badge_id: number | null
    _count: ChatCountAggregateOutputType | null
    _avg: ChatAvgAggregateOutputType | null
    _sum: ChatSumAggregateOutputType | null
    _min: ChatMinAggregateOutputType | null
    _max: ChatMaxAggregateOutputType | null
  }

  type GetChatGroupByPayload<T extends ChatGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ChatGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ChatGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ChatGroupByOutputType[P]>
            : GetScalarType<T[P], ChatGroupByOutputType[P]>
        }
      >
    >


  export type ChatSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    pkId?: boolean
    sessionId?: boolean
    archived?: boolean
    contactPrimaryIdentityKey?: boolean
    conversationTimestamp?: boolean
    createdAt?: boolean
    createdBy?: boolean
    description?: boolean
    disappearingMode?: boolean
    displayName?: boolean
    endOfHistoryTransfer?: boolean
    endOfHistoryTransferType?: boolean
    ephemeralExpiration?: boolean
    ephemeralSettingTimestamp?: boolean
    id?: boolean
    isDefaultSubgroup?: boolean
    isParentGroup?: boolean
    lastMsgTimestamp?: boolean
    lidJid?: boolean
    markedAsUnread?: boolean
    mediaVisibility?: boolean
    messages?: boolean
    muteEndTime?: boolean
    name?: boolean
    newJid?: boolean
    notSpam?: boolean
    oldJid?: boolean
    pHash?: boolean
    parentGroupId?: boolean
    participant?: boolean
    pinned?: boolean
    pnJid?: boolean
    pnhDuplicateLidThread?: boolean
    readOnly?: boolean
    shareOwnPn?: boolean
    support?: boolean
    suspended?: boolean
    tcToken?: boolean
    tcTokenSenderTimestamp?: boolean
    tcTokenTimestamp?: boolean
    terminated?: boolean
    unreadCount?: boolean
    unreadMentionCount?: boolean
    wallpaper?: boolean
    lastMessageRecvTimestamp?: boolean
    commentsCount?: boolean
    picture?: boolean
    auto_reply_enabled?: boolean
    badge_id?: boolean
  }, ExtArgs["result"]["chat"]>



  export type ChatSelectScalar = {
    pkId?: boolean
    sessionId?: boolean
    archived?: boolean
    contactPrimaryIdentityKey?: boolean
    conversationTimestamp?: boolean
    createdAt?: boolean
    createdBy?: boolean
    description?: boolean
    disappearingMode?: boolean
    displayName?: boolean
    endOfHistoryTransfer?: boolean
    endOfHistoryTransferType?: boolean
    ephemeralExpiration?: boolean
    ephemeralSettingTimestamp?: boolean
    id?: boolean
    isDefaultSubgroup?: boolean
    isParentGroup?: boolean
    lastMsgTimestamp?: boolean
    lidJid?: boolean
    markedAsUnread?: boolean
    mediaVisibility?: boolean
    messages?: boolean
    muteEndTime?: boolean
    name?: boolean
    newJid?: boolean
    notSpam?: boolean
    oldJid?: boolean
    pHash?: boolean
    parentGroupId?: boolean
    participant?: boolean
    pinned?: boolean
    pnJid?: boolean
    pnhDuplicateLidThread?: boolean
    readOnly?: boolean
    shareOwnPn?: boolean
    support?: boolean
    suspended?: boolean
    tcToken?: boolean
    tcTokenSenderTimestamp?: boolean
    tcTokenTimestamp?: boolean
    terminated?: boolean
    unreadCount?: boolean
    unreadMentionCount?: boolean
    wallpaper?: boolean
    lastMessageRecvTimestamp?: boolean
    commentsCount?: boolean
    picture?: boolean
    auto_reply_enabled?: boolean
    badge_id?: boolean
  }

  export type ChatOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"pkId" | "sessionId" | "archived" | "contactPrimaryIdentityKey" | "conversationTimestamp" | "createdAt" | "createdBy" | "description" | "disappearingMode" | "displayName" | "endOfHistoryTransfer" | "endOfHistoryTransferType" | "ephemeralExpiration" | "ephemeralSettingTimestamp" | "id" | "isDefaultSubgroup" | "isParentGroup" | "lastMsgTimestamp" | "lidJid" | "markedAsUnread" | "mediaVisibility" | "messages" | "muteEndTime" | "name" | "newJid" | "notSpam" | "oldJid" | "pHash" | "parentGroupId" | "participant" | "pinned" | "pnJid" | "pnhDuplicateLidThread" | "readOnly" | "shareOwnPn" | "support" | "suspended" | "tcToken" | "tcTokenSenderTimestamp" | "tcTokenTimestamp" | "terminated" | "unreadCount" | "unreadMentionCount" | "wallpaper" | "lastMessageRecvTimestamp" | "commentsCount" | "picture" | "auto_reply_enabled" | "badge_id", ExtArgs["result"]["chat"]>

  export type $ChatPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Chat"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      pkId: number
      sessionId: string
      archived: boolean | null
      contactPrimaryIdentityKey: Uint8Array | null
      conversationTimestamp: bigint | null
      createdAt: bigint | null
      createdBy: string | null
      description: string | null
      disappearingMode: Prisma.JsonValue | null
      displayName: string | null
      endOfHistoryTransfer: boolean | null
      endOfHistoryTransferType: number | null
      ephemeralExpiration: number | null
      ephemeralSettingTimestamp: bigint | null
      id: string
      isDefaultSubgroup: boolean | null
      isParentGroup: boolean | null
      lastMsgTimestamp: bigint | null
      lidJid: string | null
      markedAsUnread: boolean | null
      mediaVisibility: number | null
      messages: Prisma.JsonValue | null
      muteEndTime: bigint | null
      name: string | null
      newJid: string | null
      notSpam: boolean | null
      oldJid: string | null
      pHash: string | null
      parentGroupId: string | null
      participant: Prisma.JsonValue | null
      pinned: bigint | null
      pnJid: string | null
      pnhDuplicateLidThread: boolean | null
      readOnly: boolean | null
      shareOwnPn: boolean | null
      support: boolean | null
      suspended: boolean | null
      tcToken: Uint8Array | null
      tcTokenSenderTimestamp: bigint | null
      tcTokenTimestamp: bigint | null
      terminated: boolean | null
      unreadCount: number | null
      unreadMentionCount: number | null
      wallpaper: Prisma.JsonValue | null
      lastMessageRecvTimestamp: number | null
      commentsCount: number | null
      picture: string | null
      auto_reply_enabled: boolean | null
      badge_id: number | null
    }, ExtArgs["result"]["chat"]>
    composites: {}
  }

  type ChatGetPayload<S extends boolean | null | undefined | ChatDefaultArgs> = $Result.GetResult<Prisma.$ChatPayload, S>

  type ChatCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ChatFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ChatCountAggregateInputType | true
    }

  export interface ChatDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Chat'], meta: { name: 'Chat' } }
    /**
     * Find zero or one Chat that matches the filter.
     * @param {ChatFindUniqueArgs} args - Arguments to find a Chat
     * @example
     * // Get one Chat
     * const chat = await prisma.chat.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ChatFindUniqueArgs>(args: SelectSubset<T, ChatFindUniqueArgs<ExtArgs>>): Prisma__ChatClient<$Result.GetResult<Prisma.$ChatPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Chat that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ChatFindUniqueOrThrowArgs} args - Arguments to find a Chat
     * @example
     * // Get one Chat
     * const chat = await prisma.chat.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ChatFindUniqueOrThrowArgs>(args: SelectSubset<T, ChatFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ChatClient<$Result.GetResult<Prisma.$ChatPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Chat that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ChatFindFirstArgs} args - Arguments to find a Chat
     * @example
     * // Get one Chat
     * const chat = await prisma.chat.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ChatFindFirstArgs>(args?: SelectSubset<T, ChatFindFirstArgs<ExtArgs>>): Prisma__ChatClient<$Result.GetResult<Prisma.$ChatPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Chat that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ChatFindFirstOrThrowArgs} args - Arguments to find a Chat
     * @example
     * // Get one Chat
     * const chat = await prisma.chat.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ChatFindFirstOrThrowArgs>(args?: SelectSubset<T, ChatFindFirstOrThrowArgs<ExtArgs>>): Prisma__ChatClient<$Result.GetResult<Prisma.$ChatPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Chats that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ChatFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Chats
     * const chats = await prisma.chat.findMany()
     * 
     * // Get first 10 Chats
     * const chats = await prisma.chat.findMany({ take: 10 })
     * 
     * // Only select the `pkId`
     * const chatWithPkIdOnly = await prisma.chat.findMany({ select: { pkId: true } })
     * 
     */
    findMany<T extends ChatFindManyArgs>(args?: SelectSubset<T, ChatFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ChatPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Chat.
     * @param {ChatCreateArgs} args - Arguments to create a Chat.
     * @example
     * // Create one Chat
     * const Chat = await prisma.chat.create({
     *   data: {
     *     // ... data to create a Chat
     *   }
     * })
     * 
     */
    create<T extends ChatCreateArgs>(args: SelectSubset<T, ChatCreateArgs<ExtArgs>>): Prisma__ChatClient<$Result.GetResult<Prisma.$ChatPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Chats.
     * @param {ChatCreateManyArgs} args - Arguments to create many Chats.
     * @example
     * // Create many Chats
     * const chat = await prisma.chat.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ChatCreateManyArgs>(args?: SelectSubset<T, ChatCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Chat.
     * @param {ChatDeleteArgs} args - Arguments to delete one Chat.
     * @example
     * // Delete one Chat
     * const Chat = await prisma.chat.delete({
     *   where: {
     *     // ... filter to delete one Chat
     *   }
     * })
     * 
     */
    delete<T extends ChatDeleteArgs>(args: SelectSubset<T, ChatDeleteArgs<ExtArgs>>): Prisma__ChatClient<$Result.GetResult<Prisma.$ChatPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Chat.
     * @param {ChatUpdateArgs} args - Arguments to update one Chat.
     * @example
     * // Update one Chat
     * const chat = await prisma.chat.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ChatUpdateArgs>(args: SelectSubset<T, ChatUpdateArgs<ExtArgs>>): Prisma__ChatClient<$Result.GetResult<Prisma.$ChatPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Chats.
     * @param {ChatDeleteManyArgs} args - Arguments to filter Chats to delete.
     * @example
     * // Delete a few Chats
     * const { count } = await prisma.chat.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ChatDeleteManyArgs>(args?: SelectSubset<T, ChatDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Chats.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ChatUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Chats
     * const chat = await prisma.chat.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ChatUpdateManyArgs>(args: SelectSubset<T, ChatUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Chat.
     * @param {ChatUpsertArgs} args - Arguments to update or create a Chat.
     * @example
     * // Update or create a Chat
     * const chat = await prisma.chat.upsert({
     *   create: {
     *     // ... data to create a Chat
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Chat we want to update
     *   }
     * })
     */
    upsert<T extends ChatUpsertArgs>(args: SelectSubset<T, ChatUpsertArgs<ExtArgs>>): Prisma__ChatClient<$Result.GetResult<Prisma.$ChatPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Chats.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ChatCountArgs} args - Arguments to filter Chats to count.
     * @example
     * // Count the number of Chats
     * const count = await prisma.chat.count({
     *   where: {
     *     // ... the filter for the Chats we want to count
     *   }
     * })
    **/
    count<T extends ChatCountArgs>(
      args?: Subset<T, ChatCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ChatCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Chat.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ChatAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ChatAggregateArgs>(args: Subset<T, ChatAggregateArgs>): Prisma.PrismaPromise<GetChatAggregateType<T>>

    /**
     * Group by Chat.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ChatGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ChatGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ChatGroupByArgs['orderBy'] }
        : { orderBy?: ChatGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ChatGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetChatGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Chat model
   */
  readonly fields: ChatFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Chat.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ChatClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Chat model
   */
  interface ChatFieldRefs {
    readonly pkId: FieldRef<"Chat", 'Int'>
    readonly sessionId: FieldRef<"Chat", 'String'>
    readonly archived: FieldRef<"Chat", 'Boolean'>
    readonly contactPrimaryIdentityKey: FieldRef<"Chat", 'Bytes'>
    readonly conversationTimestamp: FieldRef<"Chat", 'BigInt'>
    readonly createdAt: FieldRef<"Chat", 'BigInt'>
    readonly createdBy: FieldRef<"Chat", 'String'>
    readonly description: FieldRef<"Chat", 'String'>
    readonly disappearingMode: FieldRef<"Chat", 'Json'>
    readonly displayName: FieldRef<"Chat", 'String'>
    readonly endOfHistoryTransfer: FieldRef<"Chat", 'Boolean'>
    readonly endOfHistoryTransferType: FieldRef<"Chat", 'Int'>
    readonly ephemeralExpiration: FieldRef<"Chat", 'Int'>
    readonly ephemeralSettingTimestamp: FieldRef<"Chat", 'BigInt'>
    readonly id: FieldRef<"Chat", 'String'>
    readonly isDefaultSubgroup: FieldRef<"Chat", 'Boolean'>
    readonly isParentGroup: FieldRef<"Chat", 'Boolean'>
    readonly lastMsgTimestamp: FieldRef<"Chat", 'BigInt'>
    readonly lidJid: FieldRef<"Chat", 'String'>
    readonly markedAsUnread: FieldRef<"Chat", 'Boolean'>
    readonly mediaVisibility: FieldRef<"Chat", 'Int'>
    readonly messages: FieldRef<"Chat", 'Json'>
    readonly muteEndTime: FieldRef<"Chat", 'BigInt'>
    readonly name: FieldRef<"Chat", 'String'>
    readonly newJid: FieldRef<"Chat", 'String'>
    readonly notSpam: FieldRef<"Chat", 'Boolean'>
    readonly oldJid: FieldRef<"Chat", 'String'>
    readonly pHash: FieldRef<"Chat", 'String'>
    readonly parentGroupId: FieldRef<"Chat", 'String'>
    readonly participant: FieldRef<"Chat", 'Json'>
    readonly pinned: FieldRef<"Chat", 'BigInt'>
    readonly pnJid: FieldRef<"Chat", 'String'>
    readonly pnhDuplicateLidThread: FieldRef<"Chat", 'Boolean'>
    readonly readOnly: FieldRef<"Chat", 'Boolean'>
    readonly shareOwnPn: FieldRef<"Chat", 'Boolean'>
    readonly support: FieldRef<"Chat", 'Boolean'>
    readonly suspended: FieldRef<"Chat", 'Boolean'>
    readonly tcToken: FieldRef<"Chat", 'Bytes'>
    readonly tcTokenSenderTimestamp: FieldRef<"Chat", 'BigInt'>
    readonly tcTokenTimestamp: FieldRef<"Chat", 'BigInt'>
    readonly terminated: FieldRef<"Chat", 'Boolean'>
    readonly unreadCount: FieldRef<"Chat", 'Int'>
    readonly unreadMentionCount: FieldRef<"Chat", 'Int'>
    readonly wallpaper: FieldRef<"Chat", 'Json'>
    readonly lastMessageRecvTimestamp: FieldRef<"Chat", 'Int'>
    readonly commentsCount: FieldRef<"Chat", 'Int'>
    readonly picture: FieldRef<"Chat", 'String'>
    readonly auto_reply_enabled: FieldRef<"Chat", 'Boolean'>
    readonly badge_id: FieldRef<"Chat", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * Chat findUnique
   */
  export type ChatFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Chat
     */
    select?: ChatSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Chat
     */
    omit?: ChatOmit<ExtArgs> | null
    /**
     * Filter, which Chat to fetch.
     */
    where: ChatWhereUniqueInput
  }

  /**
   * Chat findUniqueOrThrow
   */
  export type ChatFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Chat
     */
    select?: ChatSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Chat
     */
    omit?: ChatOmit<ExtArgs> | null
    /**
     * Filter, which Chat to fetch.
     */
    where: ChatWhereUniqueInput
  }

  /**
   * Chat findFirst
   */
  export type ChatFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Chat
     */
    select?: ChatSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Chat
     */
    omit?: ChatOmit<ExtArgs> | null
    /**
     * Filter, which Chat to fetch.
     */
    where?: ChatWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Chats to fetch.
     */
    orderBy?: ChatOrderByWithRelationInput | ChatOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Chats.
     */
    cursor?: ChatWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Chats from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Chats.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Chats.
     */
    distinct?: ChatScalarFieldEnum | ChatScalarFieldEnum[]
  }

  /**
   * Chat findFirstOrThrow
   */
  export type ChatFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Chat
     */
    select?: ChatSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Chat
     */
    omit?: ChatOmit<ExtArgs> | null
    /**
     * Filter, which Chat to fetch.
     */
    where?: ChatWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Chats to fetch.
     */
    orderBy?: ChatOrderByWithRelationInput | ChatOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Chats.
     */
    cursor?: ChatWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Chats from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Chats.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Chats.
     */
    distinct?: ChatScalarFieldEnum | ChatScalarFieldEnum[]
  }

  /**
   * Chat findMany
   */
  export type ChatFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Chat
     */
    select?: ChatSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Chat
     */
    omit?: ChatOmit<ExtArgs> | null
    /**
     * Filter, which Chats to fetch.
     */
    where?: ChatWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Chats to fetch.
     */
    orderBy?: ChatOrderByWithRelationInput | ChatOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Chats.
     */
    cursor?: ChatWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Chats from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Chats.
     */
    skip?: number
    distinct?: ChatScalarFieldEnum | ChatScalarFieldEnum[]
  }

  /**
   * Chat create
   */
  export type ChatCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Chat
     */
    select?: ChatSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Chat
     */
    omit?: ChatOmit<ExtArgs> | null
    /**
     * The data needed to create a Chat.
     */
    data: XOR<ChatCreateInput, ChatUncheckedCreateInput>
  }

  /**
   * Chat createMany
   */
  export type ChatCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Chats.
     */
    data: ChatCreateManyInput | ChatCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Chat update
   */
  export type ChatUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Chat
     */
    select?: ChatSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Chat
     */
    omit?: ChatOmit<ExtArgs> | null
    /**
     * The data needed to update a Chat.
     */
    data: XOR<ChatUpdateInput, ChatUncheckedUpdateInput>
    /**
     * Choose, which Chat to update.
     */
    where: ChatWhereUniqueInput
  }

  /**
   * Chat updateMany
   */
  export type ChatUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Chats.
     */
    data: XOR<ChatUpdateManyMutationInput, ChatUncheckedUpdateManyInput>
    /**
     * Filter which Chats to update
     */
    where?: ChatWhereInput
    /**
     * Limit how many Chats to update.
     */
    limit?: number
  }

  /**
   * Chat upsert
   */
  export type ChatUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Chat
     */
    select?: ChatSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Chat
     */
    omit?: ChatOmit<ExtArgs> | null
    /**
     * The filter to search for the Chat to update in case it exists.
     */
    where: ChatWhereUniqueInput
    /**
     * In case the Chat found by the `where` argument doesn't exist, create a new Chat with this data.
     */
    create: XOR<ChatCreateInput, ChatUncheckedCreateInput>
    /**
     * In case the Chat was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ChatUpdateInput, ChatUncheckedUpdateInput>
  }

  /**
   * Chat delete
   */
  export type ChatDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Chat
     */
    select?: ChatSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Chat
     */
    omit?: ChatOmit<ExtArgs> | null
    /**
     * Filter which Chat to delete.
     */
    where: ChatWhereUniqueInput
  }

  /**
   * Chat deleteMany
   */
  export type ChatDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Chats to delete
     */
    where?: ChatWhereInput
    /**
     * Limit how many Chats to delete.
     */
    limit?: number
  }

  /**
   * Chat without action
   */
  export type ChatDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Chat
     */
    select?: ChatSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Chat
     */
    omit?: ChatOmit<ExtArgs> | null
  }


  /**
   * Model Contact
   */

  export type AggregateContact = {
    _count: ContactCountAggregateOutputType | null
    _avg: ContactAvgAggregateOutputType | null
    _sum: ContactSumAggregateOutputType | null
    _min: ContactMinAggregateOutputType | null
    _max: ContactMaxAggregateOutputType | null
  }

  export type ContactAvgAggregateOutputType = {
    pkId: number | null
  }

  export type ContactSumAggregateOutputType = {
    pkId: number | null
  }

  export type ContactMinAggregateOutputType = {
    pkId: number | null
    sessionId: string | null
    id: string | null
    name: string | null
    notify: string | null
    verifiedName: string | null
    imgUrl: string | null
    status: string | null
  }

  export type ContactMaxAggregateOutputType = {
    pkId: number | null
    sessionId: string | null
    id: string | null
    name: string | null
    notify: string | null
    verifiedName: string | null
    imgUrl: string | null
    status: string | null
  }

  export type ContactCountAggregateOutputType = {
    pkId: number
    sessionId: number
    id: number
    name: number
    notify: number
    verifiedName: number
    imgUrl: number
    status: number
    _all: number
  }


  export type ContactAvgAggregateInputType = {
    pkId?: true
  }

  export type ContactSumAggregateInputType = {
    pkId?: true
  }

  export type ContactMinAggregateInputType = {
    pkId?: true
    sessionId?: true
    id?: true
    name?: true
    notify?: true
    verifiedName?: true
    imgUrl?: true
    status?: true
  }

  export type ContactMaxAggregateInputType = {
    pkId?: true
    sessionId?: true
    id?: true
    name?: true
    notify?: true
    verifiedName?: true
    imgUrl?: true
    status?: true
  }

  export type ContactCountAggregateInputType = {
    pkId?: true
    sessionId?: true
    id?: true
    name?: true
    notify?: true
    verifiedName?: true
    imgUrl?: true
    status?: true
    _all?: true
  }

  export type ContactAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Contact to aggregate.
     */
    where?: ContactWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Contacts to fetch.
     */
    orderBy?: ContactOrderByWithRelationInput | ContactOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ContactWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Contacts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Contacts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Contacts
    **/
    _count?: true | ContactCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ContactAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ContactSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ContactMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ContactMaxAggregateInputType
  }

  export type GetContactAggregateType<T extends ContactAggregateArgs> = {
        [P in keyof T & keyof AggregateContact]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateContact[P]>
      : GetScalarType<T[P], AggregateContact[P]>
  }




  export type ContactGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ContactWhereInput
    orderBy?: ContactOrderByWithAggregationInput | ContactOrderByWithAggregationInput[]
    by: ContactScalarFieldEnum[] | ContactScalarFieldEnum
    having?: ContactScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ContactCountAggregateInputType | true
    _avg?: ContactAvgAggregateInputType
    _sum?: ContactSumAggregateInputType
    _min?: ContactMinAggregateInputType
    _max?: ContactMaxAggregateInputType
  }

  export type ContactGroupByOutputType = {
    pkId: number
    sessionId: string
    id: string
    name: string | null
    notify: string | null
    verifiedName: string | null
    imgUrl: string | null
    status: string | null
    _count: ContactCountAggregateOutputType | null
    _avg: ContactAvgAggregateOutputType | null
    _sum: ContactSumAggregateOutputType | null
    _min: ContactMinAggregateOutputType | null
    _max: ContactMaxAggregateOutputType | null
  }

  type GetContactGroupByPayload<T extends ContactGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ContactGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ContactGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ContactGroupByOutputType[P]>
            : GetScalarType<T[P], ContactGroupByOutputType[P]>
        }
      >
    >


  export type ContactSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    pkId?: boolean
    sessionId?: boolean
    id?: boolean
    name?: boolean
    notify?: boolean
    verifiedName?: boolean
    imgUrl?: boolean
    status?: boolean
  }, ExtArgs["result"]["contact"]>



  export type ContactSelectScalar = {
    pkId?: boolean
    sessionId?: boolean
    id?: boolean
    name?: boolean
    notify?: boolean
    verifiedName?: boolean
    imgUrl?: boolean
    status?: boolean
  }

  export type ContactOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"pkId" | "sessionId" | "id" | "name" | "notify" | "verifiedName" | "imgUrl" | "status", ExtArgs["result"]["contact"]>

  export type $ContactPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Contact"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      pkId: number
      sessionId: string
      id: string
      name: string | null
      notify: string | null
      verifiedName: string | null
      imgUrl: string | null
      status: string | null
    }, ExtArgs["result"]["contact"]>
    composites: {}
  }

  type ContactGetPayload<S extends boolean | null | undefined | ContactDefaultArgs> = $Result.GetResult<Prisma.$ContactPayload, S>

  type ContactCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ContactFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ContactCountAggregateInputType | true
    }

  export interface ContactDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Contact'], meta: { name: 'Contact' } }
    /**
     * Find zero or one Contact that matches the filter.
     * @param {ContactFindUniqueArgs} args - Arguments to find a Contact
     * @example
     * // Get one Contact
     * const contact = await prisma.contact.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ContactFindUniqueArgs>(args: SelectSubset<T, ContactFindUniqueArgs<ExtArgs>>): Prisma__ContactClient<$Result.GetResult<Prisma.$ContactPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Contact that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ContactFindUniqueOrThrowArgs} args - Arguments to find a Contact
     * @example
     * // Get one Contact
     * const contact = await prisma.contact.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ContactFindUniqueOrThrowArgs>(args: SelectSubset<T, ContactFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ContactClient<$Result.GetResult<Prisma.$ContactPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Contact that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ContactFindFirstArgs} args - Arguments to find a Contact
     * @example
     * // Get one Contact
     * const contact = await prisma.contact.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ContactFindFirstArgs>(args?: SelectSubset<T, ContactFindFirstArgs<ExtArgs>>): Prisma__ContactClient<$Result.GetResult<Prisma.$ContactPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Contact that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ContactFindFirstOrThrowArgs} args - Arguments to find a Contact
     * @example
     * // Get one Contact
     * const contact = await prisma.contact.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ContactFindFirstOrThrowArgs>(args?: SelectSubset<T, ContactFindFirstOrThrowArgs<ExtArgs>>): Prisma__ContactClient<$Result.GetResult<Prisma.$ContactPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Contacts that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ContactFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Contacts
     * const contacts = await prisma.contact.findMany()
     * 
     * // Get first 10 Contacts
     * const contacts = await prisma.contact.findMany({ take: 10 })
     * 
     * // Only select the `pkId`
     * const contactWithPkIdOnly = await prisma.contact.findMany({ select: { pkId: true } })
     * 
     */
    findMany<T extends ContactFindManyArgs>(args?: SelectSubset<T, ContactFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ContactPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Contact.
     * @param {ContactCreateArgs} args - Arguments to create a Contact.
     * @example
     * // Create one Contact
     * const Contact = await prisma.contact.create({
     *   data: {
     *     // ... data to create a Contact
     *   }
     * })
     * 
     */
    create<T extends ContactCreateArgs>(args: SelectSubset<T, ContactCreateArgs<ExtArgs>>): Prisma__ContactClient<$Result.GetResult<Prisma.$ContactPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Contacts.
     * @param {ContactCreateManyArgs} args - Arguments to create many Contacts.
     * @example
     * // Create many Contacts
     * const contact = await prisma.contact.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ContactCreateManyArgs>(args?: SelectSubset<T, ContactCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Contact.
     * @param {ContactDeleteArgs} args - Arguments to delete one Contact.
     * @example
     * // Delete one Contact
     * const Contact = await prisma.contact.delete({
     *   where: {
     *     // ... filter to delete one Contact
     *   }
     * })
     * 
     */
    delete<T extends ContactDeleteArgs>(args: SelectSubset<T, ContactDeleteArgs<ExtArgs>>): Prisma__ContactClient<$Result.GetResult<Prisma.$ContactPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Contact.
     * @param {ContactUpdateArgs} args - Arguments to update one Contact.
     * @example
     * // Update one Contact
     * const contact = await prisma.contact.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ContactUpdateArgs>(args: SelectSubset<T, ContactUpdateArgs<ExtArgs>>): Prisma__ContactClient<$Result.GetResult<Prisma.$ContactPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Contacts.
     * @param {ContactDeleteManyArgs} args - Arguments to filter Contacts to delete.
     * @example
     * // Delete a few Contacts
     * const { count } = await prisma.contact.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ContactDeleteManyArgs>(args?: SelectSubset<T, ContactDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Contacts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ContactUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Contacts
     * const contact = await prisma.contact.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ContactUpdateManyArgs>(args: SelectSubset<T, ContactUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Contact.
     * @param {ContactUpsertArgs} args - Arguments to update or create a Contact.
     * @example
     * // Update or create a Contact
     * const contact = await prisma.contact.upsert({
     *   create: {
     *     // ... data to create a Contact
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Contact we want to update
     *   }
     * })
     */
    upsert<T extends ContactUpsertArgs>(args: SelectSubset<T, ContactUpsertArgs<ExtArgs>>): Prisma__ContactClient<$Result.GetResult<Prisma.$ContactPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Contacts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ContactCountArgs} args - Arguments to filter Contacts to count.
     * @example
     * // Count the number of Contacts
     * const count = await prisma.contact.count({
     *   where: {
     *     // ... the filter for the Contacts we want to count
     *   }
     * })
    **/
    count<T extends ContactCountArgs>(
      args?: Subset<T, ContactCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ContactCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Contact.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ContactAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ContactAggregateArgs>(args: Subset<T, ContactAggregateArgs>): Prisma.PrismaPromise<GetContactAggregateType<T>>

    /**
     * Group by Contact.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ContactGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ContactGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ContactGroupByArgs['orderBy'] }
        : { orderBy?: ContactGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ContactGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetContactGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Contact model
   */
  readonly fields: ContactFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Contact.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ContactClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Contact model
   */
  interface ContactFieldRefs {
    readonly pkId: FieldRef<"Contact", 'Int'>
    readonly sessionId: FieldRef<"Contact", 'String'>
    readonly id: FieldRef<"Contact", 'String'>
    readonly name: FieldRef<"Contact", 'String'>
    readonly notify: FieldRef<"Contact", 'String'>
    readonly verifiedName: FieldRef<"Contact", 'String'>
    readonly imgUrl: FieldRef<"Contact", 'String'>
    readonly status: FieldRef<"Contact", 'String'>
  }
    

  // Custom InputTypes
  /**
   * Contact findUnique
   */
  export type ContactFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Contact
     */
    select?: ContactSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Contact
     */
    omit?: ContactOmit<ExtArgs> | null
    /**
     * Filter, which Contact to fetch.
     */
    where: ContactWhereUniqueInput
  }

  /**
   * Contact findUniqueOrThrow
   */
  export type ContactFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Contact
     */
    select?: ContactSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Contact
     */
    omit?: ContactOmit<ExtArgs> | null
    /**
     * Filter, which Contact to fetch.
     */
    where: ContactWhereUniqueInput
  }

  /**
   * Contact findFirst
   */
  export type ContactFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Contact
     */
    select?: ContactSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Contact
     */
    omit?: ContactOmit<ExtArgs> | null
    /**
     * Filter, which Contact to fetch.
     */
    where?: ContactWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Contacts to fetch.
     */
    orderBy?: ContactOrderByWithRelationInput | ContactOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Contacts.
     */
    cursor?: ContactWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Contacts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Contacts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Contacts.
     */
    distinct?: ContactScalarFieldEnum | ContactScalarFieldEnum[]
  }

  /**
   * Contact findFirstOrThrow
   */
  export type ContactFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Contact
     */
    select?: ContactSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Contact
     */
    omit?: ContactOmit<ExtArgs> | null
    /**
     * Filter, which Contact to fetch.
     */
    where?: ContactWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Contacts to fetch.
     */
    orderBy?: ContactOrderByWithRelationInput | ContactOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Contacts.
     */
    cursor?: ContactWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Contacts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Contacts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Contacts.
     */
    distinct?: ContactScalarFieldEnum | ContactScalarFieldEnum[]
  }

  /**
   * Contact findMany
   */
  export type ContactFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Contact
     */
    select?: ContactSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Contact
     */
    omit?: ContactOmit<ExtArgs> | null
    /**
     * Filter, which Contacts to fetch.
     */
    where?: ContactWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Contacts to fetch.
     */
    orderBy?: ContactOrderByWithRelationInput | ContactOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Contacts.
     */
    cursor?: ContactWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Contacts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Contacts.
     */
    skip?: number
    distinct?: ContactScalarFieldEnum | ContactScalarFieldEnum[]
  }

  /**
   * Contact create
   */
  export type ContactCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Contact
     */
    select?: ContactSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Contact
     */
    omit?: ContactOmit<ExtArgs> | null
    /**
     * The data needed to create a Contact.
     */
    data: XOR<ContactCreateInput, ContactUncheckedCreateInput>
  }

  /**
   * Contact createMany
   */
  export type ContactCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Contacts.
     */
    data: ContactCreateManyInput | ContactCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Contact update
   */
  export type ContactUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Contact
     */
    select?: ContactSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Contact
     */
    omit?: ContactOmit<ExtArgs> | null
    /**
     * The data needed to update a Contact.
     */
    data: XOR<ContactUpdateInput, ContactUncheckedUpdateInput>
    /**
     * Choose, which Contact to update.
     */
    where: ContactWhereUniqueInput
  }

  /**
   * Contact updateMany
   */
  export type ContactUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Contacts.
     */
    data: XOR<ContactUpdateManyMutationInput, ContactUncheckedUpdateManyInput>
    /**
     * Filter which Contacts to update
     */
    where?: ContactWhereInput
    /**
     * Limit how many Contacts to update.
     */
    limit?: number
  }

  /**
   * Contact upsert
   */
  export type ContactUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Contact
     */
    select?: ContactSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Contact
     */
    omit?: ContactOmit<ExtArgs> | null
    /**
     * The filter to search for the Contact to update in case it exists.
     */
    where: ContactWhereUniqueInput
    /**
     * In case the Contact found by the `where` argument doesn't exist, create a new Contact with this data.
     */
    create: XOR<ContactCreateInput, ContactUncheckedCreateInput>
    /**
     * In case the Contact was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ContactUpdateInput, ContactUncheckedUpdateInput>
  }

  /**
   * Contact delete
   */
  export type ContactDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Contact
     */
    select?: ContactSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Contact
     */
    omit?: ContactOmit<ExtArgs> | null
    /**
     * Filter which Contact to delete.
     */
    where: ContactWhereUniqueInput
  }

  /**
   * Contact deleteMany
   */
  export type ContactDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Contacts to delete
     */
    where?: ContactWhereInput
    /**
     * Limit how many Contacts to delete.
     */
    limit?: number
  }

  /**
   * Contact without action
   */
  export type ContactDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Contact
     */
    select?: ContactSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Contact
     */
    omit?: ContactOmit<ExtArgs> | null
  }


  /**
   * Model GroupMetadata
   */

  export type AggregateGroupMetadata = {
    _count: GroupMetadataCountAggregateOutputType | null
    _avg: GroupMetadataAvgAggregateOutputType | null
    _sum: GroupMetadataSumAggregateOutputType | null
    _min: GroupMetadataMinAggregateOutputType | null
    _max: GroupMetadataMaxAggregateOutputType | null
  }

  export type GroupMetadataAvgAggregateOutputType = {
    pkId: number | null
    subjectTime: number | null
    creation: number | null
    size: number | null
    ephemeralDuration: number | null
  }

  export type GroupMetadataSumAggregateOutputType = {
    pkId: number | null
    subjectTime: number | null
    creation: number | null
    size: number | null
    ephemeralDuration: number | null
  }

  export type GroupMetadataMinAggregateOutputType = {
    pkId: number | null
    sessionId: string | null
    id: string | null
    owner: string | null
    subject: string | null
    subjectOwner: string | null
    subjectTime: number | null
    creation: number | null
    desc: string | null
    descOwner: string | null
    descId: string | null
    restrict: boolean | null
    announce: boolean | null
    isCommunity: boolean | null
    isCommunityAnnounce: boolean | null
    joinApprovalMode: boolean | null
    memberAddMode: boolean | null
    author: string | null
    size: number | null
    ephemeralDuration: number | null
    inviteCode: string | null
  }

  export type GroupMetadataMaxAggregateOutputType = {
    pkId: number | null
    sessionId: string | null
    id: string | null
    owner: string | null
    subject: string | null
    subjectOwner: string | null
    subjectTime: number | null
    creation: number | null
    desc: string | null
    descOwner: string | null
    descId: string | null
    restrict: boolean | null
    announce: boolean | null
    isCommunity: boolean | null
    isCommunityAnnounce: boolean | null
    joinApprovalMode: boolean | null
    memberAddMode: boolean | null
    author: string | null
    size: number | null
    ephemeralDuration: number | null
    inviteCode: string | null
  }

  export type GroupMetadataCountAggregateOutputType = {
    pkId: number
    sessionId: number
    id: number
    owner: number
    subject: number
    subjectOwner: number
    subjectTime: number
    creation: number
    desc: number
    descOwner: number
    descId: number
    restrict: number
    announce: number
    isCommunity: number
    isCommunityAnnounce: number
    joinApprovalMode: number
    memberAddMode: number
    author: number
    size: number
    participants: number
    ephemeralDuration: number
    inviteCode: number
    _all: number
  }


  export type GroupMetadataAvgAggregateInputType = {
    pkId?: true
    subjectTime?: true
    creation?: true
    size?: true
    ephemeralDuration?: true
  }

  export type GroupMetadataSumAggregateInputType = {
    pkId?: true
    subjectTime?: true
    creation?: true
    size?: true
    ephemeralDuration?: true
  }

  export type GroupMetadataMinAggregateInputType = {
    pkId?: true
    sessionId?: true
    id?: true
    owner?: true
    subject?: true
    subjectOwner?: true
    subjectTime?: true
    creation?: true
    desc?: true
    descOwner?: true
    descId?: true
    restrict?: true
    announce?: true
    isCommunity?: true
    isCommunityAnnounce?: true
    joinApprovalMode?: true
    memberAddMode?: true
    author?: true
    size?: true
    ephemeralDuration?: true
    inviteCode?: true
  }

  export type GroupMetadataMaxAggregateInputType = {
    pkId?: true
    sessionId?: true
    id?: true
    owner?: true
    subject?: true
    subjectOwner?: true
    subjectTime?: true
    creation?: true
    desc?: true
    descOwner?: true
    descId?: true
    restrict?: true
    announce?: true
    isCommunity?: true
    isCommunityAnnounce?: true
    joinApprovalMode?: true
    memberAddMode?: true
    author?: true
    size?: true
    ephemeralDuration?: true
    inviteCode?: true
  }

  export type GroupMetadataCountAggregateInputType = {
    pkId?: true
    sessionId?: true
    id?: true
    owner?: true
    subject?: true
    subjectOwner?: true
    subjectTime?: true
    creation?: true
    desc?: true
    descOwner?: true
    descId?: true
    restrict?: true
    announce?: true
    isCommunity?: true
    isCommunityAnnounce?: true
    joinApprovalMode?: true
    memberAddMode?: true
    author?: true
    size?: true
    participants?: true
    ephemeralDuration?: true
    inviteCode?: true
    _all?: true
  }

  export type GroupMetadataAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which GroupMetadata to aggregate.
     */
    where?: GroupMetadataWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of GroupMetadata to fetch.
     */
    orderBy?: GroupMetadataOrderByWithRelationInput | GroupMetadataOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: GroupMetadataWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` GroupMetadata from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` GroupMetadata.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned GroupMetadata
    **/
    _count?: true | GroupMetadataCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: GroupMetadataAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: GroupMetadataSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: GroupMetadataMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: GroupMetadataMaxAggregateInputType
  }

  export type GetGroupMetadataAggregateType<T extends GroupMetadataAggregateArgs> = {
        [P in keyof T & keyof AggregateGroupMetadata]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateGroupMetadata[P]>
      : GetScalarType<T[P], AggregateGroupMetadata[P]>
  }




  export type GroupMetadataGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: GroupMetadataWhereInput
    orderBy?: GroupMetadataOrderByWithAggregationInput | GroupMetadataOrderByWithAggregationInput[]
    by: GroupMetadataScalarFieldEnum[] | GroupMetadataScalarFieldEnum
    having?: GroupMetadataScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: GroupMetadataCountAggregateInputType | true
    _avg?: GroupMetadataAvgAggregateInputType
    _sum?: GroupMetadataSumAggregateInputType
    _min?: GroupMetadataMinAggregateInputType
    _max?: GroupMetadataMaxAggregateInputType
  }

  export type GroupMetadataGroupByOutputType = {
    pkId: number
    sessionId: string
    id: string
    owner: string | null
    subject: string
    subjectOwner: string | null
    subjectTime: number | null
    creation: number | null
    desc: string | null
    descOwner: string | null
    descId: string | null
    restrict: boolean | null
    announce: boolean | null
    isCommunity: boolean | null
    isCommunityAnnounce: boolean | null
    joinApprovalMode: boolean | null
    memberAddMode: boolean | null
    author: string | null
    size: number | null
    participants: JsonValue
    ephemeralDuration: number | null
    inviteCode: string | null
    _count: GroupMetadataCountAggregateOutputType | null
    _avg: GroupMetadataAvgAggregateOutputType | null
    _sum: GroupMetadataSumAggregateOutputType | null
    _min: GroupMetadataMinAggregateOutputType | null
    _max: GroupMetadataMaxAggregateOutputType | null
  }

  type GetGroupMetadataGroupByPayload<T extends GroupMetadataGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<GroupMetadataGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof GroupMetadataGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], GroupMetadataGroupByOutputType[P]>
            : GetScalarType<T[P], GroupMetadataGroupByOutputType[P]>
        }
      >
    >


  export type GroupMetadataSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    pkId?: boolean
    sessionId?: boolean
    id?: boolean
    owner?: boolean
    subject?: boolean
    subjectOwner?: boolean
    subjectTime?: boolean
    creation?: boolean
    desc?: boolean
    descOwner?: boolean
    descId?: boolean
    restrict?: boolean
    announce?: boolean
    isCommunity?: boolean
    isCommunityAnnounce?: boolean
    joinApprovalMode?: boolean
    memberAddMode?: boolean
    author?: boolean
    size?: boolean
    participants?: boolean
    ephemeralDuration?: boolean
    inviteCode?: boolean
  }, ExtArgs["result"]["groupMetadata"]>



  export type GroupMetadataSelectScalar = {
    pkId?: boolean
    sessionId?: boolean
    id?: boolean
    owner?: boolean
    subject?: boolean
    subjectOwner?: boolean
    subjectTime?: boolean
    creation?: boolean
    desc?: boolean
    descOwner?: boolean
    descId?: boolean
    restrict?: boolean
    announce?: boolean
    isCommunity?: boolean
    isCommunityAnnounce?: boolean
    joinApprovalMode?: boolean
    memberAddMode?: boolean
    author?: boolean
    size?: boolean
    participants?: boolean
    ephemeralDuration?: boolean
    inviteCode?: boolean
  }

  export type GroupMetadataOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"pkId" | "sessionId" | "id" | "owner" | "subject" | "subjectOwner" | "subjectTime" | "creation" | "desc" | "descOwner" | "descId" | "restrict" | "announce" | "isCommunity" | "isCommunityAnnounce" | "joinApprovalMode" | "memberAddMode" | "author" | "size" | "participants" | "ephemeralDuration" | "inviteCode", ExtArgs["result"]["groupMetadata"]>

  export type $GroupMetadataPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "GroupMetadata"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      pkId: number
      sessionId: string
      id: string
      owner: string | null
      subject: string
      subjectOwner: string | null
      subjectTime: number | null
      creation: number | null
      desc: string | null
      descOwner: string | null
      descId: string | null
      restrict: boolean | null
      announce: boolean | null
      isCommunity: boolean | null
      isCommunityAnnounce: boolean | null
      joinApprovalMode: boolean | null
      memberAddMode: boolean | null
      author: string | null
      size: number | null
      participants: Prisma.JsonValue
      ephemeralDuration: number | null
      inviteCode: string | null
    }, ExtArgs["result"]["groupMetadata"]>
    composites: {}
  }

  type GroupMetadataGetPayload<S extends boolean | null | undefined | GroupMetadataDefaultArgs> = $Result.GetResult<Prisma.$GroupMetadataPayload, S>

  type GroupMetadataCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<GroupMetadataFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: GroupMetadataCountAggregateInputType | true
    }

  export interface GroupMetadataDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['GroupMetadata'], meta: { name: 'GroupMetadata' } }
    /**
     * Find zero or one GroupMetadata that matches the filter.
     * @param {GroupMetadataFindUniqueArgs} args - Arguments to find a GroupMetadata
     * @example
     * // Get one GroupMetadata
     * const groupMetadata = await prisma.groupMetadata.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends GroupMetadataFindUniqueArgs>(args: SelectSubset<T, GroupMetadataFindUniqueArgs<ExtArgs>>): Prisma__GroupMetadataClient<$Result.GetResult<Prisma.$GroupMetadataPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one GroupMetadata that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {GroupMetadataFindUniqueOrThrowArgs} args - Arguments to find a GroupMetadata
     * @example
     * // Get one GroupMetadata
     * const groupMetadata = await prisma.groupMetadata.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends GroupMetadataFindUniqueOrThrowArgs>(args: SelectSubset<T, GroupMetadataFindUniqueOrThrowArgs<ExtArgs>>): Prisma__GroupMetadataClient<$Result.GetResult<Prisma.$GroupMetadataPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first GroupMetadata that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GroupMetadataFindFirstArgs} args - Arguments to find a GroupMetadata
     * @example
     * // Get one GroupMetadata
     * const groupMetadata = await prisma.groupMetadata.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends GroupMetadataFindFirstArgs>(args?: SelectSubset<T, GroupMetadataFindFirstArgs<ExtArgs>>): Prisma__GroupMetadataClient<$Result.GetResult<Prisma.$GroupMetadataPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first GroupMetadata that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GroupMetadataFindFirstOrThrowArgs} args - Arguments to find a GroupMetadata
     * @example
     * // Get one GroupMetadata
     * const groupMetadata = await prisma.groupMetadata.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends GroupMetadataFindFirstOrThrowArgs>(args?: SelectSubset<T, GroupMetadataFindFirstOrThrowArgs<ExtArgs>>): Prisma__GroupMetadataClient<$Result.GetResult<Prisma.$GroupMetadataPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more GroupMetadata that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GroupMetadataFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all GroupMetadata
     * const groupMetadata = await prisma.groupMetadata.findMany()
     * 
     * // Get first 10 GroupMetadata
     * const groupMetadata = await prisma.groupMetadata.findMany({ take: 10 })
     * 
     * // Only select the `pkId`
     * const groupMetadataWithPkIdOnly = await prisma.groupMetadata.findMany({ select: { pkId: true } })
     * 
     */
    findMany<T extends GroupMetadataFindManyArgs>(args?: SelectSubset<T, GroupMetadataFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$GroupMetadataPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a GroupMetadata.
     * @param {GroupMetadataCreateArgs} args - Arguments to create a GroupMetadata.
     * @example
     * // Create one GroupMetadata
     * const GroupMetadata = await prisma.groupMetadata.create({
     *   data: {
     *     // ... data to create a GroupMetadata
     *   }
     * })
     * 
     */
    create<T extends GroupMetadataCreateArgs>(args: SelectSubset<T, GroupMetadataCreateArgs<ExtArgs>>): Prisma__GroupMetadataClient<$Result.GetResult<Prisma.$GroupMetadataPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many GroupMetadata.
     * @param {GroupMetadataCreateManyArgs} args - Arguments to create many GroupMetadata.
     * @example
     * // Create many GroupMetadata
     * const groupMetadata = await prisma.groupMetadata.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends GroupMetadataCreateManyArgs>(args?: SelectSubset<T, GroupMetadataCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a GroupMetadata.
     * @param {GroupMetadataDeleteArgs} args - Arguments to delete one GroupMetadata.
     * @example
     * // Delete one GroupMetadata
     * const GroupMetadata = await prisma.groupMetadata.delete({
     *   where: {
     *     // ... filter to delete one GroupMetadata
     *   }
     * })
     * 
     */
    delete<T extends GroupMetadataDeleteArgs>(args: SelectSubset<T, GroupMetadataDeleteArgs<ExtArgs>>): Prisma__GroupMetadataClient<$Result.GetResult<Prisma.$GroupMetadataPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one GroupMetadata.
     * @param {GroupMetadataUpdateArgs} args - Arguments to update one GroupMetadata.
     * @example
     * // Update one GroupMetadata
     * const groupMetadata = await prisma.groupMetadata.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends GroupMetadataUpdateArgs>(args: SelectSubset<T, GroupMetadataUpdateArgs<ExtArgs>>): Prisma__GroupMetadataClient<$Result.GetResult<Prisma.$GroupMetadataPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more GroupMetadata.
     * @param {GroupMetadataDeleteManyArgs} args - Arguments to filter GroupMetadata to delete.
     * @example
     * // Delete a few GroupMetadata
     * const { count } = await prisma.groupMetadata.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends GroupMetadataDeleteManyArgs>(args?: SelectSubset<T, GroupMetadataDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more GroupMetadata.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GroupMetadataUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many GroupMetadata
     * const groupMetadata = await prisma.groupMetadata.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends GroupMetadataUpdateManyArgs>(args: SelectSubset<T, GroupMetadataUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one GroupMetadata.
     * @param {GroupMetadataUpsertArgs} args - Arguments to update or create a GroupMetadata.
     * @example
     * // Update or create a GroupMetadata
     * const groupMetadata = await prisma.groupMetadata.upsert({
     *   create: {
     *     // ... data to create a GroupMetadata
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the GroupMetadata we want to update
     *   }
     * })
     */
    upsert<T extends GroupMetadataUpsertArgs>(args: SelectSubset<T, GroupMetadataUpsertArgs<ExtArgs>>): Prisma__GroupMetadataClient<$Result.GetResult<Prisma.$GroupMetadataPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of GroupMetadata.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GroupMetadataCountArgs} args - Arguments to filter GroupMetadata to count.
     * @example
     * // Count the number of GroupMetadata
     * const count = await prisma.groupMetadata.count({
     *   where: {
     *     // ... the filter for the GroupMetadata we want to count
     *   }
     * })
    **/
    count<T extends GroupMetadataCountArgs>(
      args?: Subset<T, GroupMetadataCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], GroupMetadataCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a GroupMetadata.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GroupMetadataAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends GroupMetadataAggregateArgs>(args: Subset<T, GroupMetadataAggregateArgs>): Prisma.PrismaPromise<GetGroupMetadataAggregateType<T>>

    /**
     * Group by GroupMetadata.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GroupMetadataGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends GroupMetadataGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: GroupMetadataGroupByArgs['orderBy'] }
        : { orderBy?: GroupMetadataGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, GroupMetadataGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetGroupMetadataGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the GroupMetadata model
   */
  readonly fields: GroupMetadataFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for GroupMetadata.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__GroupMetadataClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the GroupMetadata model
   */
  interface GroupMetadataFieldRefs {
    readonly pkId: FieldRef<"GroupMetadata", 'Int'>
    readonly sessionId: FieldRef<"GroupMetadata", 'String'>
    readonly id: FieldRef<"GroupMetadata", 'String'>
    readonly owner: FieldRef<"GroupMetadata", 'String'>
    readonly subject: FieldRef<"GroupMetadata", 'String'>
    readonly subjectOwner: FieldRef<"GroupMetadata", 'String'>
    readonly subjectTime: FieldRef<"GroupMetadata", 'Int'>
    readonly creation: FieldRef<"GroupMetadata", 'Int'>
    readonly desc: FieldRef<"GroupMetadata", 'String'>
    readonly descOwner: FieldRef<"GroupMetadata", 'String'>
    readonly descId: FieldRef<"GroupMetadata", 'String'>
    readonly restrict: FieldRef<"GroupMetadata", 'Boolean'>
    readonly announce: FieldRef<"GroupMetadata", 'Boolean'>
    readonly isCommunity: FieldRef<"GroupMetadata", 'Boolean'>
    readonly isCommunityAnnounce: FieldRef<"GroupMetadata", 'Boolean'>
    readonly joinApprovalMode: FieldRef<"GroupMetadata", 'Boolean'>
    readonly memberAddMode: FieldRef<"GroupMetadata", 'Boolean'>
    readonly author: FieldRef<"GroupMetadata", 'String'>
    readonly size: FieldRef<"GroupMetadata", 'Int'>
    readonly participants: FieldRef<"GroupMetadata", 'Json'>
    readonly ephemeralDuration: FieldRef<"GroupMetadata", 'Int'>
    readonly inviteCode: FieldRef<"GroupMetadata", 'String'>
  }
    

  // Custom InputTypes
  /**
   * GroupMetadata findUnique
   */
  export type GroupMetadataFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GroupMetadata
     */
    select?: GroupMetadataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GroupMetadata
     */
    omit?: GroupMetadataOmit<ExtArgs> | null
    /**
     * Filter, which GroupMetadata to fetch.
     */
    where: GroupMetadataWhereUniqueInput
  }

  /**
   * GroupMetadata findUniqueOrThrow
   */
  export type GroupMetadataFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GroupMetadata
     */
    select?: GroupMetadataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GroupMetadata
     */
    omit?: GroupMetadataOmit<ExtArgs> | null
    /**
     * Filter, which GroupMetadata to fetch.
     */
    where: GroupMetadataWhereUniqueInput
  }

  /**
   * GroupMetadata findFirst
   */
  export type GroupMetadataFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GroupMetadata
     */
    select?: GroupMetadataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GroupMetadata
     */
    omit?: GroupMetadataOmit<ExtArgs> | null
    /**
     * Filter, which GroupMetadata to fetch.
     */
    where?: GroupMetadataWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of GroupMetadata to fetch.
     */
    orderBy?: GroupMetadataOrderByWithRelationInput | GroupMetadataOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for GroupMetadata.
     */
    cursor?: GroupMetadataWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` GroupMetadata from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` GroupMetadata.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of GroupMetadata.
     */
    distinct?: GroupMetadataScalarFieldEnum | GroupMetadataScalarFieldEnum[]
  }

  /**
   * GroupMetadata findFirstOrThrow
   */
  export type GroupMetadataFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GroupMetadata
     */
    select?: GroupMetadataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GroupMetadata
     */
    omit?: GroupMetadataOmit<ExtArgs> | null
    /**
     * Filter, which GroupMetadata to fetch.
     */
    where?: GroupMetadataWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of GroupMetadata to fetch.
     */
    orderBy?: GroupMetadataOrderByWithRelationInput | GroupMetadataOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for GroupMetadata.
     */
    cursor?: GroupMetadataWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` GroupMetadata from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` GroupMetadata.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of GroupMetadata.
     */
    distinct?: GroupMetadataScalarFieldEnum | GroupMetadataScalarFieldEnum[]
  }

  /**
   * GroupMetadata findMany
   */
  export type GroupMetadataFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GroupMetadata
     */
    select?: GroupMetadataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GroupMetadata
     */
    omit?: GroupMetadataOmit<ExtArgs> | null
    /**
     * Filter, which GroupMetadata to fetch.
     */
    where?: GroupMetadataWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of GroupMetadata to fetch.
     */
    orderBy?: GroupMetadataOrderByWithRelationInput | GroupMetadataOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing GroupMetadata.
     */
    cursor?: GroupMetadataWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` GroupMetadata from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` GroupMetadata.
     */
    skip?: number
    distinct?: GroupMetadataScalarFieldEnum | GroupMetadataScalarFieldEnum[]
  }

  /**
   * GroupMetadata create
   */
  export type GroupMetadataCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GroupMetadata
     */
    select?: GroupMetadataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GroupMetadata
     */
    omit?: GroupMetadataOmit<ExtArgs> | null
    /**
     * The data needed to create a GroupMetadata.
     */
    data: XOR<GroupMetadataCreateInput, GroupMetadataUncheckedCreateInput>
  }

  /**
   * GroupMetadata createMany
   */
  export type GroupMetadataCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many GroupMetadata.
     */
    data: GroupMetadataCreateManyInput | GroupMetadataCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * GroupMetadata update
   */
  export type GroupMetadataUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GroupMetadata
     */
    select?: GroupMetadataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GroupMetadata
     */
    omit?: GroupMetadataOmit<ExtArgs> | null
    /**
     * The data needed to update a GroupMetadata.
     */
    data: XOR<GroupMetadataUpdateInput, GroupMetadataUncheckedUpdateInput>
    /**
     * Choose, which GroupMetadata to update.
     */
    where: GroupMetadataWhereUniqueInput
  }

  /**
   * GroupMetadata updateMany
   */
  export type GroupMetadataUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update GroupMetadata.
     */
    data: XOR<GroupMetadataUpdateManyMutationInput, GroupMetadataUncheckedUpdateManyInput>
    /**
     * Filter which GroupMetadata to update
     */
    where?: GroupMetadataWhereInput
    /**
     * Limit how many GroupMetadata to update.
     */
    limit?: number
  }

  /**
   * GroupMetadata upsert
   */
  export type GroupMetadataUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GroupMetadata
     */
    select?: GroupMetadataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GroupMetadata
     */
    omit?: GroupMetadataOmit<ExtArgs> | null
    /**
     * The filter to search for the GroupMetadata to update in case it exists.
     */
    where: GroupMetadataWhereUniqueInput
    /**
     * In case the GroupMetadata found by the `where` argument doesn't exist, create a new GroupMetadata with this data.
     */
    create: XOR<GroupMetadataCreateInput, GroupMetadataUncheckedCreateInput>
    /**
     * In case the GroupMetadata was found with the provided `where` argument, update it with this data.
     */
    update: XOR<GroupMetadataUpdateInput, GroupMetadataUncheckedUpdateInput>
  }

  /**
   * GroupMetadata delete
   */
  export type GroupMetadataDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GroupMetadata
     */
    select?: GroupMetadataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GroupMetadata
     */
    omit?: GroupMetadataOmit<ExtArgs> | null
    /**
     * Filter which GroupMetadata to delete.
     */
    where: GroupMetadataWhereUniqueInput
  }

  /**
   * GroupMetadata deleteMany
   */
  export type GroupMetadataDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which GroupMetadata to delete
     */
    where?: GroupMetadataWhereInput
    /**
     * Limit how many GroupMetadata to delete.
     */
    limit?: number
  }

  /**
   * GroupMetadata without action
   */
  export type GroupMetadataDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GroupMetadata
     */
    select?: GroupMetadataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GroupMetadata
     */
    omit?: GroupMetadataOmit<ExtArgs> | null
  }


  /**
   * Model Message
   */

  export type AggregateMessage = {
    _count: MessageCountAggregateOutputType | null
    _avg: MessageAvgAggregateOutputType | null
    _sum: MessageSumAggregateOutputType | null
    _min: MessageMinAggregateOutputType | null
    _max: MessageMaxAggregateOutputType | null
  }

  export type MessageAvgAggregateOutputType = {
    pkId: number | null
    bizPrivacyStatus: number | null
    duration: number | null
    ephemeralDuration: number | null
    ephemeralStartTimestamp: number | null
    messageC2STimestamp: number | null
    messageStubType: number | null
    messageTimestamp: number | null
    revokeMessageTimestamp: number | null
    status: number | null
  }

  export type MessageSumAggregateOutputType = {
    pkId: number | null
    bizPrivacyStatus: number | null
    duration: number | null
    ephemeralDuration: number | null
    ephemeralStartTimestamp: bigint | null
    messageC2STimestamp: bigint | null
    messageStubType: number | null
    messageTimestamp: bigint | null
    revokeMessageTimestamp: bigint | null
    status: number | null
  }

  export type MessageMinAggregateOutputType = {
    pkId: number | null
    sessionId: string | null
    remoteJid: string | null
    id: string | null
    agentId: string | null
    bizPrivacyStatus: number | null
    broadcast: boolean | null
    clearMedia: boolean | null
    duration: number | null
    ephemeralDuration: number | null
    ephemeralOffToOn: boolean | null
    ephemeralOutOfSync: boolean | null
    ephemeralStartTimestamp: bigint | null
    futureproofData: Uint8Array | null
    ignore: boolean | null
    mediaCiphertextSha256: Uint8Array | null
    messageC2STimestamp: bigint | null
    messageSecret: Uint8Array | null
    messageStubType: number | null
    messageTimestamp: bigint | null
    multicast: boolean | null
    originalSelfAuthorUserJidString: string | null
    participant: string | null
    pushName: string | null
    revokeMessageTimestamp: bigint | null
    starred: boolean | null
    status: number | null
    statusAlreadyViewed: boolean | null
    urlNumber: boolean | null
    urlText: boolean | null
    verifiedBizName: string | null
  }

  export type MessageMaxAggregateOutputType = {
    pkId: number | null
    sessionId: string | null
    remoteJid: string | null
    id: string | null
    agentId: string | null
    bizPrivacyStatus: number | null
    broadcast: boolean | null
    clearMedia: boolean | null
    duration: number | null
    ephemeralDuration: number | null
    ephemeralOffToOn: boolean | null
    ephemeralOutOfSync: boolean | null
    ephemeralStartTimestamp: bigint | null
    futureproofData: Uint8Array | null
    ignore: boolean | null
    mediaCiphertextSha256: Uint8Array | null
    messageC2STimestamp: bigint | null
    messageSecret: Uint8Array | null
    messageStubType: number | null
    messageTimestamp: bigint | null
    multicast: boolean | null
    originalSelfAuthorUserJidString: string | null
    participant: string | null
    pushName: string | null
    revokeMessageTimestamp: bigint | null
    starred: boolean | null
    status: number | null
    statusAlreadyViewed: boolean | null
    urlNumber: boolean | null
    urlText: boolean | null
    verifiedBizName: string | null
  }

  export type MessageCountAggregateOutputType = {
    pkId: number
    sessionId: number
    remoteJid: number
    id: number
    agentId: number
    bizPrivacyStatus: number
    broadcast: number
    clearMedia: number
    duration: number
    ephemeralDuration: number
    ephemeralOffToOn: number
    ephemeralOutOfSync: number
    ephemeralStartTimestamp: number
    finalLiveLocation: number
    futureproofData: number
    ignore: number
    keepInChat: number
    key: number
    labels: number
    mediaCiphertextSha256: number
    mediaData: number
    message: number
    messageC2STimestamp: number
    messageSecret: number
    messageStubParameters: number
    messageStubType: number
    messageTimestamp: number
    multicast: number
    originalSelfAuthorUserJidString: number
    participant: number
    paymentInfo: number
    photoChange: number
    pollAdditionalMetadata: number
    pollUpdates: number
    pushName: number
    quotedPaymentInfo: number
    quotedStickerData: number
    reactions: number
    revokeMessageTimestamp: number
    starred: number
    status: number
    statusAlreadyViewed: number
    statusPsa: number
    urlNumber: number
    urlText: number
    userReceipt: number
    verifiedBizName: number
    eventResponses: number
    pinInChat: number
    reportingTokenInfo: number
    _all: number
  }


  export type MessageAvgAggregateInputType = {
    pkId?: true
    bizPrivacyStatus?: true
    duration?: true
    ephemeralDuration?: true
    ephemeralStartTimestamp?: true
    messageC2STimestamp?: true
    messageStubType?: true
    messageTimestamp?: true
    revokeMessageTimestamp?: true
    status?: true
  }

  export type MessageSumAggregateInputType = {
    pkId?: true
    bizPrivacyStatus?: true
    duration?: true
    ephemeralDuration?: true
    ephemeralStartTimestamp?: true
    messageC2STimestamp?: true
    messageStubType?: true
    messageTimestamp?: true
    revokeMessageTimestamp?: true
    status?: true
  }

  export type MessageMinAggregateInputType = {
    pkId?: true
    sessionId?: true
    remoteJid?: true
    id?: true
    agentId?: true
    bizPrivacyStatus?: true
    broadcast?: true
    clearMedia?: true
    duration?: true
    ephemeralDuration?: true
    ephemeralOffToOn?: true
    ephemeralOutOfSync?: true
    ephemeralStartTimestamp?: true
    futureproofData?: true
    ignore?: true
    mediaCiphertextSha256?: true
    messageC2STimestamp?: true
    messageSecret?: true
    messageStubType?: true
    messageTimestamp?: true
    multicast?: true
    originalSelfAuthorUserJidString?: true
    participant?: true
    pushName?: true
    revokeMessageTimestamp?: true
    starred?: true
    status?: true
    statusAlreadyViewed?: true
    urlNumber?: true
    urlText?: true
    verifiedBizName?: true
  }

  export type MessageMaxAggregateInputType = {
    pkId?: true
    sessionId?: true
    remoteJid?: true
    id?: true
    agentId?: true
    bizPrivacyStatus?: true
    broadcast?: true
    clearMedia?: true
    duration?: true
    ephemeralDuration?: true
    ephemeralOffToOn?: true
    ephemeralOutOfSync?: true
    ephemeralStartTimestamp?: true
    futureproofData?: true
    ignore?: true
    mediaCiphertextSha256?: true
    messageC2STimestamp?: true
    messageSecret?: true
    messageStubType?: true
    messageTimestamp?: true
    multicast?: true
    originalSelfAuthorUserJidString?: true
    participant?: true
    pushName?: true
    revokeMessageTimestamp?: true
    starred?: true
    status?: true
    statusAlreadyViewed?: true
    urlNumber?: true
    urlText?: true
    verifiedBizName?: true
  }

  export type MessageCountAggregateInputType = {
    pkId?: true
    sessionId?: true
    remoteJid?: true
    id?: true
    agentId?: true
    bizPrivacyStatus?: true
    broadcast?: true
    clearMedia?: true
    duration?: true
    ephemeralDuration?: true
    ephemeralOffToOn?: true
    ephemeralOutOfSync?: true
    ephemeralStartTimestamp?: true
    finalLiveLocation?: true
    futureproofData?: true
    ignore?: true
    keepInChat?: true
    key?: true
    labels?: true
    mediaCiphertextSha256?: true
    mediaData?: true
    message?: true
    messageC2STimestamp?: true
    messageSecret?: true
    messageStubParameters?: true
    messageStubType?: true
    messageTimestamp?: true
    multicast?: true
    originalSelfAuthorUserJidString?: true
    participant?: true
    paymentInfo?: true
    photoChange?: true
    pollAdditionalMetadata?: true
    pollUpdates?: true
    pushName?: true
    quotedPaymentInfo?: true
    quotedStickerData?: true
    reactions?: true
    revokeMessageTimestamp?: true
    starred?: true
    status?: true
    statusAlreadyViewed?: true
    statusPsa?: true
    urlNumber?: true
    urlText?: true
    userReceipt?: true
    verifiedBizName?: true
    eventResponses?: true
    pinInChat?: true
    reportingTokenInfo?: true
    _all?: true
  }

  export type MessageAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Message to aggregate.
     */
    where?: MessageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Messages to fetch.
     */
    orderBy?: MessageOrderByWithRelationInput | MessageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: MessageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Messages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Messages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Messages
    **/
    _count?: true | MessageCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: MessageAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: MessageSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: MessageMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: MessageMaxAggregateInputType
  }

  export type GetMessageAggregateType<T extends MessageAggregateArgs> = {
        [P in keyof T & keyof AggregateMessage]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateMessage[P]>
      : GetScalarType<T[P], AggregateMessage[P]>
  }




  export type MessageGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MessageWhereInput
    orderBy?: MessageOrderByWithAggregationInput | MessageOrderByWithAggregationInput[]
    by: MessageScalarFieldEnum[] | MessageScalarFieldEnum
    having?: MessageScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: MessageCountAggregateInputType | true
    _avg?: MessageAvgAggregateInputType
    _sum?: MessageSumAggregateInputType
    _min?: MessageMinAggregateInputType
    _max?: MessageMaxAggregateInputType
  }

  export type MessageGroupByOutputType = {
    pkId: number
    sessionId: string
    remoteJid: string
    id: string
    agentId: string | null
    bizPrivacyStatus: number | null
    broadcast: boolean | null
    clearMedia: boolean | null
    duration: number | null
    ephemeralDuration: number | null
    ephemeralOffToOn: boolean | null
    ephemeralOutOfSync: boolean | null
    ephemeralStartTimestamp: bigint | null
    finalLiveLocation: JsonValue | null
    futureproofData: Uint8Array | null
    ignore: boolean | null
    keepInChat: JsonValue | null
    key: JsonValue
    labels: JsonValue | null
    mediaCiphertextSha256: Uint8Array | null
    mediaData: JsonValue | null
    message: JsonValue | null
    messageC2STimestamp: bigint | null
    messageSecret: Uint8Array | null
    messageStubParameters: JsonValue | null
    messageStubType: number | null
    messageTimestamp: bigint | null
    multicast: boolean | null
    originalSelfAuthorUserJidString: string | null
    participant: string | null
    paymentInfo: JsonValue | null
    photoChange: JsonValue | null
    pollAdditionalMetadata: JsonValue | null
    pollUpdates: JsonValue | null
    pushName: string | null
    quotedPaymentInfo: JsonValue | null
    quotedStickerData: JsonValue | null
    reactions: JsonValue | null
    revokeMessageTimestamp: bigint | null
    starred: boolean | null
    status: number | null
    statusAlreadyViewed: boolean | null
    statusPsa: JsonValue | null
    urlNumber: boolean | null
    urlText: boolean | null
    userReceipt: JsonValue | null
    verifiedBizName: string | null
    eventResponses: JsonValue | null
    pinInChat: JsonValue | null
    reportingTokenInfo: JsonValue | null
    _count: MessageCountAggregateOutputType | null
    _avg: MessageAvgAggregateOutputType | null
    _sum: MessageSumAggregateOutputType | null
    _min: MessageMinAggregateOutputType | null
    _max: MessageMaxAggregateOutputType | null
  }

  type GetMessageGroupByPayload<T extends MessageGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<MessageGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof MessageGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], MessageGroupByOutputType[P]>
            : GetScalarType<T[P], MessageGroupByOutputType[P]>
        }
      >
    >


  export type MessageSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    pkId?: boolean
    sessionId?: boolean
    remoteJid?: boolean
    id?: boolean
    agentId?: boolean
    bizPrivacyStatus?: boolean
    broadcast?: boolean
    clearMedia?: boolean
    duration?: boolean
    ephemeralDuration?: boolean
    ephemeralOffToOn?: boolean
    ephemeralOutOfSync?: boolean
    ephemeralStartTimestamp?: boolean
    finalLiveLocation?: boolean
    futureproofData?: boolean
    ignore?: boolean
    keepInChat?: boolean
    key?: boolean
    labels?: boolean
    mediaCiphertextSha256?: boolean
    mediaData?: boolean
    message?: boolean
    messageC2STimestamp?: boolean
    messageSecret?: boolean
    messageStubParameters?: boolean
    messageStubType?: boolean
    messageTimestamp?: boolean
    multicast?: boolean
    originalSelfAuthorUserJidString?: boolean
    participant?: boolean
    paymentInfo?: boolean
    photoChange?: boolean
    pollAdditionalMetadata?: boolean
    pollUpdates?: boolean
    pushName?: boolean
    quotedPaymentInfo?: boolean
    quotedStickerData?: boolean
    reactions?: boolean
    revokeMessageTimestamp?: boolean
    starred?: boolean
    status?: boolean
    statusAlreadyViewed?: boolean
    statusPsa?: boolean
    urlNumber?: boolean
    urlText?: boolean
    userReceipt?: boolean
    verifiedBizName?: boolean
    eventResponses?: boolean
    pinInChat?: boolean
    reportingTokenInfo?: boolean
  }, ExtArgs["result"]["message"]>



  export type MessageSelectScalar = {
    pkId?: boolean
    sessionId?: boolean
    remoteJid?: boolean
    id?: boolean
    agentId?: boolean
    bizPrivacyStatus?: boolean
    broadcast?: boolean
    clearMedia?: boolean
    duration?: boolean
    ephemeralDuration?: boolean
    ephemeralOffToOn?: boolean
    ephemeralOutOfSync?: boolean
    ephemeralStartTimestamp?: boolean
    finalLiveLocation?: boolean
    futureproofData?: boolean
    ignore?: boolean
    keepInChat?: boolean
    key?: boolean
    labels?: boolean
    mediaCiphertextSha256?: boolean
    mediaData?: boolean
    message?: boolean
    messageC2STimestamp?: boolean
    messageSecret?: boolean
    messageStubParameters?: boolean
    messageStubType?: boolean
    messageTimestamp?: boolean
    multicast?: boolean
    originalSelfAuthorUserJidString?: boolean
    participant?: boolean
    paymentInfo?: boolean
    photoChange?: boolean
    pollAdditionalMetadata?: boolean
    pollUpdates?: boolean
    pushName?: boolean
    quotedPaymentInfo?: boolean
    quotedStickerData?: boolean
    reactions?: boolean
    revokeMessageTimestamp?: boolean
    starred?: boolean
    status?: boolean
    statusAlreadyViewed?: boolean
    statusPsa?: boolean
    urlNumber?: boolean
    urlText?: boolean
    userReceipt?: boolean
    verifiedBizName?: boolean
    eventResponses?: boolean
    pinInChat?: boolean
    reportingTokenInfo?: boolean
  }

  export type MessageOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"pkId" | "sessionId" | "remoteJid" | "id" | "agentId" | "bizPrivacyStatus" | "broadcast" | "clearMedia" | "duration" | "ephemeralDuration" | "ephemeralOffToOn" | "ephemeralOutOfSync" | "ephemeralStartTimestamp" | "finalLiveLocation" | "futureproofData" | "ignore" | "keepInChat" | "key" | "labels" | "mediaCiphertextSha256" | "mediaData" | "message" | "messageC2STimestamp" | "messageSecret" | "messageStubParameters" | "messageStubType" | "messageTimestamp" | "multicast" | "originalSelfAuthorUserJidString" | "participant" | "paymentInfo" | "photoChange" | "pollAdditionalMetadata" | "pollUpdates" | "pushName" | "quotedPaymentInfo" | "quotedStickerData" | "reactions" | "revokeMessageTimestamp" | "starred" | "status" | "statusAlreadyViewed" | "statusPsa" | "urlNumber" | "urlText" | "userReceipt" | "verifiedBizName" | "eventResponses" | "pinInChat" | "reportingTokenInfo", ExtArgs["result"]["message"]>

  export type $MessagePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Message"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      pkId: number
      sessionId: string
      remoteJid: string
      id: string
      agentId: string | null
      bizPrivacyStatus: number | null
      broadcast: boolean | null
      clearMedia: boolean | null
      duration: number | null
      ephemeralDuration: number | null
      ephemeralOffToOn: boolean | null
      ephemeralOutOfSync: boolean | null
      ephemeralStartTimestamp: bigint | null
      finalLiveLocation: Prisma.JsonValue | null
      futureproofData: Uint8Array | null
      ignore: boolean | null
      keepInChat: Prisma.JsonValue | null
      key: Prisma.JsonValue
      labels: Prisma.JsonValue | null
      mediaCiphertextSha256: Uint8Array | null
      mediaData: Prisma.JsonValue | null
      message: Prisma.JsonValue | null
      messageC2STimestamp: bigint | null
      messageSecret: Uint8Array | null
      messageStubParameters: Prisma.JsonValue | null
      messageStubType: number | null
      messageTimestamp: bigint | null
      multicast: boolean | null
      originalSelfAuthorUserJidString: string | null
      participant: string | null
      paymentInfo: Prisma.JsonValue | null
      photoChange: Prisma.JsonValue | null
      pollAdditionalMetadata: Prisma.JsonValue | null
      pollUpdates: Prisma.JsonValue | null
      pushName: string | null
      quotedPaymentInfo: Prisma.JsonValue | null
      quotedStickerData: Prisma.JsonValue | null
      reactions: Prisma.JsonValue | null
      revokeMessageTimestamp: bigint | null
      starred: boolean | null
      status: number | null
      statusAlreadyViewed: boolean | null
      statusPsa: Prisma.JsonValue | null
      urlNumber: boolean | null
      urlText: boolean | null
      userReceipt: Prisma.JsonValue | null
      verifiedBizName: string | null
      eventResponses: Prisma.JsonValue | null
      pinInChat: Prisma.JsonValue | null
      reportingTokenInfo: Prisma.JsonValue | null
    }, ExtArgs["result"]["message"]>
    composites: {}
  }

  type MessageGetPayload<S extends boolean | null | undefined | MessageDefaultArgs> = $Result.GetResult<Prisma.$MessagePayload, S>

  type MessageCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<MessageFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: MessageCountAggregateInputType | true
    }

  export interface MessageDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Message'], meta: { name: 'Message' } }
    /**
     * Find zero or one Message that matches the filter.
     * @param {MessageFindUniqueArgs} args - Arguments to find a Message
     * @example
     * // Get one Message
     * const message = await prisma.message.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends MessageFindUniqueArgs>(args: SelectSubset<T, MessageFindUniqueArgs<ExtArgs>>): Prisma__MessageClient<$Result.GetResult<Prisma.$MessagePayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Message that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {MessageFindUniqueOrThrowArgs} args - Arguments to find a Message
     * @example
     * // Get one Message
     * const message = await prisma.message.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends MessageFindUniqueOrThrowArgs>(args: SelectSubset<T, MessageFindUniqueOrThrowArgs<ExtArgs>>): Prisma__MessageClient<$Result.GetResult<Prisma.$MessagePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Message that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MessageFindFirstArgs} args - Arguments to find a Message
     * @example
     * // Get one Message
     * const message = await prisma.message.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends MessageFindFirstArgs>(args?: SelectSubset<T, MessageFindFirstArgs<ExtArgs>>): Prisma__MessageClient<$Result.GetResult<Prisma.$MessagePayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Message that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MessageFindFirstOrThrowArgs} args - Arguments to find a Message
     * @example
     * // Get one Message
     * const message = await prisma.message.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends MessageFindFirstOrThrowArgs>(args?: SelectSubset<T, MessageFindFirstOrThrowArgs<ExtArgs>>): Prisma__MessageClient<$Result.GetResult<Prisma.$MessagePayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Messages that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MessageFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Messages
     * const messages = await prisma.message.findMany()
     * 
     * // Get first 10 Messages
     * const messages = await prisma.message.findMany({ take: 10 })
     * 
     * // Only select the `pkId`
     * const messageWithPkIdOnly = await prisma.message.findMany({ select: { pkId: true } })
     * 
     */
    findMany<T extends MessageFindManyArgs>(args?: SelectSubset<T, MessageFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MessagePayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Message.
     * @param {MessageCreateArgs} args - Arguments to create a Message.
     * @example
     * // Create one Message
     * const Message = await prisma.message.create({
     *   data: {
     *     // ... data to create a Message
     *   }
     * })
     * 
     */
    create<T extends MessageCreateArgs>(args: SelectSubset<T, MessageCreateArgs<ExtArgs>>): Prisma__MessageClient<$Result.GetResult<Prisma.$MessagePayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Messages.
     * @param {MessageCreateManyArgs} args - Arguments to create many Messages.
     * @example
     * // Create many Messages
     * const message = await prisma.message.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends MessageCreateManyArgs>(args?: SelectSubset<T, MessageCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Message.
     * @param {MessageDeleteArgs} args - Arguments to delete one Message.
     * @example
     * // Delete one Message
     * const Message = await prisma.message.delete({
     *   where: {
     *     // ... filter to delete one Message
     *   }
     * })
     * 
     */
    delete<T extends MessageDeleteArgs>(args: SelectSubset<T, MessageDeleteArgs<ExtArgs>>): Prisma__MessageClient<$Result.GetResult<Prisma.$MessagePayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Message.
     * @param {MessageUpdateArgs} args - Arguments to update one Message.
     * @example
     * // Update one Message
     * const message = await prisma.message.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends MessageUpdateArgs>(args: SelectSubset<T, MessageUpdateArgs<ExtArgs>>): Prisma__MessageClient<$Result.GetResult<Prisma.$MessagePayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Messages.
     * @param {MessageDeleteManyArgs} args - Arguments to filter Messages to delete.
     * @example
     * // Delete a few Messages
     * const { count } = await prisma.message.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends MessageDeleteManyArgs>(args?: SelectSubset<T, MessageDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Messages.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MessageUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Messages
     * const message = await prisma.message.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends MessageUpdateManyArgs>(args: SelectSubset<T, MessageUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Message.
     * @param {MessageUpsertArgs} args - Arguments to update or create a Message.
     * @example
     * // Update or create a Message
     * const message = await prisma.message.upsert({
     *   create: {
     *     // ... data to create a Message
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Message we want to update
     *   }
     * })
     */
    upsert<T extends MessageUpsertArgs>(args: SelectSubset<T, MessageUpsertArgs<ExtArgs>>): Prisma__MessageClient<$Result.GetResult<Prisma.$MessagePayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Messages.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MessageCountArgs} args - Arguments to filter Messages to count.
     * @example
     * // Count the number of Messages
     * const count = await prisma.message.count({
     *   where: {
     *     // ... the filter for the Messages we want to count
     *   }
     * })
    **/
    count<T extends MessageCountArgs>(
      args?: Subset<T, MessageCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], MessageCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Message.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MessageAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends MessageAggregateArgs>(args: Subset<T, MessageAggregateArgs>): Prisma.PrismaPromise<GetMessageAggregateType<T>>

    /**
     * Group by Message.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MessageGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends MessageGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: MessageGroupByArgs['orderBy'] }
        : { orderBy?: MessageGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, MessageGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetMessageGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Message model
   */
  readonly fields: MessageFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Message.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__MessageClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Message model
   */
  interface MessageFieldRefs {
    readonly pkId: FieldRef<"Message", 'Int'>
    readonly sessionId: FieldRef<"Message", 'String'>
    readonly remoteJid: FieldRef<"Message", 'String'>
    readonly id: FieldRef<"Message", 'String'>
    readonly agentId: FieldRef<"Message", 'String'>
    readonly bizPrivacyStatus: FieldRef<"Message", 'Int'>
    readonly broadcast: FieldRef<"Message", 'Boolean'>
    readonly clearMedia: FieldRef<"Message", 'Boolean'>
    readonly duration: FieldRef<"Message", 'Int'>
    readonly ephemeralDuration: FieldRef<"Message", 'Int'>
    readonly ephemeralOffToOn: FieldRef<"Message", 'Boolean'>
    readonly ephemeralOutOfSync: FieldRef<"Message", 'Boolean'>
    readonly ephemeralStartTimestamp: FieldRef<"Message", 'BigInt'>
    readonly finalLiveLocation: FieldRef<"Message", 'Json'>
    readonly futureproofData: FieldRef<"Message", 'Bytes'>
    readonly ignore: FieldRef<"Message", 'Boolean'>
    readonly keepInChat: FieldRef<"Message", 'Json'>
    readonly key: FieldRef<"Message", 'Json'>
    readonly labels: FieldRef<"Message", 'Json'>
    readonly mediaCiphertextSha256: FieldRef<"Message", 'Bytes'>
    readonly mediaData: FieldRef<"Message", 'Json'>
    readonly message: FieldRef<"Message", 'Json'>
    readonly messageC2STimestamp: FieldRef<"Message", 'BigInt'>
    readonly messageSecret: FieldRef<"Message", 'Bytes'>
    readonly messageStubParameters: FieldRef<"Message", 'Json'>
    readonly messageStubType: FieldRef<"Message", 'Int'>
    readonly messageTimestamp: FieldRef<"Message", 'BigInt'>
    readonly multicast: FieldRef<"Message", 'Boolean'>
    readonly originalSelfAuthorUserJidString: FieldRef<"Message", 'String'>
    readonly participant: FieldRef<"Message", 'String'>
    readonly paymentInfo: FieldRef<"Message", 'Json'>
    readonly photoChange: FieldRef<"Message", 'Json'>
    readonly pollAdditionalMetadata: FieldRef<"Message", 'Json'>
    readonly pollUpdates: FieldRef<"Message", 'Json'>
    readonly pushName: FieldRef<"Message", 'String'>
    readonly quotedPaymentInfo: FieldRef<"Message", 'Json'>
    readonly quotedStickerData: FieldRef<"Message", 'Json'>
    readonly reactions: FieldRef<"Message", 'Json'>
    readonly revokeMessageTimestamp: FieldRef<"Message", 'BigInt'>
    readonly starred: FieldRef<"Message", 'Boolean'>
    readonly status: FieldRef<"Message", 'Int'>
    readonly statusAlreadyViewed: FieldRef<"Message", 'Boolean'>
    readonly statusPsa: FieldRef<"Message", 'Json'>
    readonly urlNumber: FieldRef<"Message", 'Boolean'>
    readonly urlText: FieldRef<"Message", 'Boolean'>
    readonly userReceipt: FieldRef<"Message", 'Json'>
    readonly verifiedBizName: FieldRef<"Message", 'String'>
    readonly eventResponses: FieldRef<"Message", 'Json'>
    readonly pinInChat: FieldRef<"Message", 'Json'>
    readonly reportingTokenInfo: FieldRef<"Message", 'Json'>
  }
    

  // Custom InputTypes
  /**
   * Message findUnique
   */
  export type MessageFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Message
     */
    select?: MessageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Message
     */
    omit?: MessageOmit<ExtArgs> | null
    /**
     * Filter, which Message to fetch.
     */
    where: MessageWhereUniqueInput
  }

  /**
   * Message findUniqueOrThrow
   */
  export type MessageFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Message
     */
    select?: MessageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Message
     */
    omit?: MessageOmit<ExtArgs> | null
    /**
     * Filter, which Message to fetch.
     */
    where: MessageWhereUniqueInput
  }

  /**
   * Message findFirst
   */
  export type MessageFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Message
     */
    select?: MessageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Message
     */
    omit?: MessageOmit<ExtArgs> | null
    /**
     * Filter, which Message to fetch.
     */
    where?: MessageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Messages to fetch.
     */
    orderBy?: MessageOrderByWithRelationInput | MessageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Messages.
     */
    cursor?: MessageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Messages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Messages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Messages.
     */
    distinct?: MessageScalarFieldEnum | MessageScalarFieldEnum[]
  }

  /**
   * Message findFirstOrThrow
   */
  export type MessageFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Message
     */
    select?: MessageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Message
     */
    omit?: MessageOmit<ExtArgs> | null
    /**
     * Filter, which Message to fetch.
     */
    where?: MessageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Messages to fetch.
     */
    orderBy?: MessageOrderByWithRelationInput | MessageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Messages.
     */
    cursor?: MessageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Messages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Messages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Messages.
     */
    distinct?: MessageScalarFieldEnum | MessageScalarFieldEnum[]
  }

  /**
   * Message findMany
   */
  export type MessageFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Message
     */
    select?: MessageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Message
     */
    omit?: MessageOmit<ExtArgs> | null
    /**
     * Filter, which Messages to fetch.
     */
    where?: MessageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Messages to fetch.
     */
    orderBy?: MessageOrderByWithRelationInput | MessageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Messages.
     */
    cursor?: MessageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Messages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Messages.
     */
    skip?: number
    distinct?: MessageScalarFieldEnum | MessageScalarFieldEnum[]
  }

  /**
   * Message create
   */
  export type MessageCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Message
     */
    select?: MessageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Message
     */
    omit?: MessageOmit<ExtArgs> | null
    /**
     * The data needed to create a Message.
     */
    data: XOR<MessageCreateInput, MessageUncheckedCreateInput>
  }

  /**
   * Message createMany
   */
  export type MessageCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Messages.
     */
    data: MessageCreateManyInput | MessageCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Message update
   */
  export type MessageUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Message
     */
    select?: MessageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Message
     */
    omit?: MessageOmit<ExtArgs> | null
    /**
     * The data needed to update a Message.
     */
    data: XOR<MessageUpdateInput, MessageUncheckedUpdateInput>
    /**
     * Choose, which Message to update.
     */
    where: MessageWhereUniqueInput
  }

  /**
   * Message updateMany
   */
  export type MessageUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Messages.
     */
    data: XOR<MessageUpdateManyMutationInput, MessageUncheckedUpdateManyInput>
    /**
     * Filter which Messages to update
     */
    where?: MessageWhereInput
    /**
     * Limit how many Messages to update.
     */
    limit?: number
  }

  /**
   * Message upsert
   */
  export type MessageUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Message
     */
    select?: MessageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Message
     */
    omit?: MessageOmit<ExtArgs> | null
    /**
     * The filter to search for the Message to update in case it exists.
     */
    where: MessageWhereUniqueInput
    /**
     * In case the Message found by the `where` argument doesn't exist, create a new Message with this data.
     */
    create: XOR<MessageCreateInput, MessageUncheckedCreateInput>
    /**
     * In case the Message was found with the provided `where` argument, update it with this data.
     */
    update: XOR<MessageUpdateInput, MessageUncheckedUpdateInput>
  }

  /**
   * Message delete
   */
  export type MessageDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Message
     */
    select?: MessageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Message
     */
    omit?: MessageOmit<ExtArgs> | null
    /**
     * Filter which Message to delete.
     */
    where: MessageWhereUniqueInput
  }

  /**
   * Message deleteMany
   */
  export type MessageDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Messages to delete
     */
    where?: MessageWhereInput
    /**
     * Limit how many Messages to delete.
     */
    limit?: number
  }

  /**
   * Message without action
   */
  export type MessageDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Message
     */
    select?: MessageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Message
     */
    omit?: MessageOmit<ExtArgs> | null
  }


  /**
   * Model Session
   */

  export type AggregateSession = {
    _count: SessionCountAggregateOutputType | null
    _avg: SessionAvgAggregateOutputType | null
    _sum: SessionSumAggregateOutputType | null
    _min: SessionMinAggregateOutputType | null
    _max: SessionMaxAggregateOutputType | null
  }

  export type SessionAvgAggregateOutputType = {
    pkId: number | null
  }

  export type SessionSumAggregateOutputType = {
    pkId: number | null
  }

  export type SessionMinAggregateOutputType = {
    pkId: number | null
    sessionId: string | null
    id: string | null
    data: string | null
  }

  export type SessionMaxAggregateOutputType = {
    pkId: number | null
    sessionId: string | null
    id: string | null
    data: string | null
  }

  export type SessionCountAggregateOutputType = {
    pkId: number
    sessionId: number
    id: number
    data: number
    _all: number
  }


  export type SessionAvgAggregateInputType = {
    pkId?: true
  }

  export type SessionSumAggregateInputType = {
    pkId?: true
  }

  export type SessionMinAggregateInputType = {
    pkId?: true
    sessionId?: true
    id?: true
    data?: true
  }

  export type SessionMaxAggregateInputType = {
    pkId?: true
    sessionId?: true
    id?: true
    data?: true
  }

  export type SessionCountAggregateInputType = {
    pkId?: true
    sessionId?: true
    id?: true
    data?: true
    _all?: true
  }

  export type SessionAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Session to aggregate.
     */
    where?: SessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Sessions to fetch.
     */
    orderBy?: SessionOrderByWithRelationInput | SessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: SessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Sessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Sessions
    **/
    _count?: true | SessionCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: SessionAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: SessionSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: SessionMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: SessionMaxAggregateInputType
  }

  export type GetSessionAggregateType<T extends SessionAggregateArgs> = {
        [P in keyof T & keyof AggregateSession]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateSession[P]>
      : GetScalarType<T[P], AggregateSession[P]>
  }




  export type SessionGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: SessionWhereInput
    orderBy?: SessionOrderByWithAggregationInput | SessionOrderByWithAggregationInput[]
    by: SessionScalarFieldEnum[] | SessionScalarFieldEnum
    having?: SessionScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: SessionCountAggregateInputType | true
    _avg?: SessionAvgAggregateInputType
    _sum?: SessionSumAggregateInputType
    _min?: SessionMinAggregateInputType
    _max?: SessionMaxAggregateInputType
  }

  export type SessionGroupByOutputType = {
    pkId: number
    sessionId: string
    id: string
    data: string
    _count: SessionCountAggregateOutputType | null
    _avg: SessionAvgAggregateOutputType | null
    _sum: SessionSumAggregateOutputType | null
    _min: SessionMinAggregateOutputType | null
    _max: SessionMaxAggregateOutputType | null
  }

  type GetSessionGroupByPayload<T extends SessionGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<SessionGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof SessionGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], SessionGroupByOutputType[P]>
            : GetScalarType<T[P], SessionGroupByOutputType[P]>
        }
      >
    >


  export type SessionSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    pkId?: boolean
    sessionId?: boolean
    id?: boolean
    data?: boolean
  }, ExtArgs["result"]["session"]>



  export type SessionSelectScalar = {
    pkId?: boolean
    sessionId?: boolean
    id?: boolean
    data?: boolean
  }

  export type SessionOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"pkId" | "sessionId" | "id" | "data", ExtArgs["result"]["session"]>

  export type $SessionPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Session"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      pkId: number
      sessionId: string
      id: string
      data: string
    }, ExtArgs["result"]["session"]>
    composites: {}
  }

  type SessionGetPayload<S extends boolean | null | undefined | SessionDefaultArgs> = $Result.GetResult<Prisma.$SessionPayload, S>

  type SessionCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<SessionFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: SessionCountAggregateInputType | true
    }

  export interface SessionDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Session'], meta: { name: 'Session' } }
    /**
     * Find zero or one Session that matches the filter.
     * @param {SessionFindUniqueArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends SessionFindUniqueArgs>(args: SelectSubset<T, SessionFindUniqueArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Session that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {SessionFindUniqueOrThrowArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends SessionFindUniqueOrThrowArgs>(args: SelectSubset<T, SessionFindUniqueOrThrowArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Session that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionFindFirstArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends SessionFindFirstArgs>(args?: SelectSubset<T, SessionFindFirstArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Session that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionFindFirstOrThrowArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends SessionFindFirstOrThrowArgs>(args?: SelectSubset<T, SessionFindFirstOrThrowArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Sessions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Sessions
     * const sessions = await prisma.session.findMany()
     * 
     * // Get first 10 Sessions
     * const sessions = await prisma.session.findMany({ take: 10 })
     * 
     * // Only select the `pkId`
     * const sessionWithPkIdOnly = await prisma.session.findMany({ select: { pkId: true } })
     * 
     */
    findMany<T extends SessionFindManyArgs>(args?: SelectSubset<T, SessionFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Session.
     * @param {SessionCreateArgs} args - Arguments to create a Session.
     * @example
     * // Create one Session
     * const Session = await prisma.session.create({
     *   data: {
     *     // ... data to create a Session
     *   }
     * })
     * 
     */
    create<T extends SessionCreateArgs>(args: SelectSubset<T, SessionCreateArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Sessions.
     * @param {SessionCreateManyArgs} args - Arguments to create many Sessions.
     * @example
     * // Create many Sessions
     * const session = await prisma.session.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends SessionCreateManyArgs>(args?: SelectSubset<T, SessionCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Session.
     * @param {SessionDeleteArgs} args - Arguments to delete one Session.
     * @example
     * // Delete one Session
     * const Session = await prisma.session.delete({
     *   where: {
     *     // ... filter to delete one Session
     *   }
     * })
     * 
     */
    delete<T extends SessionDeleteArgs>(args: SelectSubset<T, SessionDeleteArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Session.
     * @param {SessionUpdateArgs} args - Arguments to update one Session.
     * @example
     * // Update one Session
     * const session = await prisma.session.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends SessionUpdateArgs>(args: SelectSubset<T, SessionUpdateArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Sessions.
     * @param {SessionDeleteManyArgs} args - Arguments to filter Sessions to delete.
     * @example
     * // Delete a few Sessions
     * const { count } = await prisma.session.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends SessionDeleteManyArgs>(args?: SelectSubset<T, SessionDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Sessions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Sessions
     * const session = await prisma.session.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends SessionUpdateManyArgs>(args: SelectSubset<T, SessionUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Session.
     * @param {SessionUpsertArgs} args - Arguments to update or create a Session.
     * @example
     * // Update or create a Session
     * const session = await prisma.session.upsert({
     *   create: {
     *     // ... data to create a Session
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Session we want to update
     *   }
     * })
     */
    upsert<T extends SessionUpsertArgs>(args: SelectSubset<T, SessionUpsertArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Sessions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionCountArgs} args - Arguments to filter Sessions to count.
     * @example
     * // Count the number of Sessions
     * const count = await prisma.session.count({
     *   where: {
     *     // ... the filter for the Sessions we want to count
     *   }
     * })
    **/
    count<T extends SessionCountArgs>(
      args?: Subset<T, SessionCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], SessionCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Session.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends SessionAggregateArgs>(args: Subset<T, SessionAggregateArgs>): Prisma.PrismaPromise<GetSessionAggregateType<T>>

    /**
     * Group by Session.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends SessionGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: SessionGroupByArgs['orderBy'] }
        : { orderBy?: SessionGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, SessionGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetSessionGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Session model
   */
  readonly fields: SessionFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Session.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__SessionClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Session model
   */
  interface SessionFieldRefs {
    readonly pkId: FieldRef<"Session", 'Int'>
    readonly sessionId: FieldRef<"Session", 'String'>
    readonly id: FieldRef<"Session", 'String'>
    readonly data: FieldRef<"Session", 'String'>
  }
    

  // Custom InputTypes
  /**
   * Session findUnique
   */
  export type SessionFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Filter, which Session to fetch.
     */
    where: SessionWhereUniqueInput
  }

  /**
   * Session findUniqueOrThrow
   */
  export type SessionFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Filter, which Session to fetch.
     */
    where: SessionWhereUniqueInput
  }

  /**
   * Session findFirst
   */
  export type SessionFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Filter, which Session to fetch.
     */
    where?: SessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Sessions to fetch.
     */
    orderBy?: SessionOrderByWithRelationInput | SessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Sessions.
     */
    cursor?: SessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Sessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Sessions.
     */
    distinct?: SessionScalarFieldEnum | SessionScalarFieldEnum[]
  }

  /**
   * Session findFirstOrThrow
   */
  export type SessionFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Filter, which Session to fetch.
     */
    where?: SessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Sessions to fetch.
     */
    orderBy?: SessionOrderByWithRelationInput | SessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Sessions.
     */
    cursor?: SessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Sessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Sessions.
     */
    distinct?: SessionScalarFieldEnum | SessionScalarFieldEnum[]
  }

  /**
   * Session findMany
   */
  export type SessionFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Filter, which Sessions to fetch.
     */
    where?: SessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Sessions to fetch.
     */
    orderBy?: SessionOrderByWithRelationInput | SessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Sessions.
     */
    cursor?: SessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Sessions.
     */
    skip?: number
    distinct?: SessionScalarFieldEnum | SessionScalarFieldEnum[]
  }

  /**
   * Session create
   */
  export type SessionCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * The data needed to create a Session.
     */
    data: XOR<SessionCreateInput, SessionUncheckedCreateInput>
  }

  /**
   * Session createMany
   */
  export type SessionCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Sessions.
     */
    data: SessionCreateManyInput | SessionCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Session update
   */
  export type SessionUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * The data needed to update a Session.
     */
    data: XOR<SessionUpdateInput, SessionUncheckedUpdateInput>
    /**
     * Choose, which Session to update.
     */
    where: SessionWhereUniqueInput
  }

  /**
   * Session updateMany
   */
  export type SessionUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Sessions.
     */
    data: XOR<SessionUpdateManyMutationInput, SessionUncheckedUpdateManyInput>
    /**
     * Filter which Sessions to update
     */
    where?: SessionWhereInput
    /**
     * Limit how many Sessions to update.
     */
    limit?: number
  }

  /**
   * Session upsert
   */
  export type SessionUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * The filter to search for the Session to update in case it exists.
     */
    where: SessionWhereUniqueInput
    /**
     * In case the Session found by the `where` argument doesn't exist, create a new Session with this data.
     */
    create: XOR<SessionCreateInput, SessionUncheckedCreateInput>
    /**
     * In case the Session was found with the provided `where` argument, update it with this data.
     */
    update: XOR<SessionUpdateInput, SessionUncheckedUpdateInput>
  }

  /**
   * Session delete
   */
  export type SessionDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Filter which Session to delete.
     */
    where: SessionWhereUniqueInput
  }

  /**
   * Session deleteMany
   */
  export type SessionDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Sessions to delete
     */
    where?: SessionWhereInput
    /**
     * Limit how many Sessions to delete.
     */
    limit?: number
  }

  /**
   * Session without action
   */
  export type SessionDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
  }


  /**
   * Enums
   */

  export const TransactionIsolationLevel: {
    ReadUncommitted: 'ReadUncommitted',
    ReadCommitted: 'ReadCommitted',
    RepeatableRead: 'RepeatableRead',
    Serializable: 'Serializable'
  };

  export type TransactionIsolationLevel = (typeof TransactionIsolationLevel)[keyof typeof TransactionIsolationLevel]


  export const ChatScalarFieldEnum: {
    pkId: 'pkId',
    sessionId: 'sessionId',
    archived: 'archived',
    contactPrimaryIdentityKey: 'contactPrimaryIdentityKey',
    conversationTimestamp: 'conversationTimestamp',
    createdAt: 'createdAt',
    createdBy: 'createdBy',
    description: 'description',
    disappearingMode: 'disappearingMode',
    displayName: 'displayName',
    endOfHistoryTransfer: 'endOfHistoryTransfer',
    endOfHistoryTransferType: 'endOfHistoryTransferType',
    ephemeralExpiration: 'ephemeralExpiration',
    ephemeralSettingTimestamp: 'ephemeralSettingTimestamp',
    id: 'id',
    isDefaultSubgroup: 'isDefaultSubgroup',
    isParentGroup: 'isParentGroup',
    lastMsgTimestamp: 'lastMsgTimestamp',
    lidJid: 'lidJid',
    markedAsUnread: 'markedAsUnread',
    mediaVisibility: 'mediaVisibility',
    messages: 'messages',
    muteEndTime: 'muteEndTime',
    name: 'name',
    newJid: 'newJid',
    notSpam: 'notSpam',
    oldJid: 'oldJid',
    pHash: 'pHash',
    parentGroupId: 'parentGroupId',
    participant: 'participant',
    pinned: 'pinned',
    pnJid: 'pnJid',
    pnhDuplicateLidThread: 'pnhDuplicateLidThread',
    readOnly: 'readOnly',
    shareOwnPn: 'shareOwnPn',
    support: 'support',
    suspended: 'suspended',
    tcToken: 'tcToken',
    tcTokenSenderTimestamp: 'tcTokenSenderTimestamp',
    tcTokenTimestamp: 'tcTokenTimestamp',
    terminated: 'terminated',
    unreadCount: 'unreadCount',
    unreadMentionCount: 'unreadMentionCount',
    wallpaper: 'wallpaper',
    lastMessageRecvTimestamp: 'lastMessageRecvTimestamp',
    commentsCount: 'commentsCount',
    picture: 'picture',
    auto_reply_enabled: 'auto_reply_enabled',
    badge_id: 'badge_id'
  };

  export type ChatScalarFieldEnum = (typeof ChatScalarFieldEnum)[keyof typeof ChatScalarFieldEnum]


  export const ContactScalarFieldEnum: {
    pkId: 'pkId',
    sessionId: 'sessionId',
    id: 'id',
    name: 'name',
    notify: 'notify',
    verifiedName: 'verifiedName',
    imgUrl: 'imgUrl',
    status: 'status'
  };

  export type ContactScalarFieldEnum = (typeof ContactScalarFieldEnum)[keyof typeof ContactScalarFieldEnum]


  export const GroupMetadataScalarFieldEnum: {
    pkId: 'pkId',
    sessionId: 'sessionId',
    id: 'id',
    owner: 'owner',
    subject: 'subject',
    subjectOwner: 'subjectOwner',
    subjectTime: 'subjectTime',
    creation: 'creation',
    desc: 'desc',
    descOwner: 'descOwner',
    descId: 'descId',
    restrict: 'restrict',
    announce: 'announce',
    isCommunity: 'isCommunity',
    isCommunityAnnounce: 'isCommunityAnnounce',
    joinApprovalMode: 'joinApprovalMode',
    memberAddMode: 'memberAddMode',
    author: 'author',
    size: 'size',
    participants: 'participants',
    ephemeralDuration: 'ephemeralDuration',
    inviteCode: 'inviteCode'
  };

  export type GroupMetadataScalarFieldEnum = (typeof GroupMetadataScalarFieldEnum)[keyof typeof GroupMetadataScalarFieldEnum]


  export const MessageScalarFieldEnum: {
    pkId: 'pkId',
    sessionId: 'sessionId',
    remoteJid: 'remoteJid',
    id: 'id',
    agentId: 'agentId',
    bizPrivacyStatus: 'bizPrivacyStatus',
    broadcast: 'broadcast',
    clearMedia: 'clearMedia',
    duration: 'duration',
    ephemeralDuration: 'ephemeralDuration',
    ephemeralOffToOn: 'ephemeralOffToOn',
    ephemeralOutOfSync: 'ephemeralOutOfSync',
    ephemeralStartTimestamp: 'ephemeralStartTimestamp',
    finalLiveLocation: 'finalLiveLocation',
    futureproofData: 'futureproofData',
    ignore: 'ignore',
    keepInChat: 'keepInChat',
    key: 'key',
    labels: 'labels',
    mediaCiphertextSha256: 'mediaCiphertextSha256',
    mediaData: 'mediaData',
    message: 'message',
    messageC2STimestamp: 'messageC2STimestamp',
    messageSecret: 'messageSecret',
    messageStubParameters: 'messageStubParameters',
    messageStubType: 'messageStubType',
    messageTimestamp: 'messageTimestamp',
    multicast: 'multicast',
    originalSelfAuthorUserJidString: 'originalSelfAuthorUserJidString',
    participant: 'participant',
    paymentInfo: 'paymentInfo',
    photoChange: 'photoChange',
    pollAdditionalMetadata: 'pollAdditionalMetadata',
    pollUpdates: 'pollUpdates',
    pushName: 'pushName',
    quotedPaymentInfo: 'quotedPaymentInfo',
    quotedStickerData: 'quotedStickerData',
    reactions: 'reactions',
    revokeMessageTimestamp: 'revokeMessageTimestamp',
    starred: 'starred',
    status: 'status',
    statusAlreadyViewed: 'statusAlreadyViewed',
    statusPsa: 'statusPsa',
    urlNumber: 'urlNumber',
    urlText: 'urlText',
    userReceipt: 'userReceipt',
    verifiedBizName: 'verifiedBizName',
    eventResponses: 'eventResponses',
    pinInChat: 'pinInChat',
    reportingTokenInfo: 'reportingTokenInfo'
  };

  export type MessageScalarFieldEnum = (typeof MessageScalarFieldEnum)[keyof typeof MessageScalarFieldEnum]


  export const SessionScalarFieldEnum: {
    pkId: 'pkId',
    sessionId: 'sessionId',
    id: 'id',
    data: 'data'
  };

  export type SessionScalarFieldEnum = (typeof SessionScalarFieldEnum)[keyof typeof SessionScalarFieldEnum]


  export const SortOrder: {
    asc: 'asc',
    desc: 'desc'
  };

  export type SortOrder = (typeof SortOrder)[keyof typeof SortOrder]


  export const NullableJsonNullValueInput: {
    DbNull: typeof DbNull,
    JsonNull: typeof JsonNull
  };

  export type NullableJsonNullValueInput = (typeof NullableJsonNullValueInput)[keyof typeof NullableJsonNullValueInput]


  export const JsonNullValueInput: {
    JsonNull: typeof JsonNull
  };

  export type JsonNullValueInput = (typeof JsonNullValueInput)[keyof typeof JsonNullValueInput]


  export const JsonNullValueFilter: {
    DbNull: typeof DbNull,
    JsonNull: typeof JsonNull,
    AnyNull: typeof AnyNull
  };

  export type JsonNullValueFilter = (typeof JsonNullValueFilter)[keyof typeof JsonNullValueFilter]


  export const QueryMode: {
    default: 'default',
    insensitive: 'insensitive'
  };

  export type QueryMode = (typeof QueryMode)[keyof typeof QueryMode]


  export const NullsOrder: {
    first: 'first',
    last: 'last'
  };

  export type NullsOrder = (typeof NullsOrder)[keyof typeof NullsOrder]


  export const ChatOrderByRelevanceFieldEnum: {
    sessionId: 'sessionId',
    createdBy: 'createdBy',
    description: 'description',
    displayName: 'displayName',
    id: 'id',
    lidJid: 'lidJid',
    name: 'name',
    newJid: 'newJid',
    oldJid: 'oldJid',
    pHash: 'pHash',
    parentGroupId: 'parentGroupId',
    pnJid: 'pnJid',
    picture: 'picture'
  };

  export type ChatOrderByRelevanceFieldEnum = (typeof ChatOrderByRelevanceFieldEnum)[keyof typeof ChatOrderByRelevanceFieldEnum]


  export const ContactOrderByRelevanceFieldEnum: {
    sessionId: 'sessionId',
    id: 'id',
    name: 'name',
    notify: 'notify',
    verifiedName: 'verifiedName',
    imgUrl: 'imgUrl',
    status: 'status'
  };

  export type ContactOrderByRelevanceFieldEnum = (typeof ContactOrderByRelevanceFieldEnum)[keyof typeof ContactOrderByRelevanceFieldEnum]


  export const GroupMetadataOrderByRelevanceFieldEnum: {
    sessionId: 'sessionId',
    id: 'id',
    owner: 'owner',
    subject: 'subject',
    subjectOwner: 'subjectOwner',
    desc: 'desc',
    descOwner: 'descOwner',
    descId: 'descId',
    author: 'author',
    inviteCode: 'inviteCode'
  };

  export type GroupMetadataOrderByRelevanceFieldEnum = (typeof GroupMetadataOrderByRelevanceFieldEnum)[keyof typeof GroupMetadataOrderByRelevanceFieldEnum]


  export const MessageOrderByRelevanceFieldEnum: {
    sessionId: 'sessionId',
    remoteJid: 'remoteJid',
    id: 'id',
    agentId: 'agentId',
    originalSelfAuthorUserJidString: 'originalSelfAuthorUserJidString',
    participant: 'participant',
    pushName: 'pushName',
    verifiedBizName: 'verifiedBizName'
  };

  export type MessageOrderByRelevanceFieldEnum = (typeof MessageOrderByRelevanceFieldEnum)[keyof typeof MessageOrderByRelevanceFieldEnum]


  export const SessionOrderByRelevanceFieldEnum: {
    sessionId: 'sessionId',
    id: 'id',
    data: 'data'
  };

  export type SessionOrderByRelevanceFieldEnum = (typeof SessionOrderByRelevanceFieldEnum)[keyof typeof SessionOrderByRelevanceFieldEnum]


  /**
   * Field references
   */


  /**
   * Reference to a field of type 'Int'
   */
  export type IntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Int'>
    


  /**
   * Reference to a field of type 'String'
   */
  export type StringFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'String'>
    


  /**
   * Reference to a field of type 'Boolean'
   */
  export type BooleanFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Boolean'>
    


  /**
   * Reference to a field of type 'Bytes'
   */
  export type BytesFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Bytes'>
    


  /**
   * Reference to a field of type 'BigInt'
   */
  export type BigIntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'BigInt'>
    


  /**
   * Reference to a field of type 'Json'
   */
  export type JsonFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Json'>
    


  /**
   * Reference to a field of type 'QueryMode'
   */
  export type EnumQueryModeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'QueryMode'>
    


  /**
   * Reference to a field of type 'Float'
   */
  export type FloatFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Float'>
    
  /**
   * Deep Input Types
   */


  export type ChatWhereInput = {
    AND?: ChatWhereInput | ChatWhereInput[]
    OR?: ChatWhereInput[]
    NOT?: ChatWhereInput | ChatWhereInput[]
    pkId?: IntFilter<"Chat"> | number
    sessionId?: StringFilter<"Chat"> | string
    archived?: BoolNullableFilter<"Chat"> | boolean | null
    contactPrimaryIdentityKey?: BytesNullableFilter<"Chat"> | Uint8Array | null
    conversationTimestamp?: BigIntNullableFilter<"Chat"> | bigint | number | null
    createdAt?: BigIntNullableFilter<"Chat"> | bigint | number | null
    createdBy?: StringNullableFilter<"Chat"> | string | null
    description?: StringNullableFilter<"Chat"> | string | null
    disappearingMode?: JsonNullableFilter<"Chat">
    displayName?: StringNullableFilter<"Chat"> | string | null
    endOfHistoryTransfer?: BoolNullableFilter<"Chat"> | boolean | null
    endOfHistoryTransferType?: IntNullableFilter<"Chat"> | number | null
    ephemeralExpiration?: IntNullableFilter<"Chat"> | number | null
    ephemeralSettingTimestamp?: BigIntNullableFilter<"Chat"> | bigint | number | null
    id?: StringFilter<"Chat"> | string
    isDefaultSubgroup?: BoolNullableFilter<"Chat"> | boolean | null
    isParentGroup?: BoolNullableFilter<"Chat"> | boolean | null
    lastMsgTimestamp?: BigIntNullableFilter<"Chat"> | bigint | number | null
    lidJid?: StringNullableFilter<"Chat"> | string | null
    markedAsUnread?: BoolNullableFilter<"Chat"> | boolean | null
    mediaVisibility?: IntNullableFilter<"Chat"> | number | null
    messages?: JsonNullableFilter<"Chat">
    muteEndTime?: BigIntNullableFilter<"Chat"> | bigint | number | null
    name?: StringNullableFilter<"Chat"> | string | null
    newJid?: StringNullableFilter<"Chat"> | string | null
    notSpam?: BoolNullableFilter<"Chat"> | boolean | null
    oldJid?: StringNullableFilter<"Chat"> | string | null
    pHash?: StringNullableFilter<"Chat"> | string | null
    parentGroupId?: StringNullableFilter<"Chat"> | string | null
    participant?: JsonNullableFilter<"Chat">
    pinned?: BigIntNullableFilter<"Chat"> | bigint | number | null
    pnJid?: StringNullableFilter<"Chat"> | string | null
    pnhDuplicateLidThread?: BoolNullableFilter<"Chat"> | boolean | null
    readOnly?: BoolNullableFilter<"Chat"> | boolean | null
    shareOwnPn?: BoolNullableFilter<"Chat"> | boolean | null
    support?: BoolNullableFilter<"Chat"> | boolean | null
    suspended?: BoolNullableFilter<"Chat"> | boolean | null
    tcToken?: BytesNullableFilter<"Chat"> | Uint8Array | null
    tcTokenSenderTimestamp?: BigIntNullableFilter<"Chat"> | bigint | number | null
    tcTokenTimestamp?: BigIntNullableFilter<"Chat"> | bigint | number | null
    terminated?: BoolNullableFilter<"Chat"> | boolean | null
    unreadCount?: IntNullableFilter<"Chat"> | number | null
    unreadMentionCount?: IntNullableFilter<"Chat"> | number | null
    wallpaper?: JsonNullableFilter<"Chat">
    lastMessageRecvTimestamp?: IntNullableFilter<"Chat"> | number | null
    commentsCount?: IntNullableFilter<"Chat"> | number | null
    picture?: StringNullableFilter<"Chat"> | string | null
    auto_reply_enabled?: BoolNullableFilter<"Chat"> | boolean | null
    badge_id?: IntNullableFilter<"Chat"> | number | null
  }

  export type ChatOrderByWithRelationInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    archived?: SortOrderInput | SortOrder
    contactPrimaryIdentityKey?: SortOrderInput | SortOrder
    conversationTimestamp?: SortOrderInput | SortOrder
    createdAt?: SortOrderInput | SortOrder
    createdBy?: SortOrderInput | SortOrder
    description?: SortOrderInput | SortOrder
    disappearingMode?: SortOrderInput | SortOrder
    displayName?: SortOrderInput | SortOrder
    endOfHistoryTransfer?: SortOrderInput | SortOrder
    endOfHistoryTransferType?: SortOrderInput | SortOrder
    ephemeralExpiration?: SortOrderInput | SortOrder
    ephemeralSettingTimestamp?: SortOrderInput | SortOrder
    id?: SortOrder
    isDefaultSubgroup?: SortOrderInput | SortOrder
    isParentGroup?: SortOrderInput | SortOrder
    lastMsgTimestamp?: SortOrderInput | SortOrder
    lidJid?: SortOrderInput | SortOrder
    markedAsUnread?: SortOrderInput | SortOrder
    mediaVisibility?: SortOrderInput | SortOrder
    messages?: SortOrderInput | SortOrder
    muteEndTime?: SortOrderInput | SortOrder
    name?: SortOrderInput | SortOrder
    newJid?: SortOrderInput | SortOrder
    notSpam?: SortOrderInput | SortOrder
    oldJid?: SortOrderInput | SortOrder
    pHash?: SortOrderInput | SortOrder
    parentGroupId?: SortOrderInput | SortOrder
    participant?: SortOrderInput | SortOrder
    pinned?: SortOrderInput | SortOrder
    pnJid?: SortOrderInput | SortOrder
    pnhDuplicateLidThread?: SortOrderInput | SortOrder
    readOnly?: SortOrderInput | SortOrder
    shareOwnPn?: SortOrderInput | SortOrder
    support?: SortOrderInput | SortOrder
    suspended?: SortOrderInput | SortOrder
    tcToken?: SortOrderInput | SortOrder
    tcTokenSenderTimestamp?: SortOrderInput | SortOrder
    tcTokenTimestamp?: SortOrderInput | SortOrder
    terminated?: SortOrderInput | SortOrder
    unreadCount?: SortOrderInput | SortOrder
    unreadMentionCount?: SortOrderInput | SortOrder
    wallpaper?: SortOrderInput | SortOrder
    lastMessageRecvTimestamp?: SortOrderInput | SortOrder
    commentsCount?: SortOrderInput | SortOrder
    picture?: SortOrderInput | SortOrder
    auto_reply_enabled?: SortOrderInput | SortOrder
    badge_id?: SortOrderInput | SortOrder
    _relevance?: ChatOrderByRelevanceInput
  }

  export type ChatWhereUniqueInput = Prisma.AtLeast<{
    pkId?: number
    sessionId_id?: ChatSessionIdIdCompoundUniqueInput
    AND?: ChatWhereInput | ChatWhereInput[]
    OR?: ChatWhereInput[]
    NOT?: ChatWhereInput | ChatWhereInput[]
    sessionId?: StringFilter<"Chat"> | string
    archived?: BoolNullableFilter<"Chat"> | boolean | null
    contactPrimaryIdentityKey?: BytesNullableFilter<"Chat"> | Uint8Array | null
    conversationTimestamp?: BigIntNullableFilter<"Chat"> | bigint | number | null
    createdAt?: BigIntNullableFilter<"Chat"> | bigint | number | null
    createdBy?: StringNullableFilter<"Chat"> | string | null
    description?: StringNullableFilter<"Chat"> | string | null
    disappearingMode?: JsonNullableFilter<"Chat">
    displayName?: StringNullableFilter<"Chat"> | string | null
    endOfHistoryTransfer?: BoolNullableFilter<"Chat"> | boolean | null
    endOfHistoryTransferType?: IntNullableFilter<"Chat"> | number | null
    ephemeralExpiration?: IntNullableFilter<"Chat"> | number | null
    ephemeralSettingTimestamp?: BigIntNullableFilter<"Chat"> | bigint | number | null
    id?: StringFilter<"Chat"> | string
    isDefaultSubgroup?: BoolNullableFilter<"Chat"> | boolean | null
    isParentGroup?: BoolNullableFilter<"Chat"> | boolean | null
    lastMsgTimestamp?: BigIntNullableFilter<"Chat"> | bigint | number | null
    lidJid?: StringNullableFilter<"Chat"> | string | null
    markedAsUnread?: BoolNullableFilter<"Chat"> | boolean | null
    mediaVisibility?: IntNullableFilter<"Chat"> | number | null
    messages?: JsonNullableFilter<"Chat">
    muteEndTime?: BigIntNullableFilter<"Chat"> | bigint | number | null
    name?: StringNullableFilter<"Chat"> | string | null
    newJid?: StringNullableFilter<"Chat"> | string | null
    notSpam?: BoolNullableFilter<"Chat"> | boolean | null
    oldJid?: StringNullableFilter<"Chat"> | string | null
    pHash?: StringNullableFilter<"Chat"> | string | null
    parentGroupId?: StringNullableFilter<"Chat"> | string | null
    participant?: JsonNullableFilter<"Chat">
    pinned?: BigIntNullableFilter<"Chat"> | bigint | number | null
    pnJid?: StringNullableFilter<"Chat"> | string | null
    pnhDuplicateLidThread?: BoolNullableFilter<"Chat"> | boolean | null
    readOnly?: BoolNullableFilter<"Chat"> | boolean | null
    shareOwnPn?: BoolNullableFilter<"Chat"> | boolean | null
    support?: BoolNullableFilter<"Chat"> | boolean | null
    suspended?: BoolNullableFilter<"Chat"> | boolean | null
    tcToken?: BytesNullableFilter<"Chat"> | Uint8Array | null
    tcTokenSenderTimestamp?: BigIntNullableFilter<"Chat"> | bigint | number | null
    tcTokenTimestamp?: BigIntNullableFilter<"Chat"> | bigint | number | null
    terminated?: BoolNullableFilter<"Chat"> | boolean | null
    unreadCount?: IntNullableFilter<"Chat"> | number | null
    unreadMentionCount?: IntNullableFilter<"Chat"> | number | null
    wallpaper?: JsonNullableFilter<"Chat">
    lastMessageRecvTimestamp?: IntNullableFilter<"Chat"> | number | null
    commentsCount?: IntNullableFilter<"Chat"> | number | null
    picture?: StringNullableFilter<"Chat"> | string | null
    auto_reply_enabled?: BoolNullableFilter<"Chat"> | boolean | null
    badge_id?: IntNullableFilter<"Chat"> | number | null
  }, "pkId" | "sessionId_id">

  export type ChatOrderByWithAggregationInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    archived?: SortOrderInput | SortOrder
    contactPrimaryIdentityKey?: SortOrderInput | SortOrder
    conversationTimestamp?: SortOrderInput | SortOrder
    createdAt?: SortOrderInput | SortOrder
    createdBy?: SortOrderInput | SortOrder
    description?: SortOrderInput | SortOrder
    disappearingMode?: SortOrderInput | SortOrder
    displayName?: SortOrderInput | SortOrder
    endOfHistoryTransfer?: SortOrderInput | SortOrder
    endOfHistoryTransferType?: SortOrderInput | SortOrder
    ephemeralExpiration?: SortOrderInput | SortOrder
    ephemeralSettingTimestamp?: SortOrderInput | SortOrder
    id?: SortOrder
    isDefaultSubgroup?: SortOrderInput | SortOrder
    isParentGroup?: SortOrderInput | SortOrder
    lastMsgTimestamp?: SortOrderInput | SortOrder
    lidJid?: SortOrderInput | SortOrder
    markedAsUnread?: SortOrderInput | SortOrder
    mediaVisibility?: SortOrderInput | SortOrder
    messages?: SortOrderInput | SortOrder
    muteEndTime?: SortOrderInput | SortOrder
    name?: SortOrderInput | SortOrder
    newJid?: SortOrderInput | SortOrder
    notSpam?: SortOrderInput | SortOrder
    oldJid?: SortOrderInput | SortOrder
    pHash?: SortOrderInput | SortOrder
    parentGroupId?: SortOrderInput | SortOrder
    participant?: SortOrderInput | SortOrder
    pinned?: SortOrderInput | SortOrder
    pnJid?: SortOrderInput | SortOrder
    pnhDuplicateLidThread?: SortOrderInput | SortOrder
    readOnly?: SortOrderInput | SortOrder
    shareOwnPn?: SortOrderInput | SortOrder
    support?: SortOrderInput | SortOrder
    suspended?: SortOrderInput | SortOrder
    tcToken?: SortOrderInput | SortOrder
    tcTokenSenderTimestamp?: SortOrderInput | SortOrder
    tcTokenTimestamp?: SortOrderInput | SortOrder
    terminated?: SortOrderInput | SortOrder
    unreadCount?: SortOrderInput | SortOrder
    unreadMentionCount?: SortOrderInput | SortOrder
    wallpaper?: SortOrderInput | SortOrder
    lastMessageRecvTimestamp?: SortOrderInput | SortOrder
    commentsCount?: SortOrderInput | SortOrder
    picture?: SortOrderInput | SortOrder
    auto_reply_enabled?: SortOrderInput | SortOrder
    badge_id?: SortOrderInput | SortOrder
    _count?: ChatCountOrderByAggregateInput
    _avg?: ChatAvgOrderByAggregateInput
    _max?: ChatMaxOrderByAggregateInput
    _min?: ChatMinOrderByAggregateInput
    _sum?: ChatSumOrderByAggregateInput
  }

  export type ChatScalarWhereWithAggregatesInput = {
    AND?: ChatScalarWhereWithAggregatesInput | ChatScalarWhereWithAggregatesInput[]
    OR?: ChatScalarWhereWithAggregatesInput[]
    NOT?: ChatScalarWhereWithAggregatesInput | ChatScalarWhereWithAggregatesInput[]
    pkId?: IntWithAggregatesFilter<"Chat"> | number
    sessionId?: StringWithAggregatesFilter<"Chat"> | string
    archived?: BoolNullableWithAggregatesFilter<"Chat"> | boolean | null
    contactPrimaryIdentityKey?: BytesNullableWithAggregatesFilter<"Chat"> | Uint8Array | null
    conversationTimestamp?: BigIntNullableWithAggregatesFilter<"Chat"> | bigint | number | null
    createdAt?: BigIntNullableWithAggregatesFilter<"Chat"> | bigint | number | null
    createdBy?: StringNullableWithAggregatesFilter<"Chat"> | string | null
    description?: StringNullableWithAggregatesFilter<"Chat"> | string | null
    disappearingMode?: JsonNullableWithAggregatesFilter<"Chat">
    displayName?: StringNullableWithAggregatesFilter<"Chat"> | string | null
    endOfHistoryTransfer?: BoolNullableWithAggregatesFilter<"Chat"> | boolean | null
    endOfHistoryTransferType?: IntNullableWithAggregatesFilter<"Chat"> | number | null
    ephemeralExpiration?: IntNullableWithAggregatesFilter<"Chat"> | number | null
    ephemeralSettingTimestamp?: BigIntNullableWithAggregatesFilter<"Chat"> | bigint | number | null
    id?: StringWithAggregatesFilter<"Chat"> | string
    isDefaultSubgroup?: BoolNullableWithAggregatesFilter<"Chat"> | boolean | null
    isParentGroup?: BoolNullableWithAggregatesFilter<"Chat"> | boolean | null
    lastMsgTimestamp?: BigIntNullableWithAggregatesFilter<"Chat"> | bigint | number | null
    lidJid?: StringNullableWithAggregatesFilter<"Chat"> | string | null
    markedAsUnread?: BoolNullableWithAggregatesFilter<"Chat"> | boolean | null
    mediaVisibility?: IntNullableWithAggregatesFilter<"Chat"> | number | null
    messages?: JsonNullableWithAggregatesFilter<"Chat">
    muteEndTime?: BigIntNullableWithAggregatesFilter<"Chat"> | bigint | number | null
    name?: StringNullableWithAggregatesFilter<"Chat"> | string | null
    newJid?: StringNullableWithAggregatesFilter<"Chat"> | string | null
    notSpam?: BoolNullableWithAggregatesFilter<"Chat"> | boolean | null
    oldJid?: StringNullableWithAggregatesFilter<"Chat"> | string | null
    pHash?: StringNullableWithAggregatesFilter<"Chat"> | string | null
    parentGroupId?: StringNullableWithAggregatesFilter<"Chat"> | string | null
    participant?: JsonNullableWithAggregatesFilter<"Chat">
    pinned?: BigIntNullableWithAggregatesFilter<"Chat"> | bigint | number | null
    pnJid?: StringNullableWithAggregatesFilter<"Chat"> | string | null
    pnhDuplicateLidThread?: BoolNullableWithAggregatesFilter<"Chat"> | boolean | null
    readOnly?: BoolNullableWithAggregatesFilter<"Chat"> | boolean | null
    shareOwnPn?: BoolNullableWithAggregatesFilter<"Chat"> | boolean | null
    support?: BoolNullableWithAggregatesFilter<"Chat"> | boolean | null
    suspended?: BoolNullableWithAggregatesFilter<"Chat"> | boolean | null
    tcToken?: BytesNullableWithAggregatesFilter<"Chat"> | Uint8Array | null
    tcTokenSenderTimestamp?: BigIntNullableWithAggregatesFilter<"Chat"> | bigint | number | null
    tcTokenTimestamp?: BigIntNullableWithAggregatesFilter<"Chat"> | bigint | number | null
    terminated?: BoolNullableWithAggregatesFilter<"Chat"> | boolean | null
    unreadCount?: IntNullableWithAggregatesFilter<"Chat"> | number | null
    unreadMentionCount?: IntNullableWithAggregatesFilter<"Chat"> | number | null
    wallpaper?: JsonNullableWithAggregatesFilter<"Chat">
    lastMessageRecvTimestamp?: IntNullableWithAggregatesFilter<"Chat"> | number | null
    commentsCount?: IntNullableWithAggregatesFilter<"Chat"> | number | null
    picture?: StringNullableWithAggregatesFilter<"Chat"> | string | null
    auto_reply_enabled?: BoolNullableWithAggregatesFilter<"Chat"> | boolean | null
    badge_id?: IntNullableWithAggregatesFilter<"Chat"> | number | null
  }

  export type ContactWhereInput = {
    AND?: ContactWhereInput | ContactWhereInput[]
    OR?: ContactWhereInput[]
    NOT?: ContactWhereInput | ContactWhereInput[]
    pkId?: IntFilter<"Contact"> | number
    sessionId?: StringFilter<"Contact"> | string
    id?: StringFilter<"Contact"> | string
    name?: StringNullableFilter<"Contact"> | string | null
    notify?: StringNullableFilter<"Contact"> | string | null
    verifiedName?: StringNullableFilter<"Contact"> | string | null
    imgUrl?: StringNullableFilter<"Contact"> | string | null
    status?: StringNullableFilter<"Contact"> | string | null
  }

  export type ContactOrderByWithRelationInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    id?: SortOrder
    name?: SortOrderInput | SortOrder
    notify?: SortOrderInput | SortOrder
    verifiedName?: SortOrderInput | SortOrder
    imgUrl?: SortOrderInput | SortOrder
    status?: SortOrderInput | SortOrder
    _relevance?: ContactOrderByRelevanceInput
  }

  export type ContactWhereUniqueInput = Prisma.AtLeast<{
    pkId?: number
    sessionId_id?: ContactSessionIdIdCompoundUniqueInput
    AND?: ContactWhereInput | ContactWhereInput[]
    OR?: ContactWhereInput[]
    NOT?: ContactWhereInput | ContactWhereInput[]
    sessionId?: StringFilter<"Contact"> | string
    id?: StringFilter<"Contact"> | string
    name?: StringNullableFilter<"Contact"> | string | null
    notify?: StringNullableFilter<"Contact"> | string | null
    verifiedName?: StringNullableFilter<"Contact"> | string | null
    imgUrl?: StringNullableFilter<"Contact"> | string | null
    status?: StringNullableFilter<"Contact"> | string | null
  }, "pkId" | "sessionId_id">

  export type ContactOrderByWithAggregationInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    id?: SortOrder
    name?: SortOrderInput | SortOrder
    notify?: SortOrderInput | SortOrder
    verifiedName?: SortOrderInput | SortOrder
    imgUrl?: SortOrderInput | SortOrder
    status?: SortOrderInput | SortOrder
    _count?: ContactCountOrderByAggregateInput
    _avg?: ContactAvgOrderByAggregateInput
    _max?: ContactMaxOrderByAggregateInput
    _min?: ContactMinOrderByAggregateInput
    _sum?: ContactSumOrderByAggregateInput
  }

  export type ContactScalarWhereWithAggregatesInput = {
    AND?: ContactScalarWhereWithAggregatesInput | ContactScalarWhereWithAggregatesInput[]
    OR?: ContactScalarWhereWithAggregatesInput[]
    NOT?: ContactScalarWhereWithAggregatesInput | ContactScalarWhereWithAggregatesInput[]
    pkId?: IntWithAggregatesFilter<"Contact"> | number
    sessionId?: StringWithAggregatesFilter<"Contact"> | string
    id?: StringWithAggregatesFilter<"Contact"> | string
    name?: StringNullableWithAggregatesFilter<"Contact"> | string | null
    notify?: StringNullableWithAggregatesFilter<"Contact"> | string | null
    verifiedName?: StringNullableWithAggregatesFilter<"Contact"> | string | null
    imgUrl?: StringNullableWithAggregatesFilter<"Contact"> | string | null
    status?: StringNullableWithAggregatesFilter<"Contact"> | string | null
  }

  export type GroupMetadataWhereInput = {
    AND?: GroupMetadataWhereInput | GroupMetadataWhereInput[]
    OR?: GroupMetadataWhereInput[]
    NOT?: GroupMetadataWhereInput | GroupMetadataWhereInput[]
    pkId?: IntFilter<"GroupMetadata"> | number
    sessionId?: StringFilter<"GroupMetadata"> | string
    id?: StringFilter<"GroupMetadata"> | string
    owner?: StringNullableFilter<"GroupMetadata"> | string | null
    subject?: StringFilter<"GroupMetadata"> | string
    subjectOwner?: StringNullableFilter<"GroupMetadata"> | string | null
    subjectTime?: IntNullableFilter<"GroupMetadata"> | number | null
    creation?: IntNullableFilter<"GroupMetadata"> | number | null
    desc?: StringNullableFilter<"GroupMetadata"> | string | null
    descOwner?: StringNullableFilter<"GroupMetadata"> | string | null
    descId?: StringNullableFilter<"GroupMetadata"> | string | null
    restrict?: BoolNullableFilter<"GroupMetadata"> | boolean | null
    announce?: BoolNullableFilter<"GroupMetadata"> | boolean | null
    isCommunity?: BoolNullableFilter<"GroupMetadata"> | boolean | null
    isCommunityAnnounce?: BoolNullableFilter<"GroupMetadata"> | boolean | null
    joinApprovalMode?: BoolNullableFilter<"GroupMetadata"> | boolean | null
    memberAddMode?: BoolNullableFilter<"GroupMetadata"> | boolean | null
    author?: StringNullableFilter<"GroupMetadata"> | string | null
    size?: IntNullableFilter<"GroupMetadata"> | number | null
    participants?: JsonFilter<"GroupMetadata">
    ephemeralDuration?: IntNullableFilter<"GroupMetadata"> | number | null
    inviteCode?: StringNullableFilter<"GroupMetadata"> | string | null
  }

  export type GroupMetadataOrderByWithRelationInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    id?: SortOrder
    owner?: SortOrderInput | SortOrder
    subject?: SortOrder
    subjectOwner?: SortOrderInput | SortOrder
    subjectTime?: SortOrderInput | SortOrder
    creation?: SortOrderInput | SortOrder
    desc?: SortOrderInput | SortOrder
    descOwner?: SortOrderInput | SortOrder
    descId?: SortOrderInput | SortOrder
    restrict?: SortOrderInput | SortOrder
    announce?: SortOrderInput | SortOrder
    isCommunity?: SortOrderInput | SortOrder
    isCommunityAnnounce?: SortOrderInput | SortOrder
    joinApprovalMode?: SortOrderInput | SortOrder
    memberAddMode?: SortOrderInput | SortOrder
    author?: SortOrderInput | SortOrder
    size?: SortOrderInput | SortOrder
    participants?: SortOrder
    ephemeralDuration?: SortOrderInput | SortOrder
    inviteCode?: SortOrderInput | SortOrder
    _relevance?: GroupMetadataOrderByRelevanceInput
  }

  export type GroupMetadataWhereUniqueInput = Prisma.AtLeast<{
    pkId?: number
    sessionId_id?: GroupMetadataSessionIdIdCompoundUniqueInput
    AND?: GroupMetadataWhereInput | GroupMetadataWhereInput[]
    OR?: GroupMetadataWhereInput[]
    NOT?: GroupMetadataWhereInput | GroupMetadataWhereInput[]
    sessionId?: StringFilter<"GroupMetadata"> | string
    id?: StringFilter<"GroupMetadata"> | string
    owner?: StringNullableFilter<"GroupMetadata"> | string | null
    subject?: StringFilter<"GroupMetadata"> | string
    subjectOwner?: StringNullableFilter<"GroupMetadata"> | string | null
    subjectTime?: IntNullableFilter<"GroupMetadata"> | number | null
    creation?: IntNullableFilter<"GroupMetadata"> | number | null
    desc?: StringNullableFilter<"GroupMetadata"> | string | null
    descOwner?: StringNullableFilter<"GroupMetadata"> | string | null
    descId?: StringNullableFilter<"GroupMetadata"> | string | null
    restrict?: BoolNullableFilter<"GroupMetadata"> | boolean | null
    announce?: BoolNullableFilter<"GroupMetadata"> | boolean | null
    isCommunity?: BoolNullableFilter<"GroupMetadata"> | boolean | null
    isCommunityAnnounce?: BoolNullableFilter<"GroupMetadata"> | boolean | null
    joinApprovalMode?: BoolNullableFilter<"GroupMetadata"> | boolean | null
    memberAddMode?: BoolNullableFilter<"GroupMetadata"> | boolean | null
    author?: StringNullableFilter<"GroupMetadata"> | string | null
    size?: IntNullableFilter<"GroupMetadata"> | number | null
    participants?: JsonFilter<"GroupMetadata">
    ephemeralDuration?: IntNullableFilter<"GroupMetadata"> | number | null
    inviteCode?: StringNullableFilter<"GroupMetadata"> | string | null
  }, "pkId" | "sessionId_id">

  export type GroupMetadataOrderByWithAggregationInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    id?: SortOrder
    owner?: SortOrderInput | SortOrder
    subject?: SortOrder
    subjectOwner?: SortOrderInput | SortOrder
    subjectTime?: SortOrderInput | SortOrder
    creation?: SortOrderInput | SortOrder
    desc?: SortOrderInput | SortOrder
    descOwner?: SortOrderInput | SortOrder
    descId?: SortOrderInput | SortOrder
    restrict?: SortOrderInput | SortOrder
    announce?: SortOrderInput | SortOrder
    isCommunity?: SortOrderInput | SortOrder
    isCommunityAnnounce?: SortOrderInput | SortOrder
    joinApprovalMode?: SortOrderInput | SortOrder
    memberAddMode?: SortOrderInput | SortOrder
    author?: SortOrderInput | SortOrder
    size?: SortOrderInput | SortOrder
    participants?: SortOrder
    ephemeralDuration?: SortOrderInput | SortOrder
    inviteCode?: SortOrderInput | SortOrder
    _count?: GroupMetadataCountOrderByAggregateInput
    _avg?: GroupMetadataAvgOrderByAggregateInput
    _max?: GroupMetadataMaxOrderByAggregateInput
    _min?: GroupMetadataMinOrderByAggregateInput
    _sum?: GroupMetadataSumOrderByAggregateInput
  }

  export type GroupMetadataScalarWhereWithAggregatesInput = {
    AND?: GroupMetadataScalarWhereWithAggregatesInput | GroupMetadataScalarWhereWithAggregatesInput[]
    OR?: GroupMetadataScalarWhereWithAggregatesInput[]
    NOT?: GroupMetadataScalarWhereWithAggregatesInput | GroupMetadataScalarWhereWithAggregatesInput[]
    pkId?: IntWithAggregatesFilter<"GroupMetadata"> | number
    sessionId?: StringWithAggregatesFilter<"GroupMetadata"> | string
    id?: StringWithAggregatesFilter<"GroupMetadata"> | string
    owner?: StringNullableWithAggregatesFilter<"GroupMetadata"> | string | null
    subject?: StringWithAggregatesFilter<"GroupMetadata"> | string
    subjectOwner?: StringNullableWithAggregatesFilter<"GroupMetadata"> | string | null
    subjectTime?: IntNullableWithAggregatesFilter<"GroupMetadata"> | number | null
    creation?: IntNullableWithAggregatesFilter<"GroupMetadata"> | number | null
    desc?: StringNullableWithAggregatesFilter<"GroupMetadata"> | string | null
    descOwner?: StringNullableWithAggregatesFilter<"GroupMetadata"> | string | null
    descId?: StringNullableWithAggregatesFilter<"GroupMetadata"> | string | null
    restrict?: BoolNullableWithAggregatesFilter<"GroupMetadata"> | boolean | null
    announce?: BoolNullableWithAggregatesFilter<"GroupMetadata"> | boolean | null
    isCommunity?: BoolNullableWithAggregatesFilter<"GroupMetadata"> | boolean | null
    isCommunityAnnounce?: BoolNullableWithAggregatesFilter<"GroupMetadata"> | boolean | null
    joinApprovalMode?: BoolNullableWithAggregatesFilter<"GroupMetadata"> | boolean | null
    memberAddMode?: BoolNullableWithAggregatesFilter<"GroupMetadata"> | boolean | null
    author?: StringNullableWithAggregatesFilter<"GroupMetadata"> | string | null
    size?: IntNullableWithAggregatesFilter<"GroupMetadata"> | number | null
    participants?: JsonWithAggregatesFilter<"GroupMetadata">
    ephemeralDuration?: IntNullableWithAggregatesFilter<"GroupMetadata"> | number | null
    inviteCode?: StringNullableWithAggregatesFilter<"GroupMetadata"> | string | null
  }

  export type MessageWhereInput = {
    AND?: MessageWhereInput | MessageWhereInput[]
    OR?: MessageWhereInput[]
    NOT?: MessageWhereInput | MessageWhereInput[]
    pkId?: IntFilter<"Message"> | number
    sessionId?: StringFilter<"Message"> | string
    remoteJid?: StringFilter<"Message"> | string
    id?: StringFilter<"Message"> | string
    agentId?: StringNullableFilter<"Message"> | string | null
    bizPrivacyStatus?: IntNullableFilter<"Message"> | number | null
    broadcast?: BoolNullableFilter<"Message"> | boolean | null
    clearMedia?: BoolNullableFilter<"Message"> | boolean | null
    duration?: IntNullableFilter<"Message"> | number | null
    ephemeralDuration?: IntNullableFilter<"Message"> | number | null
    ephemeralOffToOn?: BoolNullableFilter<"Message"> | boolean | null
    ephemeralOutOfSync?: BoolNullableFilter<"Message"> | boolean | null
    ephemeralStartTimestamp?: BigIntNullableFilter<"Message"> | bigint | number | null
    finalLiveLocation?: JsonNullableFilter<"Message">
    futureproofData?: BytesNullableFilter<"Message"> | Uint8Array | null
    ignore?: BoolNullableFilter<"Message"> | boolean | null
    keepInChat?: JsonNullableFilter<"Message">
    key?: JsonFilter<"Message">
    labels?: JsonNullableFilter<"Message">
    mediaCiphertextSha256?: BytesNullableFilter<"Message"> | Uint8Array | null
    mediaData?: JsonNullableFilter<"Message">
    message?: JsonNullableFilter<"Message">
    messageC2STimestamp?: BigIntNullableFilter<"Message"> | bigint | number | null
    messageSecret?: BytesNullableFilter<"Message"> | Uint8Array | null
    messageStubParameters?: JsonNullableFilter<"Message">
    messageStubType?: IntNullableFilter<"Message"> | number | null
    messageTimestamp?: BigIntNullableFilter<"Message"> | bigint | number | null
    multicast?: BoolNullableFilter<"Message"> | boolean | null
    originalSelfAuthorUserJidString?: StringNullableFilter<"Message"> | string | null
    participant?: StringNullableFilter<"Message"> | string | null
    paymentInfo?: JsonNullableFilter<"Message">
    photoChange?: JsonNullableFilter<"Message">
    pollAdditionalMetadata?: JsonNullableFilter<"Message">
    pollUpdates?: JsonNullableFilter<"Message">
    pushName?: StringNullableFilter<"Message"> | string | null
    quotedPaymentInfo?: JsonNullableFilter<"Message">
    quotedStickerData?: JsonNullableFilter<"Message">
    reactions?: JsonNullableFilter<"Message">
    revokeMessageTimestamp?: BigIntNullableFilter<"Message"> | bigint | number | null
    starred?: BoolNullableFilter<"Message"> | boolean | null
    status?: IntNullableFilter<"Message"> | number | null
    statusAlreadyViewed?: BoolNullableFilter<"Message"> | boolean | null
    statusPsa?: JsonNullableFilter<"Message">
    urlNumber?: BoolNullableFilter<"Message"> | boolean | null
    urlText?: BoolNullableFilter<"Message"> | boolean | null
    userReceipt?: JsonNullableFilter<"Message">
    verifiedBizName?: StringNullableFilter<"Message"> | string | null
    eventResponses?: JsonNullableFilter<"Message">
    pinInChat?: JsonNullableFilter<"Message">
    reportingTokenInfo?: JsonNullableFilter<"Message">
  }

  export type MessageOrderByWithRelationInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    remoteJid?: SortOrder
    id?: SortOrder
    agentId?: SortOrderInput | SortOrder
    bizPrivacyStatus?: SortOrderInput | SortOrder
    broadcast?: SortOrderInput | SortOrder
    clearMedia?: SortOrderInput | SortOrder
    duration?: SortOrderInput | SortOrder
    ephemeralDuration?: SortOrderInput | SortOrder
    ephemeralOffToOn?: SortOrderInput | SortOrder
    ephemeralOutOfSync?: SortOrderInput | SortOrder
    ephemeralStartTimestamp?: SortOrderInput | SortOrder
    finalLiveLocation?: SortOrderInput | SortOrder
    futureproofData?: SortOrderInput | SortOrder
    ignore?: SortOrderInput | SortOrder
    keepInChat?: SortOrderInput | SortOrder
    key?: SortOrder
    labels?: SortOrderInput | SortOrder
    mediaCiphertextSha256?: SortOrderInput | SortOrder
    mediaData?: SortOrderInput | SortOrder
    message?: SortOrderInput | SortOrder
    messageC2STimestamp?: SortOrderInput | SortOrder
    messageSecret?: SortOrderInput | SortOrder
    messageStubParameters?: SortOrderInput | SortOrder
    messageStubType?: SortOrderInput | SortOrder
    messageTimestamp?: SortOrderInput | SortOrder
    multicast?: SortOrderInput | SortOrder
    originalSelfAuthorUserJidString?: SortOrderInput | SortOrder
    participant?: SortOrderInput | SortOrder
    paymentInfo?: SortOrderInput | SortOrder
    photoChange?: SortOrderInput | SortOrder
    pollAdditionalMetadata?: SortOrderInput | SortOrder
    pollUpdates?: SortOrderInput | SortOrder
    pushName?: SortOrderInput | SortOrder
    quotedPaymentInfo?: SortOrderInput | SortOrder
    quotedStickerData?: SortOrderInput | SortOrder
    reactions?: SortOrderInput | SortOrder
    revokeMessageTimestamp?: SortOrderInput | SortOrder
    starred?: SortOrderInput | SortOrder
    status?: SortOrderInput | SortOrder
    statusAlreadyViewed?: SortOrderInput | SortOrder
    statusPsa?: SortOrderInput | SortOrder
    urlNumber?: SortOrderInput | SortOrder
    urlText?: SortOrderInput | SortOrder
    userReceipt?: SortOrderInput | SortOrder
    verifiedBizName?: SortOrderInput | SortOrder
    eventResponses?: SortOrderInput | SortOrder
    pinInChat?: SortOrderInput | SortOrder
    reportingTokenInfo?: SortOrderInput | SortOrder
    _relevance?: MessageOrderByRelevanceInput
  }

  export type MessageWhereUniqueInput = Prisma.AtLeast<{
    pkId?: number
    sessionId_remoteJid_id?: MessageSessionIdRemoteJidIdCompoundUniqueInput
    AND?: MessageWhereInput | MessageWhereInput[]
    OR?: MessageWhereInput[]
    NOT?: MessageWhereInput | MessageWhereInput[]
    sessionId?: StringFilter<"Message"> | string
    remoteJid?: StringFilter<"Message"> | string
    id?: StringFilter<"Message"> | string
    agentId?: StringNullableFilter<"Message"> | string | null
    bizPrivacyStatus?: IntNullableFilter<"Message"> | number | null
    broadcast?: BoolNullableFilter<"Message"> | boolean | null
    clearMedia?: BoolNullableFilter<"Message"> | boolean | null
    duration?: IntNullableFilter<"Message"> | number | null
    ephemeralDuration?: IntNullableFilter<"Message"> | number | null
    ephemeralOffToOn?: BoolNullableFilter<"Message"> | boolean | null
    ephemeralOutOfSync?: BoolNullableFilter<"Message"> | boolean | null
    ephemeralStartTimestamp?: BigIntNullableFilter<"Message"> | bigint | number | null
    finalLiveLocation?: JsonNullableFilter<"Message">
    futureproofData?: BytesNullableFilter<"Message"> | Uint8Array | null
    ignore?: BoolNullableFilter<"Message"> | boolean | null
    keepInChat?: JsonNullableFilter<"Message">
    key?: JsonFilter<"Message">
    labels?: JsonNullableFilter<"Message">
    mediaCiphertextSha256?: BytesNullableFilter<"Message"> | Uint8Array | null
    mediaData?: JsonNullableFilter<"Message">
    message?: JsonNullableFilter<"Message">
    messageC2STimestamp?: BigIntNullableFilter<"Message"> | bigint | number | null
    messageSecret?: BytesNullableFilter<"Message"> | Uint8Array | null
    messageStubParameters?: JsonNullableFilter<"Message">
    messageStubType?: IntNullableFilter<"Message"> | number | null
    messageTimestamp?: BigIntNullableFilter<"Message"> | bigint | number | null
    multicast?: BoolNullableFilter<"Message"> | boolean | null
    originalSelfAuthorUserJidString?: StringNullableFilter<"Message"> | string | null
    participant?: StringNullableFilter<"Message"> | string | null
    paymentInfo?: JsonNullableFilter<"Message">
    photoChange?: JsonNullableFilter<"Message">
    pollAdditionalMetadata?: JsonNullableFilter<"Message">
    pollUpdates?: JsonNullableFilter<"Message">
    pushName?: StringNullableFilter<"Message"> | string | null
    quotedPaymentInfo?: JsonNullableFilter<"Message">
    quotedStickerData?: JsonNullableFilter<"Message">
    reactions?: JsonNullableFilter<"Message">
    revokeMessageTimestamp?: BigIntNullableFilter<"Message"> | bigint | number | null
    starred?: BoolNullableFilter<"Message"> | boolean | null
    status?: IntNullableFilter<"Message"> | number | null
    statusAlreadyViewed?: BoolNullableFilter<"Message"> | boolean | null
    statusPsa?: JsonNullableFilter<"Message">
    urlNumber?: BoolNullableFilter<"Message"> | boolean | null
    urlText?: BoolNullableFilter<"Message"> | boolean | null
    userReceipt?: JsonNullableFilter<"Message">
    verifiedBizName?: StringNullableFilter<"Message"> | string | null
    eventResponses?: JsonNullableFilter<"Message">
    pinInChat?: JsonNullableFilter<"Message">
    reportingTokenInfo?: JsonNullableFilter<"Message">
  }, "pkId" | "sessionId_remoteJid_id">

  export type MessageOrderByWithAggregationInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    remoteJid?: SortOrder
    id?: SortOrder
    agentId?: SortOrderInput | SortOrder
    bizPrivacyStatus?: SortOrderInput | SortOrder
    broadcast?: SortOrderInput | SortOrder
    clearMedia?: SortOrderInput | SortOrder
    duration?: SortOrderInput | SortOrder
    ephemeralDuration?: SortOrderInput | SortOrder
    ephemeralOffToOn?: SortOrderInput | SortOrder
    ephemeralOutOfSync?: SortOrderInput | SortOrder
    ephemeralStartTimestamp?: SortOrderInput | SortOrder
    finalLiveLocation?: SortOrderInput | SortOrder
    futureproofData?: SortOrderInput | SortOrder
    ignore?: SortOrderInput | SortOrder
    keepInChat?: SortOrderInput | SortOrder
    key?: SortOrder
    labels?: SortOrderInput | SortOrder
    mediaCiphertextSha256?: SortOrderInput | SortOrder
    mediaData?: SortOrderInput | SortOrder
    message?: SortOrderInput | SortOrder
    messageC2STimestamp?: SortOrderInput | SortOrder
    messageSecret?: SortOrderInput | SortOrder
    messageStubParameters?: SortOrderInput | SortOrder
    messageStubType?: SortOrderInput | SortOrder
    messageTimestamp?: SortOrderInput | SortOrder
    multicast?: SortOrderInput | SortOrder
    originalSelfAuthorUserJidString?: SortOrderInput | SortOrder
    participant?: SortOrderInput | SortOrder
    paymentInfo?: SortOrderInput | SortOrder
    photoChange?: SortOrderInput | SortOrder
    pollAdditionalMetadata?: SortOrderInput | SortOrder
    pollUpdates?: SortOrderInput | SortOrder
    pushName?: SortOrderInput | SortOrder
    quotedPaymentInfo?: SortOrderInput | SortOrder
    quotedStickerData?: SortOrderInput | SortOrder
    reactions?: SortOrderInput | SortOrder
    revokeMessageTimestamp?: SortOrderInput | SortOrder
    starred?: SortOrderInput | SortOrder
    status?: SortOrderInput | SortOrder
    statusAlreadyViewed?: SortOrderInput | SortOrder
    statusPsa?: SortOrderInput | SortOrder
    urlNumber?: SortOrderInput | SortOrder
    urlText?: SortOrderInput | SortOrder
    userReceipt?: SortOrderInput | SortOrder
    verifiedBizName?: SortOrderInput | SortOrder
    eventResponses?: SortOrderInput | SortOrder
    pinInChat?: SortOrderInput | SortOrder
    reportingTokenInfo?: SortOrderInput | SortOrder
    _count?: MessageCountOrderByAggregateInput
    _avg?: MessageAvgOrderByAggregateInput
    _max?: MessageMaxOrderByAggregateInput
    _min?: MessageMinOrderByAggregateInput
    _sum?: MessageSumOrderByAggregateInput
  }

  export type MessageScalarWhereWithAggregatesInput = {
    AND?: MessageScalarWhereWithAggregatesInput | MessageScalarWhereWithAggregatesInput[]
    OR?: MessageScalarWhereWithAggregatesInput[]
    NOT?: MessageScalarWhereWithAggregatesInput | MessageScalarWhereWithAggregatesInput[]
    pkId?: IntWithAggregatesFilter<"Message"> | number
    sessionId?: StringWithAggregatesFilter<"Message"> | string
    remoteJid?: StringWithAggregatesFilter<"Message"> | string
    id?: StringWithAggregatesFilter<"Message"> | string
    agentId?: StringNullableWithAggregatesFilter<"Message"> | string | null
    bizPrivacyStatus?: IntNullableWithAggregatesFilter<"Message"> | number | null
    broadcast?: BoolNullableWithAggregatesFilter<"Message"> | boolean | null
    clearMedia?: BoolNullableWithAggregatesFilter<"Message"> | boolean | null
    duration?: IntNullableWithAggregatesFilter<"Message"> | number | null
    ephemeralDuration?: IntNullableWithAggregatesFilter<"Message"> | number | null
    ephemeralOffToOn?: BoolNullableWithAggregatesFilter<"Message"> | boolean | null
    ephemeralOutOfSync?: BoolNullableWithAggregatesFilter<"Message"> | boolean | null
    ephemeralStartTimestamp?: BigIntNullableWithAggregatesFilter<"Message"> | bigint | number | null
    finalLiveLocation?: JsonNullableWithAggregatesFilter<"Message">
    futureproofData?: BytesNullableWithAggregatesFilter<"Message"> | Uint8Array | null
    ignore?: BoolNullableWithAggregatesFilter<"Message"> | boolean | null
    keepInChat?: JsonNullableWithAggregatesFilter<"Message">
    key?: JsonWithAggregatesFilter<"Message">
    labels?: JsonNullableWithAggregatesFilter<"Message">
    mediaCiphertextSha256?: BytesNullableWithAggregatesFilter<"Message"> | Uint8Array | null
    mediaData?: JsonNullableWithAggregatesFilter<"Message">
    message?: JsonNullableWithAggregatesFilter<"Message">
    messageC2STimestamp?: BigIntNullableWithAggregatesFilter<"Message"> | bigint | number | null
    messageSecret?: BytesNullableWithAggregatesFilter<"Message"> | Uint8Array | null
    messageStubParameters?: JsonNullableWithAggregatesFilter<"Message">
    messageStubType?: IntNullableWithAggregatesFilter<"Message"> | number | null
    messageTimestamp?: BigIntNullableWithAggregatesFilter<"Message"> | bigint | number | null
    multicast?: BoolNullableWithAggregatesFilter<"Message"> | boolean | null
    originalSelfAuthorUserJidString?: StringNullableWithAggregatesFilter<"Message"> | string | null
    participant?: StringNullableWithAggregatesFilter<"Message"> | string | null
    paymentInfo?: JsonNullableWithAggregatesFilter<"Message">
    photoChange?: JsonNullableWithAggregatesFilter<"Message">
    pollAdditionalMetadata?: JsonNullableWithAggregatesFilter<"Message">
    pollUpdates?: JsonNullableWithAggregatesFilter<"Message">
    pushName?: StringNullableWithAggregatesFilter<"Message"> | string | null
    quotedPaymentInfo?: JsonNullableWithAggregatesFilter<"Message">
    quotedStickerData?: JsonNullableWithAggregatesFilter<"Message">
    reactions?: JsonNullableWithAggregatesFilter<"Message">
    revokeMessageTimestamp?: BigIntNullableWithAggregatesFilter<"Message"> | bigint | number | null
    starred?: BoolNullableWithAggregatesFilter<"Message"> | boolean | null
    status?: IntNullableWithAggregatesFilter<"Message"> | number | null
    statusAlreadyViewed?: BoolNullableWithAggregatesFilter<"Message"> | boolean | null
    statusPsa?: JsonNullableWithAggregatesFilter<"Message">
    urlNumber?: BoolNullableWithAggregatesFilter<"Message"> | boolean | null
    urlText?: BoolNullableWithAggregatesFilter<"Message"> | boolean | null
    userReceipt?: JsonNullableWithAggregatesFilter<"Message">
    verifiedBizName?: StringNullableWithAggregatesFilter<"Message"> | string | null
    eventResponses?: JsonNullableWithAggregatesFilter<"Message">
    pinInChat?: JsonNullableWithAggregatesFilter<"Message">
    reportingTokenInfo?: JsonNullableWithAggregatesFilter<"Message">
  }

  export type SessionWhereInput = {
    AND?: SessionWhereInput | SessionWhereInput[]
    OR?: SessionWhereInput[]
    NOT?: SessionWhereInput | SessionWhereInput[]
    pkId?: IntFilter<"Session"> | number
    sessionId?: StringFilter<"Session"> | string
    id?: StringFilter<"Session"> | string
    data?: StringFilter<"Session"> | string
  }

  export type SessionOrderByWithRelationInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    id?: SortOrder
    data?: SortOrder
    _relevance?: SessionOrderByRelevanceInput
  }

  export type SessionWhereUniqueInput = Prisma.AtLeast<{
    pkId?: number
    sessionId_id?: SessionSessionIdIdCompoundUniqueInput
    AND?: SessionWhereInput | SessionWhereInput[]
    OR?: SessionWhereInput[]
    NOT?: SessionWhereInput | SessionWhereInput[]
    sessionId?: StringFilter<"Session"> | string
    id?: StringFilter<"Session"> | string
    data?: StringFilter<"Session"> | string
  }, "pkId" | "sessionId_id">

  export type SessionOrderByWithAggregationInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    id?: SortOrder
    data?: SortOrder
    _count?: SessionCountOrderByAggregateInput
    _avg?: SessionAvgOrderByAggregateInput
    _max?: SessionMaxOrderByAggregateInput
    _min?: SessionMinOrderByAggregateInput
    _sum?: SessionSumOrderByAggregateInput
  }

  export type SessionScalarWhereWithAggregatesInput = {
    AND?: SessionScalarWhereWithAggregatesInput | SessionScalarWhereWithAggregatesInput[]
    OR?: SessionScalarWhereWithAggregatesInput[]
    NOT?: SessionScalarWhereWithAggregatesInput | SessionScalarWhereWithAggregatesInput[]
    pkId?: IntWithAggregatesFilter<"Session"> | number
    sessionId?: StringWithAggregatesFilter<"Session"> | string
    id?: StringWithAggregatesFilter<"Session"> | string
    data?: StringWithAggregatesFilter<"Session"> | string
  }

  export type ChatCreateInput = {
    sessionId: string
    archived?: boolean | null
    contactPrimaryIdentityKey?: Uint8Array | null
    conversationTimestamp?: bigint | number | null
    createdAt?: bigint | number | null
    createdBy?: string | null
    description?: string | null
    disappearingMode?: NullableJsonNullValueInput | InputJsonValue
    displayName?: string | null
    endOfHistoryTransfer?: boolean | null
    endOfHistoryTransferType?: number | null
    ephemeralExpiration?: number | null
    ephemeralSettingTimestamp?: bigint | number | null
    id: string
    isDefaultSubgroup?: boolean | null
    isParentGroup?: boolean | null
    lastMsgTimestamp?: bigint | number | null
    lidJid?: string | null
    markedAsUnread?: boolean | null
    mediaVisibility?: number | null
    messages?: NullableJsonNullValueInput | InputJsonValue
    muteEndTime?: bigint | number | null
    name?: string | null
    newJid?: string | null
    notSpam?: boolean | null
    oldJid?: string | null
    pHash?: string | null
    parentGroupId?: string | null
    participant?: NullableJsonNullValueInput | InputJsonValue
    pinned?: bigint | number | null
    pnJid?: string | null
    pnhDuplicateLidThread?: boolean | null
    readOnly?: boolean | null
    shareOwnPn?: boolean | null
    support?: boolean | null
    suspended?: boolean | null
    tcToken?: Uint8Array | null
    tcTokenSenderTimestamp?: bigint | number | null
    tcTokenTimestamp?: bigint | number | null
    terminated?: boolean | null
    unreadCount?: number | null
    unreadMentionCount?: number | null
    wallpaper?: NullableJsonNullValueInput | InputJsonValue
    lastMessageRecvTimestamp?: number | null
    commentsCount?: number | null
    picture?: string | null
    auto_reply_enabled?: boolean | null
    badge_id?: number | null
  }

  export type ChatUncheckedCreateInput = {
    pkId?: number
    sessionId: string
    archived?: boolean | null
    contactPrimaryIdentityKey?: Uint8Array | null
    conversationTimestamp?: bigint | number | null
    createdAt?: bigint | number | null
    createdBy?: string | null
    description?: string | null
    disappearingMode?: NullableJsonNullValueInput | InputJsonValue
    displayName?: string | null
    endOfHistoryTransfer?: boolean | null
    endOfHistoryTransferType?: number | null
    ephemeralExpiration?: number | null
    ephemeralSettingTimestamp?: bigint | number | null
    id: string
    isDefaultSubgroup?: boolean | null
    isParentGroup?: boolean | null
    lastMsgTimestamp?: bigint | number | null
    lidJid?: string | null
    markedAsUnread?: boolean | null
    mediaVisibility?: number | null
    messages?: NullableJsonNullValueInput | InputJsonValue
    muteEndTime?: bigint | number | null
    name?: string | null
    newJid?: string | null
    notSpam?: boolean | null
    oldJid?: string | null
    pHash?: string | null
    parentGroupId?: string | null
    participant?: NullableJsonNullValueInput | InputJsonValue
    pinned?: bigint | number | null
    pnJid?: string | null
    pnhDuplicateLidThread?: boolean | null
    readOnly?: boolean | null
    shareOwnPn?: boolean | null
    support?: boolean | null
    suspended?: boolean | null
    tcToken?: Uint8Array | null
    tcTokenSenderTimestamp?: bigint | number | null
    tcTokenTimestamp?: bigint | number | null
    terminated?: boolean | null
    unreadCount?: number | null
    unreadMentionCount?: number | null
    wallpaper?: NullableJsonNullValueInput | InputJsonValue
    lastMessageRecvTimestamp?: number | null
    commentsCount?: number | null
    picture?: string | null
    auto_reply_enabled?: boolean | null
    badge_id?: number | null
  }

  export type ChatUpdateInput = {
    sessionId?: StringFieldUpdateOperationsInput | string
    archived?: NullableBoolFieldUpdateOperationsInput | boolean | null
    contactPrimaryIdentityKey?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    conversationTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    createdAt?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    createdBy?: NullableStringFieldUpdateOperationsInput | string | null
    description?: NullableStringFieldUpdateOperationsInput | string | null
    disappearingMode?: NullableJsonNullValueInput | InputJsonValue
    displayName?: NullableStringFieldUpdateOperationsInput | string | null
    endOfHistoryTransfer?: NullableBoolFieldUpdateOperationsInput | boolean | null
    endOfHistoryTransferType?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralExpiration?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralSettingTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    id?: StringFieldUpdateOperationsInput | string
    isDefaultSubgroup?: NullableBoolFieldUpdateOperationsInput | boolean | null
    isParentGroup?: NullableBoolFieldUpdateOperationsInput | boolean | null
    lastMsgTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    lidJid?: NullableStringFieldUpdateOperationsInput | string | null
    markedAsUnread?: NullableBoolFieldUpdateOperationsInput | boolean | null
    mediaVisibility?: NullableIntFieldUpdateOperationsInput | number | null
    messages?: NullableJsonNullValueInput | InputJsonValue
    muteEndTime?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    name?: NullableStringFieldUpdateOperationsInput | string | null
    newJid?: NullableStringFieldUpdateOperationsInput | string | null
    notSpam?: NullableBoolFieldUpdateOperationsInput | boolean | null
    oldJid?: NullableStringFieldUpdateOperationsInput | string | null
    pHash?: NullableStringFieldUpdateOperationsInput | string | null
    parentGroupId?: NullableStringFieldUpdateOperationsInput | string | null
    participant?: NullableJsonNullValueInput | InputJsonValue
    pinned?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    pnJid?: NullableStringFieldUpdateOperationsInput | string | null
    pnhDuplicateLidThread?: NullableBoolFieldUpdateOperationsInput | boolean | null
    readOnly?: NullableBoolFieldUpdateOperationsInput | boolean | null
    shareOwnPn?: NullableBoolFieldUpdateOperationsInput | boolean | null
    support?: NullableBoolFieldUpdateOperationsInput | boolean | null
    suspended?: NullableBoolFieldUpdateOperationsInput | boolean | null
    tcToken?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    tcTokenSenderTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    tcTokenTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    terminated?: NullableBoolFieldUpdateOperationsInput | boolean | null
    unreadCount?: NullableIntFieldUpdateOperationsInput | number | null
    unreadMentionCount?: NullableIntFieldUpdateOperationsInput | number | null
    wallpaper?: NullableJsonNullValueInput | InputJsonValue
    lastMessageRecvTimestamp?: NullableIntFieldUpdateOperationsInput | number | null
    commentsCount?: NullableIntFieldUpdateOperationsInput | number | null
    picture?: NullableStringFieldUpdateOperationsInput | string | null
    auto_reply_enabled?: NullableBoolFieldUpdateOperationsInput | boolean | null
    badge_id?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type ChatUncheckedUpdateInput = {
    pkId?: IntFieldUpdateOperationsInput | number
    sessionId?: StringFieldUpdateOperationsInput | string
    archived?: NullableBoolFieldUpdateOperationsInput | boolean | null
    contactPrimaryIdentityKey?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    conversationTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    createdAt?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    createdBy?: NullableStringFieldUpdateOperationsInput | string | null
    description?: NullableStringFieldUpdateOperationsInput | string | null
    disappearingMode?: NullableJsonNullValueInput | InputJsonValue
    displayName?: NullableStringFieldUpdateOperationsInput | string | null
    endOfHistoryTransfer?: NullableBoolFieldUpdateOperationsInput | boolean | null
    endOfHistoryTransferType?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralExpiration?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralSettingTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    id?: StringFieldUpdateOperationsInput | string
    isDefaultSubgroup?: NullableBoolFieldUpdateOperationsInput | boolean | null
    isParentGroup?: NullableBoolFieldUpdateOperationsInput | boolean | null
    lastMsgTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    lidJid?: NullableStringFieldUpdateOperationsInput | string | null
    markedAsUnread?: NullableBoolFieldUpdateOperationsInput | boolean | null
    mediaVisibility?: NullableIntFieldUpdateOperationsInput | number | null
    messages?: NullableJsonNullValueInput | InputJsonValue
    muteEndTime?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    name?: NullableStringFieldUpdateOperationsInput | string | null
    newJid?: NullableStringFieldUpdateOperationsInput | string | null
    notSpam?: NullableBoolFieldUpdateOperationsInput | boolean | null
    oldJid?: NullableStringFieldUpdateOperationsInput | string | null
    pHash?: NullableStringFieldUpdateOperationsInput | string | null
    parentGroupId?: NullableStringFieldUpdateOperationsInput | string | null
    participant?: NullableJsonNullValueInput | InputJsonValue
    pinned?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    pnJid?: NullableStringFieldUpdateOperationsInput | string | null
    pnhDuplicateLidThread?: NullableBoolFieldUpdateOperationsInput | boolean | null
    readOnly?: NullableBoolFieldUpdateOperationsInput | boolean | null
    shareOwnPn?: NullableBoolFieldUpdateOperationsInput | boolean | null
    support?: NullableBoolFieldUpdateOperationsInput | boolean | null
    suspended?: NullableBoolFieldUpdateOperationsInput | boolean | null
    tcToken?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    tcTokenSenderTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    tcTokenTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    terminated?: NullableBoolFieldUpdateOperationsInput | boolean | null
    unreadCount?: NullableIntFieldUpdateOperationsInput | number | null
    unreadMentionCount?: NullableIntFieldUpdateOperationsInput | number | null
    wallpaper?: NullableJsonNullValueInput | InputJsonValue
    lastMessageRecvTimestamp?: NullableIntFieldUpdateOperationsInput | number | null
    commentsCount?: NullableIntFieldUpdateOperationsInput | number | null
    picture?: NullableStringFieldUpdateOperationsInput | string | null
    auto_reply_enabled?: NullableBoolFieldUpdateOperationsInput | boolean | null
    badge_id?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type ChatCreateManyInput = {
    pkId?: number
    sessionId: string
    archived?: boolean | null
    contactPrimaryIdentityKey?: Uint8Array | null
    conversationTimestamp?: bigint | number | null
    createdAt?: bigint | number | null
    createdBy?: string | null
    description?: string | null
    disappearingMode?: NullableJsonNullValueInput | InputJsonValue
    displayName?: string | null
    endOfHistoryTransfer?: boolean | null
    endOfHistoryTransferType?: number | null
    ephemeralExpiration?: number | null
    ephemeralSettingTimestamp?: bigint | number | null
    id: string
    isDefaultSubgroup?: boolean | null
    isParentGroup?: boolean | null
    lastMsgTimestamp?: bigint | number | null
    lidJid?: string | null
    markedAsUnread?: boolean | null
    mediaVisibility?: number | null
    messages?: NullableJsonNullValueInput | InputJsonValue
    muteEndTime?: bigint | number | null
    name?: string | null
    newJid?: string | null
    notSpam?: boolean | null
    oldJid?: string | null
    pHash?: string | null
    parentGroupId?: string | null
    participant?: NullableJsonNullValueInput | InputJsonValue
    pinned?: bigint | number | null
    pnJid?: string | null
    pnhDuplicateLidThread?: boolean | null
    readOnly?: boolean | null
    shareOwnPn?: boolean | null
    support?: boolean | null
    suspended?: boolean | null
    tcToken?: Uint8Array | null
    tcTokenSenderTimestamp?: bigint | number | null
    tcTokenTimestamp?: bigint | number | null
    terminated?: boolean | null
    unreadCount?: number | null
    unreadMentionCount?: number | null
    wallpaper?: NullableJsonNullValueInput | InputJsonValue
    lastMessageRecvTimestamp?: number | null
    commentsCount?: number | null
    picture?: string | null
    auto_reply_enabled?: boolean | null
    badge_id?: number | null
  }

  export type ChatUpdateManyMutationInput = {
    sessionId?: StringFieldUpdateOperationsInput | string
    archived?: NullableBoolFieldUpdateOperationsInput | boolean | null
    contactPrimaryIdentityKey?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    conversationTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    createdAt?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    createdBy?: NullableStringFieldUpdateOperationsInput | string | null
    description?: NullableStringFieldUpdateOperationsInput | string | null
    disappearingMode?: NullableJsonNullValueInput | InputJsonValue
    displayName?: NullableStringFieldUpdateOperationsInput | string | null
    endOfHistoryTransfer?: NullableBoolFieldUpdateOperationsInput | boolean | null
    endOfHistoryTransferType?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralExpiration?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralSettingTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    id?: StringFieldUpdateOperationsInput | string
    isDefaultSubgroup?: NullableBoolFieldUpdateOperationsInput | boolean | null
    isParentGroup?: NullableBoolFieldUpdateOperationsInput | boolean | null
    lastMsgTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    lidJid?: NullableStringFieldUpdateOperationsInput | string | null
    markedAsUnread?: NullableBoolFieldUpdateOperationsInput | boolean | null
    mediaVisibility?: NullableIntFieldUpdateOperationsInput | number | null
    messages?: NullableJsonNullValueInput | InputJsonValue
    muteEndTime?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    name?: NullableStringFieldUpdateOperationsInput | string | null
    newJid?: NullableStringFieldUpdateOperationsInput | string | null
    notSpam?: NullableBoolFieldUpdateOperationsInput | boolean | null
    oldJid?: NullableStringFieldUpdateOperationsInput | string | null
    pHash?: NullableStringFieldUpdateOperationsInput | string | null
    parentGroupId?: NullableStringFieldUpdateOperationsInput | string | null
    participant?: NullableJsonNullValueInput | InputJsonValue
    pinned?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    pnJid?: NullableStringFieldUpdateOperationsInput | string | null
    pnhDuplicateLidThread?: NullableBoolFieldUpdateOperationsInput | boolean | null
    readOnly?: NullableBoolFieldUpdateOperationsInput | boolean | null
    shareOwnPn?: NullableBoolFieldUpdateOperationsInput | boolean | null
    support?: NullableBoolFieldUpdateOperationsInput | boolean | null
    suspended?: NullableBoolFieldUpdateOperationsInput | boolean | null
    tcToken?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    tcTokenSenderTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    tcTokenTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    terminated?: NullableBoolFieldUpdateOperationsInput | boolean | null
    unreadCount?: NullableIntFieldUpdateOperationsInput | number | null
    unreadMentionCount?: NullableIntFieldUpdateOperationsInput | number | null
    wallpaper?: NullableJsonNullValueInput | InputJsonValue
    lastMessageRecvTimestamp?: NullableIntFieldUpdateOperationsInput | number | null
    commentsCount?: NullableIntFieldUpdateOperationsInput | number | null
    picture?: NullableStringFieldUpdateOperationsInput | string | null
    auto_reply_enabled?: NullableBoolFieldUpdateOperationsInput | boolean | null
    badge_id?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type ChatUncheckedUpdateManyInput = {
    pkId?: IntFieldUpdateOperationsInput | number
    sessionId?: StringFieldUpdateOperationsInput | string
    archived?: NullableBoolFieldUpdateOperationsInput | boolean | null
    contactPrimaryIdentityKey?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    conversationTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    createdAt?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    createdBy?: NullableStringFieldUpdateOperationsInput | string | null
    description?: NullableStringFieldUpdateOperationsInput | string | null
    disappearingMode?: NullableJsonNullValueInput | InputJsonValue
    displayName?: NullableStringFieldUpdateOperationsInput | string | null
    endOfHistoryTransfer?: NullableBoolFieldUpdateOperationsInput | boolean | null
    endOfHistoryTransferType?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralExpiration?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralSettingTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    id?: StringFieldUpdateOperationsInput | string
    isDefaultSubgroup?: NullableBoolFieldUpdateOperationsInput | boolean | null
    isParentGroup?: NullableBoolFieldUpdateOperationsInput | boolean | null
    lastMsgTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    lidJid?: NullableStringFieldUpdateOperationsInput | string | null
    markedAsUnread?: NullableBoolFieldUpdateOperationsInput | boolean | null
    mediaVisibility?: NullableIntFieldUpdateOperationsInput | number | null
    messages?: NullableJsonNullValueInput | InputJsonValue
    muteEndTime?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    name?: NullableStringFieldUpdateOperationsInput | string | null
    newJid?: NullableStringFieldUpdateOperationsInput | string | null
    notSpam?: NullableBoolFieldUpdateOperationsInput | boolean | null
    oldJid?: NullableStringFieldUpdateOperationsInput | string | null
    pHash?: NullableStringFieldUpdateOperationsInput | string | null
    parentGroupId?: NullableStringFieldUpdateOperationsInput | string | null
    participant?: NullableJsonNullValueInput | InputJsonValue
    pinned?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    pnJid?: NullableStringFieldUpdateOperationsInput | string | null
    pnhDuplicateLidThread?: NullableBoolFieldUpdateOperationsInput | boolean | null
    readOnly?: NullableBoolFieldUpdateOperationsInput | boolean | null
    shareOwnPn?: NullableBoolFieldUpdateOperationsInput | boolean | null
    support?: NullableBoolFieldUpdateOperationsInput | boolean | null
    suspended?: NullableBoolFieldUpdateOperationsInput | boolean | null
    tcToken?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    tcTokenSenderTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    tcTokenTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    terminated?: NullableBoolFieldUpdateOperationsInput | boolean | null
    unreadCount?: NullableIntFieldUpdateOperationsInput | number | null
    unreadMentionCount?: NullableIntFieldUpdateOperationsInput | number | null
    wallpaper?: NullableJsonNullValueInput | InputJsonValue
    lastMessageRecvTimestamp?: NullableIntFieldUpdateOperationsInput | number | null
    commentsCount?: NullableIntFieldUpdateOperationsInput | number | null
    picture?: NullableStringFieldUpdateOperationsInput | string | null
    auto_reply_enabled?: NullableBoolFieldUpdateOperationsInput | boolean | null
    badge_id?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type ContactCreateInput = {
    sessionId: string
    id: string
    name?: string | null
    notify?: string | null
    verifiedName?: string | null
    imgUrl?: string | null
    status?: string | null
  }

  export type ContactUncheckedCreateInput = {
    pkId?: number
    sessionId: string
    id: string
    name?: string | null
    notify?: string | null
    verifiedName?: string | null
    imgUrl?: string | null
    status?: string | null
  }

  export type ContactUpdateInput = {
    sessionId?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    name?: NullableStringFieldUpdateOperationsInput | string | null
    notify?: NullableStringFieldUpdateOperationsInput | string | null
    verifiedName?: NullableStringFieldUpdateOperationsInput | string | null
    imgUrl?: NullableStringFieldUpdateOperationsInput | string | null
    status?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type ContactUncheckedUpdateInput = {
    pkId?: IntFieldUpdateOperationsInput | number
    sessionId?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    name?: NullableStringFieldUpdateOperationsInput | string | null
    notify?: NullableStringFieldUpdateOperationsInput | string | null
    verifiedName?: NullableStringFieldUpdateOperationsInput | string | null
    imgUrl?: NullableStringFieldUpdateOperationsInput | string | null
    status?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type ContactCreateManyInput = {
    pkId?: number
    sessionId: string
    id: string
    name?: string | null
    notify?: string | null
    verifiedName?: string | null
    imgUrl?: string | null
    status?: string | null
  }

  export type ContactUpdateManyMutationInput = {
    sessionId?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    name?: NullableStringFieldUpdateOperationsInput | string | null
    notify?: NullableStringFieldUpdateOperationsInput | string | null
    verifiedName?: NullableStringFieldUpdateOperationsInput | string | null
    imgUrl?: NullableStringFieldUpdateOperationsInput | string | null
    status?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type ContactUncheckedUpdateManyInput = {
    pkId?: IntFieldUpdateOperationsInput | number
    sessionId?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    name?: NullableStringFieldUpdateOperationsInput | string | null
    notify?: NullableStringFieldUpdateOperationsInput | string | null
    verifiedName?: NullableStringFieldUpdateOperationsInput | string | null
    imgUrl?: NullableStringFieldUpdateOperationsInput | string | null
    status?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type GroupMetadataCreateInput = {
    sessionId: string
    id: string
    owner?: string | null
    subject: string
    subjectOwner?: string | null
    subjectTime?: number | null
    creation?: number | null
    desc?: string | null
    descOwner?: string | null
    descId?: string | null
    restrict?: boolean | null
    announce?: boolean | null
    isCommunity?: boolean | null
    isCommunityAnnounce?: boolean | null
    joinApprovalMode?: boolean | null
    memberAddMode?: boolean | null
    author?: string | null
    size?: number | null
    participants: JsonNullValueInput | InputJsonValue
    ephemeralDuration?: number | null
    inviteCode?: string | null
  }

  export type GroupMetadataUncheckedCreateInput = {
    pkId?: number
    sessionId: string
    id: string
    owner?: string | null
    subject: string
    subjectOwner?: string | null
    subjectTime?: number | null
    creation?: number | null
    desc?: string | null
    descOwner?: string | null
    descId?: string | null
    restrict?: boolean | null
    announce?: boolean | null
    isCommunity?: boolean | null
    isCommunityAnnounce?: boolean | null
    joinApprovalMode?: boolean | null
    memberAddMode?: boolean | null
    author?: string | null
    size?: number | null
    participants: JsonNullValueInput | InputJsonValue
    ephemeralDuration?: number | null
    inviteCode?: string | null
  }

  export type GroupMetadataUpdateInput = {
    sessionId?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    owner?: NullableStringFieldUpdateOperationsInput | string | null
    subject?: StringFieldUpdateOperationsInput | string
    subjectOwner?: NullableStringFieldUpdateOperationsInput | string | null
    subjectTime?: NullableIntFieldUpdateOperationsInput | number | null
    creation?: NullableIntFieldUpdateOperationsInput | number | null
    desc?: NullableStringFieldUpdateOperationsInput | string | null
    descOwner?: NullableStringFieldUpdateOperationsInput | string | null
    descId?: NullableStringFieldUpdateOperationsInput | string | null
    restrict?: NullableBoolFieldUpdateOperationsInput | boolean | null
    announce?: NullableBoolFieldUpdateOperationsInput | boolean | null
    isCommunity?: NullableBoolFieldUpdateOperationsInput | boolean | null
    isCommunityAnnounce?: NullableBoolFieldUpdateOperationsInput | boolean | null
    joinApprovalMode?: NullableBoolFieldUpdateOperationsInput | boolean | null
    memberAddMode?: NullableBoolFieldUpdateOperationsInput | boolean | null
    author?: NullableStringFieldUpdateOperationsInput | string | null
    size?: NullableIntFieldUpdateOperationsInput | number | null
    participants?: JsonNullValueInput | InputJsonValue
    ephemeralDuration?: NullableIntFieldUpdateOperationsInput | number | null
    inviteCode?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type GroupMetadataUncheckedUpdateInput = {
    pkId?: IntFieldUpdateOperationsInput | number
    sessionId?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    owner?: NullableStringFieldUpdateOperationsInput | string | null
    subject?: StringFieldUpdateOperationsInput | string
    subjectOwner?: NullableStringFieldUpdateOperationsInput | string | null
    subjectTime?: NullableIntFieldUpdateOperationsInput | number | null
    creation?: NullableIntFieldUpdateOperationsInput | number | null
    desc?: NullableStringFieldUpdateOperationsInput | string | null
    descOwner?: NullableStringFieldUpdateOperationsInput | string | null
    descId?: NullableStringFieldUpdateOperationsInput | string | null
    restrict?: NullableBoolFieldUpdateOperationsInput | boolean | null
    announce?: NullableBoolFieldUpdateOperationsInput | boolean | null
    isCommunity?: NullableBoolFieldUpdateOperationsInput | boolean | null
    isCommunityAnnounce?: NullableBoolFieldUpdateOperationsInput | boolean | null
    joinApprovalMode?: NullableBoolFieldUpdateOperationsInput | boolean | null
    memberAddMode?: NullableBoolFieldUpdateOperationsInput | boolean | null
    author?: NullableStringFieldUpdateOperationsInput | string | null
    size?: NullableIntFieldUpdateOperationsInput | number | null
    participants?: JsonNullValueInput | InputJsonValue
    ephemeralDuration?: NullableIntFieldUpdateOperationsInput | number | null
    inviteCode?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type GroupMetadataCreateManyInput = {
    pkId?: number
    sessionId: string
    id: string
    owner?: string | null
    subject: string
    subjectOwner?: string | null
    subjectTime?: number | null
    creation?: number | null
    desc?: string | null
    descOwner?: string | null
    descId?: string | null
    restrict?: boolean | null
    announce?: boolean | null
    isCommunity?: boolean | null
    isCommunityAnnounce?: boolean | null
    joinApprovalMode?: boolean | null
    memberAddMode?: boolean | null
    author?: string | null
    size?: number | null
    participants: JsonNullValueInput | InputJsonValue
    ephemeralDuration?: number | null
    inviteCode?: string | null
  }

  export type GroupMetadataUpdateManyMutationInput = {
    sessionId?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    owner?: NullableStringFieldUpdateOperationsInput | string | null
    subject?: StringFieldUpdateOperationsInput | string
    subjectOwner?: NullableStringFieldUpdateOperationsInput | string | null
    subjectTime?: NullableIntFieldUpdateOperationsInput | number | null
    creation?: NullableIntFieldUpdateOperationsInput | number | null
    desc?: NullableStringFieldUpdateOperationsInput | string | null
    descOwner?: NullableStringFieldUpdateOperationsInput | string | null
    descId?: NullableStringFieldUpdateOperationsInput | string | null
    restrict?: NullableBoolFieldUpdateOperationsInput | boolean | null
    announce?: NullableBoolFieldUpdateOperationsInput | boolean | null
    isCommunity?: NullableBoolFieldUpdateOperationsInput | boolean | null
    isCommunityAnnounce?: NullableBoolFieldUpdateOperationsInput | boolean | null
    joinApprovalMode?: NullableBoolFieldUpdateOperationsInput | boolean | null
    memberAddMode?: NullableBoolFieldUpdateOperationsInput | boolean | null
    author?: NullableStringFieldUpdateOperationsInput | string | null
    size?: NullableIntFieldUpdateOperationsInput | number | null
    participants?: JsonNullValueInput | InputJsonValue
    ephemeralDuration?: NullableIntFieldUpdateOperationsInput | number | null
    inviteCode?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type GroupMetadataUncheckedUpdateManyInput = {
    pkId?: IntFieldUpdateOperationsInput | number
    sessionId?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    owner?: NullableStringFieldUpdateOperationsInput | string | null
    subject?: StringFieldUpdateOperationsInput | string
    subjectOwner?: NullableStringFieldUpdateOperationsInput | string | null
    subjectTime?: NullableIntFieldUpdateOperationsInput | number | null
    creation?: NullableIntFieldUpdateOperationsInput | number | null
    desc?: NullableStringFieldUpdateOperationsInput | string | null
    descOwner?: NullableStringFieldUpdateOperationsInput | string | null
    descId?: NullableStringFieldUpdateOperationsInput | string | null
    restrict?: NullableBoolFieldUpdateOperationsInput | boolean | null
    announce?: NullableBoolFieldUpdateOperationsInput | boolean | null
    isCommunity?: NullableBoolFieldUpdateOperationsInput | boolean | null
    isCommunityAnnounce?: NullableBoolFieldUpdateOperationsInput | boolean | null
    joinApprovalMode?: NullableBoolFieldUpdateOperationsInput | boolean | null
    memberAddMode?: NullableBoolFieldUpdateOperationsInput | boolean | null
    author?: NullableStringFieldUpdateOperationsInput | string | null
    size?: NullableIntFieldUpdateOperationsInput | number | null
    participants?: JsonNullValueInput | InputJsonValue
    ephemeralDuration?: NullableIntFieldUpdateOperationsInput | number | null
    inviteCode?: NullableStringFieldUpdateOperationsInput | string | null
  }

  export type MessageCreateInput = {
    sessionId: string
    remoteJid: string
    id: string
    agentId?: string | null
    bizPrivacyStatus?: number | null
    broadcast?: boolean | null
    clearMedia?: boolean | null
    duration?: number | null
    ephemeralDuration?: number | null
    ephemeralOffToOn?: boolean | null
    ephemeralOutOfSync?: boolean | null
    ephemeralStartTimestamp?: bigint | number | null
    finalLiveLocation?: NullableJsonNullValueInput | InputJsonValue
    futureproofData?: Uint8Array | null
    ignore?: boolean | null
    keepInChat?: NullableJsonNullValueInput | InputJsonValue
    key: JsonNullValueInput | InputJsonValue
    labels?: NullableJsonNullValueInput | InputJsonValue
    mediaCiphertextSha256?: Uint8Array | null
    mediaData?: NullableJsonNullValueInput | InputJsonValue
    message?: NullableJsonNullValueInput | InputJsonValue
    messageC2STimestamp?: bigint | number | null
    messageSecret?: Uint8Array | null
    messageStubParameters?: NullableJsonNullValueInput | InputJsonValue
    messageStubType?: number | null
    messageTimestamp?: bigint | number | null
    multicast?: boolean | null
    originalSelfAuthorUserJidString?: string | null
    participant?: string | null
    paymentInfo?: NullableJsonNullValueInput | InputJsonValue
    photoChange?: NullableJsonNullValueInput | InputJsonValue
    pollAdditionalMetadata?: NullableJsonNullValueInput | InputJsonValue
    pollUpdates?: NullableJsonNullValueInput | InputJsonValue
    pushName?: string | null
    quotedPaymentInfo?: NullableJsonNullValueInput | InputJsonValue
    quotedStickerData?: NullableJsonNullValueInput | InputJsonValue
    reactions?: NullableJsonNullValueInput | InputJsonValue
    revokeMessageTimestamp?: bigint | number | null
    starred?: boolean | null
    status?: number | null
    statusAlreadyViewed?: boolean | null
    statusPsa?: NullableJsonNullValueInput | InputJsonValue
    urlNumber?: boolean | null
    urlText?: boolean | null
    userReceipt?: NullableJsonNullValueInput | InputJsonValue
    verifiedBizName?: string | null
    eventResponses?: NullableJsonNullValueInput | InputJsonValue
    pinInChat?: NullableJsonNullValueInput | InputJsonValue
    reportingTokenInfo?: NullableJsonNullValueInput | InputJsonValue
  }

  export type MessageUncheckedCreateInput = {
    pkId?: number
    sessionId: string
    remoteJid: string
    id: string
    agentId?: string | null
    bizPrivacyStatus?: number | null
    broadcast?: boolean | null
    clearMedia?: boolean | null
    duration?: number | null
    ephemeralDuration?: number | null
    ephemeralOffToOn?: boolean | null
    ephemeralOutOfSync?: boolean | null
    ephemeralStartTimestamp?: bigint | number | null
    finalLiveLocation?: NullableJsonNullValueInput | InputJsonValue
    futureproofData?: Uint8Array | null
    ignore?: boolean | null
    keepInChat?: NullableJsonNullValueInput | InputJsonValue
    key: JsonNullValueInput | InputJsonValue
    labels?: NullableJsonNullValueInput | InputJsonValue
    mediaCiphertextSha256?: Uint8Array | null
    mediaData?: NullableJsonNullValueInput | InputJsonValue
    message?: NullableJsonNullValueInput | InputJsonValue
    messageC2STimestamp?: bigint | number | null
    messageSecret?: Uint8Array | null
    messageStubParameters?: NullableJsonNullValueInput | InputJsonValue
    messageStubType?: number | null
    messageTimestamp?: bigint | number | null
    multicast?: boolean | null
    originalSelfAuthorUserJidString?: string | null
    participant?: string | null
    paymentInfo?: NullableJsonNullValueInput | InputJsonValue
    photoChange?: NullableJsonNullValueInput | InputJsonValue
    pollAdditionalMetadata?: NullableJsonNullValueInput | InputJsonValue
    pollUpdates?: NullableJsonNullValueInput | InputJsonValue
    pushName?: string | null
    quotedPaymentInfo?: NullableJsonNullValueInput | InputJsonValue
    quotedStickerData?: NullableJsonNullValueInput | InputJsonValue
    reactions?: NullableJsonNullValueInput | InputJsonValue
    revokeMessageTimestamp?: bigint | number | null
    starred?: boolean | null
    status?: number | null
    statusAlreadyViewed?: boolean | null
    statusPsa?: NullableJsonNullValueInput | InputJsonValue
    urlNumber?: boolean | null
    urlText?: boolean | null
    userReceipt?: NullableJsonNullValueInput | InputJsonValue
    verifiedBizName?: string | null
    eventResponses?: NullableJsonNullValueInput | InputJsonValue
    pinInChat?: NullableJsonNullValueInput | InputJsonValue
    reportingTokenInfo?: NullableJsonNullValueInput | InputJsonValue
  }

  export type MessageUpdateInput = {
    sessionId?: StringFieldUpdateOperationsInput | string
    remoteJid?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    agentId?: NullableStringFieldUpdateOperationsInput | string | null
    bizPrivacyStatus?: NullableIntFieldUpdateOperationsInput | number | null
    broadcast?: NullableBoolFieldUpdateOperationsInput | boolean | null
    clearMedia?: NullableBoolFieldUpdateOperationsInput | boolean | null
    duration?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralDuration?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralOffToOn?: NullableBoolFieldUpdateOperationsInput | boolean | null
    ephemeralOutOfSync?: NullableBoolFieldUpdateOperationsInput | boolean | null
    ephemeralStartTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    finalLiveLocation?: NullableJsonNullValueInput | InputJsonValue
    futureproofData?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    ignore?: NullableBoolFieldUpdateOperationsInput | boolean | null
    keepInChat?: NullableJsonNullValueInput | InputJsonValue
    key?: JsonNullValueInput | InputJsonValue
    labels?: NullableJsonNullValueInput | InputJsonValue
    mediaCiphertextSha256?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    mediaData?: NullableJsonNullValueInput | InputJsonValue
    message?: NullableJsonNullValueInput | InputJsonValue
    messageC2STimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    messageSecret?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    messageStubParameters?: NullableJsonNullValueInput | InputJsonValue
    messageStubType?: NullableIntFieldUpdateOperationsInput | number | null
    messageTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    multicast?: NullableBoolFieldUpdateOperationsInput | boolean | null
    originalSelfAuthorUserJidString?: NullableStringFieldUpdateOperationsInput | string | null
    participant?: NullableStringFieldUpdateOperationsInput | string | null
    paymentInfo?: NullableJsonNullValueInput | InputJsonValue
    photoChange?: NullableJsonNullValueInput | InputJsonValue
    pollAdditionalMetadata?: NullableJsonNullValueInput | InputJsonValue
    pollUpdates?: NullableJsonNullValueInput | InputJsonValue
    pushName?: NullableStringFieldUpdateOperationsInput | string | null
    quotedPaymentInfo?: NullableJsonNullValueInput | InputJsonValue
    quotedStickerData?: NullableJsonNullValueInput | InputJsonValue
    reactions?: NullableJsonNullValueInput | InputJsonValue
    revokeMessageTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    starred?: NullableBoolFieldUpdateOperationsInput | boolean | null
    status?: NullableIntFieldUpdateOperationsInput | number | null
    statusAlreadyViewed?: NullableBoolFieldUpdateOperationsInput | boolean | null
    statusPsa?: NullableJsonNullValueInput | InputJsonValue
    urlNumber?: NullableBoolFieldUpdateOperationsInput | boolean | null
    urlText?: NullableBoolFieldUpdateOperationsInput | boolean | null
    userReceipt?: NullableJsonNullValueInput | InputJsonValue
    verifiedBizName?: NullableStringFieldUpdateOperationsInput | string | null
    eventResponses?: NullableJsonNullValueInput | InputJsonValue
    pinInChat?: NullableJsonNullValueInput | InputJsonValue
    reportingTokenInfo?: NullableJsonNullValueInput | InputJsonValue
  }

  export type MessageUncheckedUpdateInput = {
    pkId?: IntFieldUpdateOperationsInput | number
    sessionId?: StringFieldUpdateOperationsInput | string
    remoteJid?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    agentId?: NullableStringFieldUpdateOperationsInput | string | null
    bizPrivacyStatus?: NullableIntFieldUpdateOperationsInput | number | null
    broadcast?: NullableBoolFieldUpdateOperationsInput | boolean | null
    clearMedia?: NullableBoolFieldUpdateOperationsInput | boolean | null
    duration?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralDuration?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralOffToOn?: NullableBoolFieldUpdateOperationsInput | boolean | null
    ephemeralOutOfSync?: NullableBoolFieldUpdateOperationsInput | boolean | null
    ephemeralStartTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    finalLiveLocation?: NullableJsonNullValueInput | InputJsonValue
    futureproofData?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    ignore?: NullableBoolFieldUpdateOperationsInput | boolean | null
    keepInChat?: NullableJsonNullValueInput | InputJsonValue
    key?: JsonNullValueInput | InputJsonValue
    labels?: NullableJsonNullValueInput | InputJsonValue
    mediaCiphertextSha256?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    mediaData?: NullableJsonNullValueInput | InputJsonValue
    message?: NullableJsonNullValueInput | InputJsonValue
    messageC2STimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    messageSecret?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    messageStubParameters?: NullableJsonNullValueInput | InputJsonValue
    messageStubType?: NullableIntFieldUpdateOperationsInput | number | null
    messageTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    multicast?: NullableBoolFieldUpdateOperationsInput | boolean | null
    originalSelfAuthorUserJidString?: NullableStringFieldUpdateOperationsInput | string | null
    participant?: NullableStringFieldUpdateOperationsInput | string | null
    paymentInfo?: NullableJsonNullValueInput | InputJsonValue
    photoChange?: NullableJsonNullValueInput | InputJsonValue
    pollAdditionalMetadata?: NullableJsonNullValueInput | InputJsonValue
    pollUpdates?: NullableJsonNullValueInput | InputJsonValue
    pushName?: NullableStringFieldUpdateOperationsInput | string | null
    quotedPaymentInfo?: NullableJsonNullValueInput | InputJsonValue
    quotedStickerData?: NullableJsonNullValueInput | InputJsonValue
    reactions?: NullableJsonNullValueInput | InputJsonValue
    revokeMessageTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    starred?: NullableBoolFieldUpdateOperationsInput | boolean | null
    status?: NullableIntFieldUpdateOperationsInput | number | null
    statusAlreadyViewed?: NullableBoolFieldUpdateOperationsInput | boolean | null
    statusPsa?: NullableJsonNullValueInput | InputJsonValue
    urlNumber?: NullableBoolFieldUpdateOperationsInput | boolean | null
    urlText?: NullableBoolFieldUpdateOperationsInput | boolean | null
    userReceipt?: NullableJsonNullValueInput | InputJsonValue
    verifiedBizName?: NullableStringFieldUpdateOperationsInput | string | null
    eventResponses?: NullableJsonNullValueInput | InputJsonValue
    pinInChat?: NullableJsonNullValueInput | InputJsonValue
    reportingTokenInfo?: NullableJsonNullValueInput | InputJsonValue
  }

  export type MessageCreateManyInput = {
    pkId?: number
    sessionId: string
    remoteJid: string
    id: string
    agentId?: string | null
    bizPrivacyStatus?: number | null
    broadcast?: boolean | null
    clearMedia?: boolean | null
    duration?: number | null
    ephemeralDuration?: number | null
    ephemeralOffToOn?: boolean | null
    ephemeralOutOfSync?: boolean | null
    ephemeralStartTimestamp?: bigint | number | null
    finalLiveLocation?: NullableJsonNullValueInput | InputJsonValue
    futureproofData?: Uint8Array | null
    ignore?: boolean | null
    keepInChat?: NullableJsonNullValueInput | InputJsonValue
    key: JsonNullValueInput | InputJsonValue
    labels?: NullableJsonNullValueInput | InputJsonValue
    mediaCiphertextSha256?: Uint8Array | null
    mediaData?: NullableJsonNullValueInput | InputJsonValue
    message?: NullableJsonNullValueInput | InputJsonValue
    messageC2STimestamp?: bigint | number | null
    messageSecret?: Uint8Array | null
    messageStubParameters?: NullableJsonNullValueInput | InputJsonValue
    messageStubType?: number | null
    messageTimestamp?: bigint | number | null
    multicast?: boolean | null
    originalSelfAuthorUserJidString?: string | null
    participant?: string | null
    paymentInfo?: NullableJsonNullValueInput | InputJsonValue
    photoChange?: NullableJsonNullValueInput | InputJsonValue
    pollAdditionalMetadata?: NullableJsonNullValueInput | InputJsonValue
    pollUpdates?: NullableJsonNullValueInput | InputJsonValue
    pushName?: string | null
    quotedPaymentInfo?: NullableJsonNullValueInput | InputJsonValue
    quotedStickerData?: NullableJsonNullValueInput | InputJsonValue
    reactions?: NullableJsonNullValueInput | InputJsonValue
    revokeMessageTimestamp?: bigint | number | null
    starred?: boolean | null
    status?: number | null
    statusAlreadyViewed?: boolean | null
    statusPsa?: NullableJsonNullValueInput | InputJsonValue
    urlNumber?: boolean | null
    urlText?: boolean | null
    userReceipt?: NullableJsonNullValueInput | InputJsonValue
    verifiedBizName?: string | null
    eventResponses?: NullableJsonNullValueInput | InputJsonValue
    pinInChat?: NullableJsonNullValueInput | InputJsonValue
    reportingTokenInfo?: NullableJsonNullValueInput | InputJsonValue
  }

  export type MessageUpdateManyMutationInput = {
    sessionId?: StringFieldUpdateOperationsInput | string
    remoteJid?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    agentId?: NullableStringFieldUpdateOperationsInput | string | null
    bizPrivacyStatus?: NullableIntFieldUpdateOperationsInput | number | null
    broadcast?: NullableBoolFieldUpdateOperationsInput | boolean | null
    clearMedia?: NullableBoolFieldUpdateOperationsInput | boolean | null
    duration?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralDuration?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralOffToOn?: NullableBoolFieldUpdateOperationsInput | boolean | null
    ephemeralOutOfSync?: NullableBoolFieldUpdateOperationsInput | boolean | null
    ephemeralStartTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    finalLiveLocation?: NullableJsonNullValueInput | InputJsonValue
    futureproofData?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    ignore?: NullableBoolFieldUpdateOperationsInput | boolean | null
    keepInChat?: NullableJsonNullValueInput | InputJsonValue
    key?: JsonNullValueInput | InputJsonValue
    labels?: NullableJsonNullValueInput | InputJsonValue
    mediaCiphertextSha256?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    mediaData?: NullableJsonNullValueInput | InputJsonValue
    message?: NullableJsonNullValueInput | InputJsonValue
    messageC2STimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    messageSecret?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    messageStubParameters?: NullableJsonNullValueInput | InputJsonValue
    messageStubType?: NullableIntFieldUpdateOperationsInput | number | null
    messageTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    multicast?: NullableBoolFieldUpdateOperationsInput | boolean | null
    originalSelfAuthorUserJidString?: NullableStringFieldUpdateOperationsInput | string | null
    participant?: NullableStringFieldUpdateOperationsInput | string | null
    paymentInfo?: NullableJsonNullValueInput | InputJsonValue
    photoChange?: NullableJsonNullValueInput | InputJsonValue
    pollAdditionalMetadata?: NullableJsonNullValueInput | InputJsonValue
    pollUpdates?: NullableJsonNullValueInput | InputJsonValue
    pushName?: NullableStringFieldUpdateOperationsInput | string | null
    quotedPaymentInfo?: NullableJsonNullValueInput | InputJsonValue
    quotedStickerData?: NullableJsonNullValueInput | InputJsonValue
    reactions?: NullableJsonNullValueInput | InputJsonValue
    revokeMessageTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    starred?: NullableBoolFieldUpdateOperationsInput | boolean | null
    status?: NullableIntFieldUpdateOperationsInput | number | null
    statusAlreadyViewed?: NullableBoolFieldUpdateOperationsInput | boolean | null
    statusPsa?: NullableJsonNullValueInput | InputJsonValue
    urlNumber?: NullableBoolFieldUpdateOperationsInput | boolean | null
    urlText?: NullableBoolFieldUpdateOperationsInput | boolean | null
    userReceipt?: NullableJsonNullValueInput | InputJsonValue
    verifiedBizName?: NullableStringFieldUpdateOperationsInput | string | null
    eventResponses?: NullableJsonNullValueInput | InputJsonValue
    pinInChat?: NullableJsonNullValueInput | InputJsonValue
    reportingTokenInfo?: NullableJsonNullValueInput | InputJsonValue
  }

  export type MessageUncheckedUpdateManyInput = {
    pkId?: IntFieldUpdateOperationsInput | number
    sessionId?: StringFieldUpdateOperationsInput | string
    remoteJid?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    agentId?: NullableStringFieldUpdateOperationsInput | string | null
    bizPrivacyStatus?: NullableIntFieldUpdateOperationsInput | number | null
    broadcast?: NullableBoolFieldUpdateOperationsInput | boolean | null
    clearMedia?: NullableBoolFieldUpdateOperationsInput | boolean | null
    duration?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralDuration?: NullableIntFieldUpdateOperationsInput | number | null
    ephemeralOffToOn?: NullableBoolFieldUpdateOperationsInput | boolean | null
    ephemeralOutOfSync?: NullableBoolFieldUpdateOperationsInput | boolean | null
    ephemeralStartTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    finalLiveLocation?: NullableJsonNullValueInput | InputJsonValue
    futureproofData?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    ignore?: NullableBoolFieldUpdateOperationsInput | boolean | null
    keepInChat?: NullableJsonNullValueInput | InputJsonValue
    key?: JsonNullValueInput | InputJsonValue
    labels?: NullableJsonNullValueInput | InputJsonValue
    mediaCiphertextSha256?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    mediaData?: NullableJsonNullValueInput | InputJsonValue
    message?: NullableJsonNullValueInput | InputJsonValue
    messageC2STimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    messageSecret?: NullableBytesFieldUpdateOperationsInput | Uint8Array | null
    messageStubParameters?: NullableJsonNullValueInput | InputJsonValue
    messageStubType?: NullableIntFieldUpdateOperationsInput | number | null
    messageTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    multicast?: NullableBoolFieldUpdateOperationsInput | boolean | null
    originalSelfAuthorUserJidString?: NullableStringFieldUpdateOperationsInput | string | null
    participant?: NullableStringFieldUpdateOperationsInput | string | null
    paymentInfo?: NullableJsonNullValueInput | InputJsonValue
    photoChange?: NullableJsonNullValueInput | InputJsonValue
    pollAdditionalMetadata?: NullableJsonNullValueInput | InputJsonValue
    pollUpdates?: NullableJsonNullValueInput | InputJsonValue
    pushName?: NullableStringFieldUpdateOperationsInput | string | null
    quotedPaymentInfo?: NullableJsonNullValueInput | InputJsonValue
    quotedStickerData?: NullableJsonNullValueInput | InputJsonValue
    reactions?: NullableJsonNullValueInput | InputJsonValue
    revokeMessageTimestamp?: NullableBigIntFieldUpdateOperationsInput | bigint | number | null
    starred?: NullableBoolFieldUpdateOperationsInput | boolean | null
    status?: NullableIntFieldUpdateOperationsInput | number | null
    statusAlreadyViewed?: NullableBoolFieldUpdateOperationsInput | boolean | null
    statusPsa?: NullableJsonNullValueInput | InputJsonValue
    urlNumber?: NullableBoolFieldUpdateOperationsInput | boolean | null
    urlText?: NullableBoolFieldUpdateOperationsInput | boolean | null
    userReceipt?: NullableJsonNullValueInput | InputJsonValue
    verifiedBizName?: NullableStringFieldUpdateOperationsInput | string | null
    eventResponses?: NullableJsonNullValueInput | InputJsonValue
    pinInChat?: NullableJsonNullValueInput | InputJsonValue
    reportingTokenInfo?: NullableJsonNullValueInput | InputJsonValue
  }

  export type SessionCreateInput = {
    sessionId: string
    id: string
    data: string
  }

  export type SessionUncheckedCreateInput = {
    pkId?: number
    sessionId: string
    id: string
    data: string
  }

  export type SessionUpdateInput = {
    sessionId?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    data?: StringFieldUpdateOperationsInput | string
  }

  export type SessionUncheckedUpdateInput = {
    pkId?: IntFieldUpdateOperationsInput | number
    sessionId?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    data?: StringFieldUpdateOperationsInput | string
  }

  export type SessionCreateManyInput = {
    pkId?: number
    sessionId: string
    id: string
    data: string
  }

  export type SessionUpdateManyMutationInput = {
    sessionId?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    data?: StringFieldUpdateOperationsInput | string
  }

  export type SessionUncheckedUpdateManyInput = {
    pkId?: IntFieldUpdateOperationsInput | number
    sessionId?: StringFieldUpdateOperationsInput | string
    id?: StringFieldUpdateOperationsInput | string
    data?: StringFieldUpdateOperationsInput | string
  }

  export type IntFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntFilter<$PrismaModel> | number
  }

  export type StringFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringFilter<$PrismaModel> | string
  }

  export type BoolNullableFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel> | null
    not?: NestedBoolNullableFilter<$PrismaModel> | boolean | null
  }

  export type BytesNullableFilter<$PrismaModel = never> = {
    equals?: Uint8Array | BytesFieldRefInput<$PrismaModel> | null
    in?: Uint8Array[] | null
    notIn?: Uint8Array[] | null
    not?: NestedBytesNullableFilter<$PrismaModel> | Uint8Array | null
  }

  export type BigIntNullableFilter<$PrismaModel = never> = {
    equals?: bigint | number | BigIntFieldRefInput<$PrismaModel> | null
    in?: bigint[] | number[] | null
    notIn?: bigint[] | number[] | null
    lt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    lte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    not?: NestedBigIntNullableFilter<$PrismaModel> | bigint | number | null
  }

  export type StringNullableFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringNullableFilter<$PrismaModel> | string | null
  }
  export type JsonNullableFilter<$PrismaModel = never> =
    | PatchUndefined<
        Either<Required<JsonNullableFilterBase<$PrismaModel>>, Exclude<keyof Required<JsonNullableFilterBase<$PrismaModel>>, 'path'>>,
        Required<JsonNullableFilterBase<$PrismaModel>>
      >
    | OptionalFlat<Omit<Required<JsonNullableFilterBase<$PrismaModel>>, 'path'>>

  export type JsonNullableFilterBase<$PrismaModel = never> = {
    equals?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
    path?: string
    mode?: QueryMode | EnumQueryModeFieldRefInput<$PrismaModel>
    string_contains?: string | StringFieldRefInput<$PrismaModel>
    string_starts_with?: string | StringFieldRefInput<$PrismaModel>
    string_ends_with?: string | StringFieldRefInput<$PrismaModel>
    array_starts_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_ends_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_contains?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    lt?: InputJsonValue
    lte?: InputJsonValue
    gt?: InputJsonValue
    gte?: InputJsonValue
    not?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
  }

  export type IntNullableFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | null
    notIn?: number[] | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableFilter<$PrismaModel> | number | null
  }

  export type SortOrderInput = {
    sort: SortOrder
    nulls?: NullsOrder
  }

  export type ChatOrderByRelevanceInput = {
    fields: ChatOrderByRelevanceFieldEnum | ChatOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type ChatSessionIdIdCompoundUniqueInput = {
    sessionId: string
    id: string
  }

  export type ChatCountOrderByAggregateInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    archived?: SortOrder
    contactPrimaryIdentityKey?: SortOrder
    conversationTimestamp?: SortOrder
    createdAt?: SortOrder
    createdBy?: SortOrder
    description?: SortOrder
    disappearingMode?: SortOrder
    displayName?: SortOrder
    endOfHistoryTransfer?: SortOrder
    endOfHistoryTransferType?: SortOrder
    ephemeralExpiration?: SortOrder
    ephemeralSettingTimestamp?: SortOrder
    id?: SortOrder
    isDefaultSubgroup?: SortOrder
    isParentGroup?: SortOrder
    lastMsgTimestamp?: SortOrder
    lidJid?: SortOrder
    markedAsUnread?: SortOrder
    mediaVisibility?: SortOrder
    messages?: SortOrder
    muteEndTime?: SortOrder
    name?: SortOrder
    newJid?: SortOrder
    notSpam?: SortOrder
    oldJid?: SortOrder
    pHash?: SortOrder
    parentGroupId?: SortOrder
    participant?: SortOrder
    pinned?: SortOrder
    pnJid?: SortOrder
    pnhDuplicateLidThread?: SortOrder
    readOnly?: SortOrder
    shareOwnPn?: SortOrder
    support?: SortOrder
    suspended?: SortOrder
    tcToken?: SortOrder
    tcTokenSenderTimestamp?: SortOrder
    tcTokenTimestamp?: SortOrder
    terminated?: SortOrder
    unreadCount?: SortOrder
    unreadMentionCount?: SortOrder
    wallpaper?: SortOrder
    lastMessageRecvTimestamp?: SortOrder
    commentsCount?: SortOrder
    picture?: SortOrder
    auto_reply_enabled?: SortOrder
    badge_id?: SortOrder
  }

  export type ChatAvgOrderByAggregateInput = {
    pkId?: SortOrder
    conversationTimestamp?: SortOrder
    createdAt?: SortOrder
    endOfHistoryTransferType?: SortOrder
    ephemeralExpiration?: SortOrder
    ephemeralSettingTimestamp?: SortOrder
    lastMsgTimestamp?: SortOrder
    mediaVisibility?: SortOrder
    muteEndTime?: SortOrder
    pinned?: SortOrder
    tcTokenSenderTimestamp?: SortOrder
    tcTokenTimestamp?: SortOrder
    unreadCount?: SortOrder
    unreadMentionCount?: SortOrder
    lastMessageRecvTimestamp?: SortOrder
    commentsCount?: SortOrder
    badge_id?: SortOrder
  }

  export type ChatMaxOrderByAggregateInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    archived?: SortOrder
    contactPrimaryIdentityKey?: SortOrder
    conversationTimestamp?: SortOrder
    createdAt?: SortOrder
    createdBy?: SortOrder
    description?: SortOrder
    displayName?: SortOrder
    endOfHistoryTransfer?: SortOrder
    endOfHistoryTransferType?: SortOrder
    ephemeralExpiration?: SortOrder
    ephemeralSettingTimestamp?: SortOrder
    id?: SortOrder
    isDefaultSubgroup?: SortOrder
    isParentGroup?: SortOrder
    lastMsgTimestamp?: SortOrder
    lidJid?: SortOrder
    markedAsUnread?: SortOrder
    mediaVisibility?: SortOrder
    muteEndTime?: SortOrder
    name?: SortOrder
    newJid?: SortOrder
    notSpam?: SortOrder
    oldJid?: SortOrder
    pHash?: SortOrder
    parentGroupId?: SortOrder
    pinned?: SortOrder
    pnJid?: SortOrder
    pnhDuplicateLidThread?: SortOrder
    readOnly?: SortOrder
    shareOwnPn?: SortOrder
    support?: SortOrder
    suspended?: SortOrder
    tcToken?: SortOrder
    tcTokenSenderTimestamp?: SortOrder
    tcTokenTimestamp?: SortOrder
    terminated?: SortOrder
    unreadCount?: SortOrder
    unreadMentionCount?: SortOrder
    lastMessageRecvTimestamp?: SortOrder
    commentsCount?: SortOrder
    picture?: SortOrder
    auto_reply_enabled?: SortOrder
    badge_id?: SortOrder
  }

  export type ChatMinOrderByAggregateInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    archived?: SortOrder
    contactPrimaryIdentityKey?: SortOrder
    conversationTimestamp?: SortOrder
    createdAt?: SortOrder
    createdBy?: SortOrder
    description?: SortOrder
    displayName?: SortOrder
    endOfHistoryTransfer?: SortOrder
    endOfHistoryTransferType?: SortOrder
    ephemeralExpiration?: SortOrder
    ephemeralSettingTimestamp?: SortOrder
    id?: SortOrder
    isDefaultSubgroup?: SortOrder
    isParentGroup?: SortOrder
    lastMsgTimestamp?: SortOrder
    lidJid?: SortOrder
    markedAsUnread?: SortOrder
    mediaVisibility?: SortOrder
    muteEndTime?: SortOrder
    name?: SortOrder
    newJid?: SortOrder
    notSpam?: SortOrder
    oldJid?: SortOrder
    pHash?: SortOrder
    parentGroupId?: SortOrder
    pinned?: SortOrder
    pnJid?: SortOrder
    pnhDuplicateLidThread?: SortOrder
    readOnly?: SortOrder
    shareOwnPn?: SortOrder
    support?: SortOrder
    suspended?: SortOrder
    tcToken?: SortOrder
    tcTokenSenderTimestamp?: SortOrder
    tcTokenTimestamp?: SortOrder
    terminated?: SortOrder
    unreadCount?: SortOrder
    unreadMentionCount?: SortOrder
    lastMessageRecvTimestamp?: SortOrder
    commentsCount?: SortOrder
    picture?: SortOrder
    auto_reply_enabled?: SortOrder
    badge_id?: SortOrder
  }

  export type ChatSumOrderByAggregateInput = {
    pkId?: SortOrder
    conversationTimestamp?: SortOrder
    createdAt?: SortOrder
    endOfHistoryTransferType?: SortOrder
    ephemeralExpiration?: SortOrder
    ephemeralSettingTimestamp?: SortOrder
    lastMsgTimestamp?: SortOrder
    mediaVisibility?: SortOrder
    muteEndTime?: SortOrder
    pinned?: SortOrder
    tcTokenSenderTimestamp?: SortOrder
    tcTokenTimestamp?: SortOrder
    unreadCount?: SortOrder
    unreadMentionCount?: SortOrder
    lastMessageRecvTimestamp?: SortOrder
    commentsCount?: SortOrder
    badge_id?: SortOrder
  }

  export type IntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedIntFilter<$PrismaModel>
    _min?: NestedIntFilter<$PrismaModel>
    _max?: NestedIntFilter<$PrismaModel>
  }

  export type StringWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringWithAggregatesFilter<$PrismaModel> | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedStringFilter<$PrismaModel>
    _max?: NestedStringFilter<$PrismaModel>
  }

  export type BoolNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel> | null
    not?: NestedBoolNullableWithAggregatesFilter<$PrismaModel> | boolean | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedBoolNullableFilter<$PrismaModel>
    _max?: NestedBoolNullableFilter<$PrismaModel>
  }

  export type BytesNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Uint8Array | BytesFieldRefInput<$PrismaModel> | null
    in?: Uint8Array[] | null
    notIn?: Uint8Array[] | null
    not?: NestedBytesNullableWithAggregatesFilter<$PrismaModel> | Uint8Array | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedBytesNullableFilter<$PrismaModel>
    _max?: NestedBytesNullableFilter<$PrismaModel>
  }

  export type BigIntNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: bigint | number | BigIntFieldRefInput<$PrismaModel> | null
    in?: bigint[] | number[] | null
    notIn?: bigint[] | number[] | null
    lt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    lte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    not?: NestedBigIntNullableWithAggregatesFilter<$PrismaModel> | bigint | number | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _avg?: NestedFloatNullableFilter<$PrismaModel>
    _sum?: NestedBigIntNullableFilter<$PrismaModel>
    _min?: NestedBigIntNullableFilter<$PrismaModel>
    _max?: NestedBigIntNullableFilter<$PrismaModel>
  }

  export type StringNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringNullableWithAggregatesFilter<$PrismaModel> | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedStringNullableFilter<$PrismaModel>
    _max?: NestedStringNullableFilter<$PrismaModel>
  }
  export type JsonNullableWithAggregatesFilter<$PrismaModel = never> =
    | PatchUndefined<
        Either<Required<JsonNullableWithAggregatesFilterBase<$PrismaModel>>, Exclude<keyof Required<JsonNullableWithAggregatesFilterBase<$PrismaModel>>, 'path'>>,
        Required<JsonNullableWithAggregatesFilterBase<$PrismaModel>>
      >
    | OptionalFlat<Omit<Required<JsonNullableWithAggregatesFilterBase<$PrismaModel>>, 'path'>>

  export type JsonNullableWithAggregatesFilterBase<$PrismaModel = never> = {
    equals?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
    path?: string
    mode?: QueryMode | EnumQueryModeFieldRefInput<$PrismaModel>
    string_contains?: string | StringFieldRefInput<$PrismaModel>
    string_starts_with?: string | StringFieldRefInput<$PrismaModel>
    string_ends_with?: string | StringFieldRefInput<$PrismaModel>
    array_starts_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_ends_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_contains?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    lt?: InputJsonValue
    lte?: InputJsonValue
    gt?: InputJsonValue
    gte?: InputJsonValue
    not?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedJsonNullableFilter<$PrismaModel>
    _max?: NestedJsonNullableFilter<$PrismaModel>
  }

  export type IntNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | null
    notIn?: number[] | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableWithAggregatesFilter<$PrismaModel> | number | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _avg?: NestedFloatNullableFilter<$PrismaModel>
    _sum?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedIntNullableFilter<$PrismaModel>
    _max?: NestedIntNullableFilter<$PrismaModel>
  }

  export type ContactOrderByRelevanceInput = {
    fields: ContactOrderByRelevanceFieldEnum | ContactOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type ContactSessionIdIdCompoundUniqueInput = {
    sessionId: string
    id: string
  }

  export type ContactCountOrderByAggregateInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    id?: SortOrder
    name?: SortOrder
    notify?: SortOrder
    verifiedName?: SortOrder
    imgUrl?: SortOrder
    status?: SortOrder
  }

  export type ContactAvgOrderByAggregateInput = {
    pkId?: SortOrder
  }

  export type ContactMaxOrderByAggregateInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    id?: SortOrder
    name?: SortOrder
    notify?: SortOrder
    verifiedName?: SortOrder
    imgUrl?: SortOrder
    status?: SortOrder
  }

  export type ContactMinOrderByAggregateInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    id?: SortOrder
    name?: SortOrder
    notify?: SortOrder
    verifiedName?: SortOrder
    imgUrl?: SortOrder
    status?: SortOrder
  }

  export type ContactSumOrderByAggregateInput = {
    pkId?: SortOrder
  }
  export type JsonFilter<$PrismaModel = never> =
    | PatchUndefined<
        Either<Required<JsonFilterBase<$PrismaModel>>, Exclude<keyof Required<JsonFilterBase<$PrismaModel>>, 'path'>>,
        Required<JsonFilterBase<$PrismaModel>>
      >
    | OptionalFlat<Omit<Required<JsonFilterBase<$PrismaModel>>, 'path'>>

  export type JsonFilterBase<$PrismaModel = never> = {
    equals?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
    path?: string
    mode?: QueryMode | EnumQueryModeFieldRefInput<$PrismaModel>
    string_contains?: string | StringFieldRefInput<$PrismaModel>
    string_starts_with?: string | StringFieldRefInput<$PrismaModel>
    string_ends_with?: string | StringFieldRefInput<$PrismaModel>
    array_starts_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_ends_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_contains?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    lt?: InputJsonValue
    lte?: InputJsonValue
    gt?: InputJsonValue
    gte?: InputJsonValue
    not?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
  }

  export type GroupMetadataOrderByRelevanceInput = {
    fields: GroupMetadataOrderByRelevanceFieldEnum | GroupMetadataOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type GroupMetadataSessionIdIdCompoundUniqueInput = {
    sessionId: string
    id: string
  }

  export type GroupMetadataCountOrderByAggregateInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    id?: SortOrder
    owner?: SortOrder
    subject?: SortOrder
    subjectOwner?: SortOrder
    subjectTime?: SortOrder
    creation?: SortOrder
    desc?: SortOrder
    descOwner?: SortOrder
    descId?: SortOrder
    restrict?: SortOrder
    announce?: SortOrder
    isCommunity?: SortOrder
    isCommunityAnnounce?: SortOrder
    joinApprovalMode?: SortOrder
    memberAddMode?: SortOrder
    author?: SortOrder
    size?: SortOrder
    participants?: SortOrder
    ephemeralDuration?: SortOrder
    inviteCode?: SortOrder
  }

  export type GroupMetadataAvgOrderByAggregateInput = {
    pkId?: SortOrder
    subjectTime?: SortOrder
    creation?: SortOrder
    size?: SortOrder
    ephemeralDuration?: SortOrder
  }

  export type GroupMetadataMaxOrderByAggregateInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    id?: SortOrder
    owner?: SortOrder
    subject?: SortOrder
    subjectOwner?: SortOrder
    subjectTime?: SortOrder
    creation?: SortOrder
    desc?: SortOrder
    descOwner?: SortOrder
    descId?: SortOrder
    restrict?: SortOrder
    announce?: SortOrder
    isCommunity?: SortOrder
    isCommunityAnnounce?: SortOrder
    joinApprovalMode?: SortOrder
    memberAddMode?: SortOrder
    author?: SortOrder
    size?: SortOrder
    ephemeralDuration?: SortOrder
    inviteCode?: SortOrder
  }

  export type GroupMetadataMinOrderByAggregateInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    id?: SortOrder
    owner?: SortOrder
    subject?: SortOrder
    subjectOwner?: SortOrder
    subjectTime?: SortOrder
    creation?: SortOrder
    desc?: SortOrder
    descOwner?: SortOrder
    descId?: SortOrder
    restrict?: SortOrder
    announce?: SortOrder
    isCommunity?: SortOrder
    isCommunityAnnounce?: SortOrder
    joinApprovalMode?: SortOrder
    memberAddMode?: SortOrder
    author?: SortOrder
    size?: SortOrder
    ephemeralDuration?: SortOrder
    inviteCode?: SortOrder
  }

  export type GroupMetadataSumOrderByAggregateInput = {
    pkId?: SortOrder
    subjectTime?: SortOrder
    creation?: SortOrder
    size?: SortOrder
    ephemeralDuration?: SortOrder
  }
  export type JsonWithAggregatesFilter<$PrismaModel = never> =
    | PatchUndefined<
        Either<Required<JsonWithAggregatesFilterBase<$PrismaModel>>, Exclude<keyof Required<JsonWithAggregatesFilterBase<$PrismaModel>>, 'path'>>,
        Required<JsonWithAggregatesFilterBase<$PrismaModel>>
      >
    | OptionalFlat<Omit<Required<JsonWithAggregatesFilterBase<$PrismaModel>>, 'path'>>

  export type JsonWithAggregatesFilterBase<$PrismaModel = never> = {
    equals?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
    path?: string
    mode?: QueryMode | EnumQueryModeFieldRefInput<$PrismaModel>
    string_contains?: string | StringFieldRefInput<$PrismaModel>
    string_starts_with?: string | StringFieldRefInput<$PrismaModel>
    string_ends_with?: string | StringFieldRefInput<$PrismaModel>
    array_starts_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_ends_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_contains?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    lt?: InputJsonValue
    lte?: InputJsonValue
    gt?: InputJsonValue
    gte?: InputJsonValue
    not?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedJsonFilter<$PrismaModel>
    _max?: NestedJsonFilter<$PrismaModel>
  }

  export type MessageOrderByRelevanceInput = {
    fields: MessageOrderByRelevanceFieldEnum | MessageOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type MessageSessionIdRemoteJidIdCompoundUniqueInput = {
    sessionId: string
    remoteJid: string
    id: string
  }

  export type MessageCountOrderByAggregateInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    remoteJid?: SortOrder
    id?: SortOrder
    agentId?: SortOrder
    bizPrivacyStatus?: SortOrder
    broadcast?: SortOrder
    clearMedia?: SortOrder
    duration?: SortOrder
    ephemeralDuration?: SortOrder
    ephemeralOffToOn?: SortOrder
    ephemeralOutOfSync?: SortOrder
    ephemeralStartTimestamp?: SortOrder
    finalLiveLocation?: SortOrder
    futureproofData?: SortOrder
    ignore?: SortOrder
    keepInChat?: SortOrder
    key?: SortOrder
    labels?: SortOrder
    mediaCiphertextSha256?: SortOrder
    mediaData?: SortOrder
    message?: SortOrder
    messageC2STimestamp?: SortOrder
    messageSecret?: SortOrder
    messageStubParameters?: SortOrder
    messageStubType?: SortOrder
    messageTimestamp?: SortOrder
    multicast?: SortOrder
    originalSelfAuthorUserJidString?: SortOrder
    participant?: SortOrder
    paymentInfo?: SortOrder
    photoChange?: SortOrder
    pollAdditionalMetadata?: SortOrder
    pollUpdates?: SortOrder
    pushName?: SortOrder
    quotedPaymentInfo?: SortOrder
    quotedStickerData?: SortOrder
    reactions?: SortOrder
    revokeMessageTimestamp?: SortOrder
    starred?: SortOrder
    status?: SortOrder
    statusAlreadyViewed?: SortOrder
    statusPsa?: SortOrder
    urlNumber?: SortOrder
    urlText?: SortOrder
    userReceipt?: SortOrder
    verifiedBizName?: SortOrder
    eventResponses?: SortOrder
    pinInChat?: SortOrder
    reportingTokenInfo?: SortOrder
  }

  export type MessageAvgOrderByAggregateInput = {
    pkId?: SortOrder
    bizPrivacyStatus?: SortOrder
    duration?: SortOrder
    ephemeralDuration?: SortOrder
    ephemeralStartTimestamp?: SortOrder
    messageC2STimestamp?: SortOrder
    messageStubType?: SortOrder
    messageTimestamp?: SortOrder
    revokeMessageTimestamp?: SortOrder
    status?: SortOrder
  }

  export type MessageMaxOrderByAggregateInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    remoteJid?: SortOrder
    id?: SortOrder
    agentId?: SortOrder
    bizPrivacyStatus?: SortOrder
    broadcast?: SortOrder
    clearMedia?: SortOrder
    duration?: SortOrder
    ephemeralDuration?: SortOrder
    ephemeralOffToOn?: SortOrder
    ephemeralOutOfSync?: SortOrder
    ephemeralStartTimestamp?: SortOrder
    futureproofData?: SortOrder
    ignore?: SortOrder
    mediaCiphertextSha256?: SortOrder
    messageC2STimestamp?: SortOrder
    messageSecret?: SortOrder
    messageStubType?: SortOrder
    messageTimestamp?: SortOrder
    multicast?: SortOrder
    originalSelfAuthorUserJidString?: SortOrder
    participant?: SortOrder
    pushName?: SortOrder
    revokeMessageTimestamp?: SortOrder
    starred?: SortOrder
    status?: SortOrder
    statusAlreadyViewed?: SortOrder
    urlNumber?: SortOrder
    urlText?: SortOrder
    verifiedBizName?: SortOrder
  }

  export type MessageMinOrderByAggregateInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    remoteJid?: SortOrder
    id?: SortOrder
    agentId?: SortOrder
    bizPrivacyStatus?: SortOrder
    broadcast?: SortOrder
    clearMedia?: SortOrder
    duration?: SortOrder
    ephemeralDuration?: SortOrder
    ephemeralOffToOn?: SortOrder
    ephemeralOutOfSync?: SortOrder
    ephemeralStartTimestamp?: SortOrder
    futureproofData?: SortOrder
    ignore?: SortOrder
    mediaCiphertextSha256?: SortOrder
    messageC2STimestamp?: SortOrder
    messageSecret?: SortOrder
    messageStubType?: SortOrder
    messageTimestamp?: SortOrder
    multicast?: SortOrder
    originalSelfAuthorUserJidString?: SortOrder
    participant?: SortOrder
    pushName?: SortOrder
    revokeMessageTimestamp?: SortOrder
    starred?: SortOrder
    status?: SortOrder
    statusAlreadyViewed?: SortOrder
    urlNumber?: SortOrder
    urlText?: SortOrder
    verifiedBizName?: SortOrder
  }

  export type MessageSumOrderByAggregateInput = {
    pkId?: SortOrder
    bizPrivacyStatus?: SortOrder
    duration?: SortOrder
    ephemeralDuration?: SortOrder
    ephemeralStartTimestamp?: SortOrder
    messageC2STimestamp?: SortOrder
    messageStubType?: SortOrder
    messageTimestamp?: SortOrder
    revokeMessageTimestamp?: SortOrder
    status?: SortOrder
  }

  export type SessionOrderByRelevanceInput = {
    fields: SessionOrderByRelevanceFieldEnum | SessionOrderByRelevanceFieldEnum[]
    sort: SortOrder
    search: string
  }

  export type SessionSessionIdIdCompoundUniqueInput = {
    sessionId: string
    id: string
  }

  export type SessionCountOrderByAggregateInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    id?: SortOrder
    data?: SortOrder
  }

  export type SessionAvgOrderByAggregateInput = {
    pkId?: SortOrder
  }

  export type SessionMaxOrderByAggregateInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    id?: SortOrder
    data?: SortOrder
  }

  export type SessionMinOrderByAggregateInput = {
    pkId?: SortOrder
    sessionId?: SortOrder
    id?: SortOrder
    data?: SortOrder
  }

  export type SessionSumOrderByAggregateInput = {
    pkId?: SortOrder
  }

  export type StringFieldUpdateOperationsInput = {
    set?: string
  }

  export type NullableBoolFieldUpdateOperationsInput = {
    set?: boolean | null
  }

  export type NullableBytesFieldUpdateOperationsInput = {
    set?: Uint8Array | null
  }

  export type NullableBigIntFieldUpdateOperationsInput = {
    set?: bigint | number | null
    increment?: bigint | number
    decrement?: bigint | number
    multiply?: bigint | number
    divide?: bigint | number
  }

  export type NullableStringFieldUpdateOperationsInput = {
    set?: string | null
  }

  export type NullableIntFieldUpdateOperationsInput = {
    set?: number | null
    increment?: number
    decrement?: number
    multiply?: number
    divide?: number
  }

  export type IntFieldUpdateOperationsInput = {
    set?: number
    increment?: number
    decrement?: number
    multiply?: number
    divide?: number
  }

  export type NestedIntFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntFilter<$PrismaModel> | number
  }

  export type NestedStringFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringFilter<$PrismaModel> | string
  }

  export type NestedBoolNullableFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel> | null
    not?: NestedBoolNullableFilter<$PrismaModel> | boolean | null
  }

  export type NestedBytesNullableFilter<$PrismaModel = never> = {
    equals?: Uint8Array | BytesFieldRefInput<$PrismaModel> | null
    in?: Uint8Array[] | null
    notIn?: Uint8Array[] | null
    not?: NestedBytesNullableFilter<$PrismaModel> | Uint8Array | null
  }

  export type NestedBigIntNullableFilter<$PrismaModel = never> = {
    equals?: bigint | number | BigIntFieldRefInput<$PrismaModel> | null
    in?: bigint[] | number[] | null
    notIn?: bigint[] | number[] | null
    lt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    lte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    not?: NestedBigIntNullableFilter<$PrismaModel> | bigint | number | null
  }

  export type NestedStringNullableFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringNullableFilter<$PrismaModel> | string | null
  }

  export type NestedIntNullableFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | null
    notIn?: number[] | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableFilter<$PrismaModel> | number | null
  }

  export type NestedIntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedIntFilter<$PrismaModel>
    _min?: NestedIntFilter<$PrismaModel>
    _max?: NestedIntFilter<$PrismaModel>
  }

  export type NestedFloatFilter<$PrismaModel = never> = {
    equals?: number | FloatFieldRefInput<$PrismaModel>
    in?: number[]
    notIn?: number[]
    lt?: number | FloatFieldRefInput<$PrismaModel>
    lte?: number | FloatFieldRefInput<$PrismaModel>
    gt?: number | FloatFieldRefInput<$PrismaModel>
    gte?: number | FloatFieldRefInput<$PrismaModel>
    not?: NestedFloatFilter<$PrismaModel> | number
  }

  export type NestedStringWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[]
    notIn?: string[]
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringWithAggregatesFilter<$PrismaModel> | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedStringFilter<$PrismaModel>
    _max?: NestedStringFilter<$PrismaModel>
  }

  export type NestedBoolNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel> | null
    not?: NestedBoolNullableWithAggregatesFilter<$PrismaModel> | boolean | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedBoolNullableFilter<$PrismaModel>
    _max?: NestedBoolNullableFilter<$PrismaModel>
  }

  export type NestedBytesNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Uint8Array | BytesFieldRefInput<$PrismaModel> | null
    in?: Uint8Array[] | null
    notIn?: Uint8Array[] | null
    not?: NestedBytesNullableWithAggregatesFilter<$PrismaModel> | Uint8Array | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedBytesNullableFilter<$PrismaModel>
    _max?: NestedBytesNullableFilter<$PrismaModel>
  }

  export type NestedBigIntNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: bigint | number | BigIntFieldRefInput<$PrismaModel> | null
    in?: bigint[] | number[] | null
    notIn?: bigint[] | number[] | null
    lt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    lte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gt?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    gte?: bigint | number | BigIntFieldRefInput<$PrismaModel>
    not?: NestedBigIntNullableWithAggregatesFilter<$PrismaModel> | bigint | number | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _avg?: NestedFloatNullableFilter<$PrismaModel>
    _sum?: NestedBigIntNullableFilter<$PrismaModel>
    _min?: NestedBigIntNullableFilter<$PrismaModel>
    _max?: NestedBigIntNullableFilter<$PrismaModel>
  }

  export type NestedFloatNullableFilter<$PrismaModel = never> = {
    equals?: number | FloatFieldRefInput<$PrismaModel> | null
    in?: number[] | null
    notIn?: number[] | null
    lt?: number | FloatFieldRefInput<$PrismaModel>
    lte?: number | FloatFieldRefInput<$PrismaModel>
    gt?: number | FloatFieldRefInput<$PrismaModel>
    gte?: number | FloatFieldRefInput<$PrismaModel>
    not?: NestedFloatNullableFilter<$PrismaModel> | number | null
  }

  export type NestedStringNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | null
    notIn?: string[] | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    search?: string
    not?: NestedStringNullableWithAggregatesFilter<$PrismaModel> | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedStringNullableFilter<$PrismaModel>
    _max?: NestedStringNullableFilter<$PrismaModel>
  }
  export type NestedJsonNullableFilter<$PrismaModel = never> =
    | PatchUndefined<
        Either<Required<NestedJsonNullableFilterBase<$PrismaModel>>, Exclude<keyof Required<NestedJsonNullableFilterBase<$PrismaModel>>, 'path'>>,
        Required<NestedJsonNullableFilterBase<$PrismaModel>>
      >
    | OptionalFlat<Omit<Required<NestedJsonNullableFilterBase<$PrismaModel>>, 'path'>>

  export type NestedJsonNullableFilterBase<$PrismaModel = never> = {
    equals?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
    path?: string
    mode?: QueryMode | EnumQueryModeFieldRefInput<$PrismaModel>
    string_contains?: string | StringFieldRefInput<$PrismaModel>
    string_starts_with?: string | StringFieldRefInput<$PrismaModel>
    string_ends_with?: string | StringFieldRefInput<$PrismaModel>
    array_starts_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_ends_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_contains?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    lt?: InputJsonValue
    lte?: InputJsonValue
    gt?: InputJsonValue
    gte?: InputJsonValue
    not?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
  }

  export type NestedIntNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | null
    notIn?: number[] | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableWithAggregatesFilter<$PrismaModel> | number | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _avg?: NestedFloatNullableFilter<$PrismaModel>
    _sum?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedIntNullableFilter<$PrismaModel>
    _max?: NestedIntNullableFilter<$PrismaModel>
  }
  export type NestedJsonFilter<$PrismaModel = never> =
    | PatchUndefined<
        Either<Required<NestedJsonFilterBase<$PrismaModel>>, Exclude<keyof Required<NestedJsonFilterBase<$PrismaModel>>, 'path'>>,
        Required<NestedJsonFilterBase<$PrismaModel>>
      >
    | OptionalFlat<Omit<Required<NestedJsonFilterBase<$PrismaModel>>, 'path'>>

  export type NestedJsonFilterBase<$PrismaModel = never> = {
    equals?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
    path?: string
    mode?: QueryMode | EnumQueryModeFieldRefInput<$PrismaModel>
    string_contains?: string | StringFieldRefInput<$PrismaModel>
    string_starts_with?: string | StringFieldRefInput<$PrismaModel>
    string_ends_with?: string | StringFieldRefInput<$PrismaModel>
    array_starts_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_ends_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_contains?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    lt?: InputJsonValue
    lte?: InputJsonValue
    gt?: InputJsonValue
    gte?: InputJsonValue
    not?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
  }



  /**
   * Batch Payload for updateMany & deleteMany & createMany
   */

  export type BatchPayload = {
    count: number
  }

  /**
   * DMMF
   */
  export const dmmf: runtime.BaseDMMF
}